/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.lineset;

import com.huawei.core.util.TENameValuePair;
import com.huawei.core.util.table.TENormalTable;
import com.huawei.core.util.table.TENormalTableModel;
import com.huawei.imap12.utility.InmButton;
import com.huawei.imap12.utility.table.InmTableColumnModel;
import com.huawei.u2000.umcommon.component.dialog.UMAbstractInternalDialog;
import com.huawei.u2000.umcommon.component.lineset.UMLineSetResourceUtil;
import com.huawei.u2000.umcommon.component.lineset.base.UMLineStroke;
import com.huawei.u2000.umcommon.component.lineset.base.UMLineTypeBox;
import com.huawei.u2000.umcommon.component.lineset.base.UMLineWidthBox;
import com.huawei.u2000.umcommon.component.lineset.base.UMTopoStroke;
import com.huawei.u2000.umcommon.component.lineset.datastruct.UMLineSetDataObj;
import com.huawei.u2000.umcommon.component.lineset.datastruct.UMLineSetStruct;
import com.huawei.u2000.util.UMLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class UMLineSetDefaultAttributeDialog
extends UMAbstractInternalDialog {
    private static final long serialVersionUID = 1036671902558291645L;
    private static final String fileDir = "u2000/lineset/profile/linetemplate.ini";
    private TENormalTableModel tableModle = null;
    private TENormalTable table = null;
    private InmButton okButton = new InmButton(InmButton.OK_TEXT_PROPERTY);
    private InmButton cancelButton = new InmButton(InmButton.CANCEL_TEXT_PROPERTY);
    private InmButton applyButton = new InmButton(InmButton.APPLY_TEXT_PROPERTY);
    private InmButton defaultButton = new InmButton(UMLineSetResourceUtil.getResource("DEFAULT"));
    List<UMLineSetDataObj> dataList = new ArrayList<UMLineSetDataObj>();
    public static final int LINE_TYPE_NAME_COL = 0;
    public static final int LINE_TYPE_COL = 1;
    public static final int LINE_WIDTH_COL = 2;
    public static final int DEFAULT_STEP_LEN = 1;
    private boolean isDataChange = false;

    public UMLineSetDefaultAttributeDialog(List<UMLineSetDataObj> list) {
        this.initUI();
        this.initTableData(list);
        this.setResizable(false);
        this.setModal(false);
    }

    public UMLineSetDefaultAttributeDialog() {
        this.initUI();
        this.setResizable(false);
        this.setModal(false);
    }

    public final void initTableData(List<UMLineSetDataObj> list) {
        List dataLst = this.convertUMLineSetDataObjToVector(list);
        this.tableModle.getDataVector().addAll(dataLst);
        this.tableModle.fireTableDataChanged();
    }

    private void initLineTemplateTable() {
        UMLineDefaultComboboxItemListerner itemListener = new UMLineDefaultComboboxItemListerner();
        InmTableColumnModel tableColumnModel = (InmTableColumnModel)this.table.getColumnModel();
        block4: for (int iColumnTmp = 0; iColumnTmp < tableColumnModel.getColumnCount_(); ++iColumnTmp) {
            TableColumn column = tableColumnModel.getColumn_(iColumnTmp);
            switch (iColumnTmp) {
                case 1: {
                    UMLineTypeBox lineTypeBoxTmp = new UMLineTypeBox(140);
                    lineTypeBoxTmp.addItemListener(itemListener);
                    column.setCellEditor(new UMLineTypeCellEditor(lineTypeBoxTmp));
                    column.setCellRenderer(new UMLineTypeCellRenderer(new UMLineTypeBox(140)));
                    continue block4;
                }
                case 2: {
                    UMLineWidthBox lineWidthBoxTmp = new UMLineWidthBox(140);
                    lineWidthBoxTmp.addItemListener(itemListener);
                    column.setCellEditor(new UMLineWidthCellEditor(lineWidthBoxTmp));
                    column.setCellRenderer(new UMLineWidthCellRenderer(new UMLineWidthBox(140)));
                    continue block4;
                }
            }
        }
    }

    private List convertUMLineSetDataObjToVector(List<UMLineSetDataObj> list) {
        Vector dataVector = new Vector();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Vector<Object> vector = new Vector<Object>();
            UMLineSetDataObj lineSetDataObj = list.get(i);
            vector.add(lineSetDataObj.getType());
            vector.add(UMLineStroke.getInstance().getStroke(this.changeValueToComponentValue(lineSetDataObj.getLineSetStruct().getLineType())));
            vector.add(new UMTopoStroke(lineSetDataObj.getLineSetStruct().getLineWidth(), 0, 0));
            vector.add(lineSetDataObj);
            dataVector.add(vector);
        }
        return dataVector;
    }

    private int changeValueToComponentValue(int iValue) {
        if (iValue < 1) {
            return 0;
        }
        return iValue - 1;
    }

    private void initUI() {
        this.tableModle = new TENormalTableModel("LinkDefaultStyle", fileDir);
        this.table = new TENormalTable(this.tableModle, false);
        this.initLineTemplateTable();
        this.initComponent();
        this.setSize(600, 450);
        this.setResizable(false);
        this.setTitle(UMLineSetResourceUtil.getResource("LINE_TEMPLATE_TITLE"));
        this.setFont(new Font("Dialog", 0, 12));
        JPanel pnlBottomPnl = new JPanel();
        pnlBottomPnl.setLayout(new FlowLayout(2));
        pnlBottomPnl.add((Component)this.defaultButton);
        pnlBottomPnl.add((Component)this.okButton);
        pnlBottomPnl.add((Component)this.cancelButton);
        pnlBottomPnl.add((Component)this.applyButton);
        JScrollPane batchSCPane = new JScrollPane();
        batchSCPane.setViewportView((Component)this.table);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)batchSCPane, "Center");
        mainPanel.add((Component)pnlBottomPnl, "South");
        this.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)mainPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.setDefaultCloseOperation(2);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent event) {
                UMLineSetDefaultAttributeDialog.this.cancelButton.requestFocus();
            }
        });
        this.applyButton.setEnabled(false);
        this.isDataChange = false;
    }

    private void initComponent() {
        UMLineDefaultAttributeSetAction lineSetAction = new UMLineDefaultAttributeSetAction();
        this.defaultButton.addActionListener((ActionListener)lineSetAction);
        this.okButton.addActionListener((ActionListener)lineSetAction);
        this.cancelButton.addActionListener((ActionListener)lineSetAction);
        this.applyButton.addActionListener((ActionListener)lineSetAction);
    }

    private void onOk() {
        if (!this.isDataChange) {
            this.setVisible(false);
            this.dispose();
        } else if (this.setLineDefaultAttibute(this.getLineSetData())) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public abstract boolean setLineDefaultAttibute(List<UMLineSetDataObj> var1);

    public void onApply() {
        if (this.setLineDefaultAttibute(this.getLineSetData())) {
            this.applyButton.setEnabled(false);
            this.isDataChange = false;
        }
    }

    private List<UMLineSetDataObj> getLineSetData() {
        Vector dataVector = this.tableModle.getDataVector();
        Vector rowVector = null;
        ArrayList<UMLineSetDataObj> lineSetDataLst = new ArrayList<UMLineSetDataObj>();
        int size = dataVector.size();
        for (int i = 0; i < size; ++i) {
            rowVector = (Vector)dataVector.get(i);
            UMLineSetDataObj lineDataObj = new UMLineSetDataObj();
            lineDataObj.setType((TENameValuePair)rowVector.get(0));
            UMLineSetStruct lineStruct = new UMLineSetStruct();
            UMTopoStroke lineTypeStroke = (UMTopoStroke)rowVector.get(1);
            lineStruct.setLineType(lineTypeStroke.getSelectLineType() + 1);
            UMTopoStroke lineWidthStroke = (UMTopoStroke)rowVector.get(2);
            lineStruct.setLineWidth(lineWidthStroke.getSelectLineWidth());
            lineDataObj.setLineSetStruct(lineStruct);
            lineSetDataLst.add(lineDataObj);
        }
        return lineSetDataLst;
    }

    private void onCancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void onDefault() {
        Vector dataVector = this.tableModle.getDataVector();
        Vector rowVector = null;
        int size = dataVector.size();
        for (int i = 0; i < size; ++i) {
            rowVector = (Vector)dataVector.get(i);
            rowVector.setElementAt(UMLineStroke.getInstance().getStrock0(), 1);
            rowVector.setElementAt(new UMTopoStroke(1, 0, 0), 2);
        }
        this.tableModle.fireTableDataChanged();
    }

    private class UMLineWidthCellRenderer
    implements TableCellRenderer {
        private UMLineWidthBox lineWidthBoxCell = null;

        public UMLineWidthCellRenderer(UMLineWidthBox combo) {
            this.lineWidthBoxCell = combo;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof UMTopoStroke) {
                this.lineWidthBoxCell.setSelectedItem((UMTopoStroke)value);
            }
            if (isSelected) {
                this.lineWidthBoxCell.setForeground(table.getForeground());
                this.lineWidthBoxCell.setBackground(table.getBackground());
            }
            return this.lineWidthBoxCell;
        }
    }

    private class UMLineWidthCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 2451601892285093589L;
        private UMLineWidthBox lineWidthBoxCell;

        public UMLineWidthCellEditor(UMLineWidthBox combo) {
            super(combo);
            this.lineWidthBoxCell = null;
            this.lineWidthBoxCell = combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jtable, Object obj, boolean flag, int i, int j) {
            if (obj instanceof UMTopoStroke) {
                this.lineWidthBoxCell.setSelectedItem((UMTopoStroke)obj);
            }
            return this.lineWidthBoxCell;
        }
    }

    private class UMLineTypeCellRenderer
    implements TableCellRenderer {
        private UMLineTypeBox lineTypeBoxCell = null;

        public UMLineTypeCellRenderer(UMLineTypeBox combo) {
            this.lineTypeBoxCell = combo;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Stroke) {
                this.lineTypeBoxCell.setSelectedItem((Stroke)value);
            }
            if (isSelected) {
                this.lineTypeBoxCell.setForeground(table.getForeground());
                this.lineTypeBoxCell.setBackground(table.getBackground());
            }
            return this.lineTypeBoxCell;
        }
    }

    private class UMLineTypeCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 2451601892285093589L;
        private UMLineTypeBox lineTypeBoxCell;

        public UMLineTypeCellEditor(UMLineTypeBox combo) {
            super(combo);
            this.lineTypeBoxCell = null;
            this.lineTypeBoxCell = combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jtable, Object obj, boolean flag, int i, int j) {
            if (obj instanceof Stroke) {
                this.lineTypeBoxCell.setSelectedItem((Stroke)obj);
            }
            return this.lineTypeBoxCell;
        }
    }

    private class UMLineDefaultAttributeSetAction
    implements ActionListener {
        private UMLineDefaultAttributeSetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == UMLineSetDefaultAttributeDialog.this.okButton) {
                UMLineSetDefaultAttributeDialog.this.onOk();
            } else if (actionEvent.getSource() == UMLineSetDefaultAttributeDialog.this.cancelButton) {
                UMLineSetDefaultAttributeDialog.this.onCancel();
            } else if (actionEvent.getSource() == UMLineSetDefaultAttributeDialog.this.applyButton) {
                UMLineSetDefaultAttributeDialog.this.onApply();
            } else if (actionEvent.getSource() == UMLineSetDefaultAttributeDialog.this.defaultButton) {
                UMLineSetDefaultAttributeDialog.this.onDefault();
                UMLineSetDefaultAttributeDialog.this.applyButton.setEnabled(true);
                UMLineSetDefaultAttributeDialog.this.isDataChange = true;
            } else {
                UMLogger.debug(" UMLineDefaultAttributeSetAction, actionPerformed others. ");
            }
        }
    }

    private class UMLineDefaultComboboxItemListerner
    implements ItemListener {
        private UMLineDefaultComboboxItemListerner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            UMLineSetDefaultAttributeDialog.this.applyButton.setEnabled(true);
            UMLineSetDefaultAttributeDialog.this.isDataChange = true;
        }
    }
}

