/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.devicetree.collector;

import com.huawei.u2000.component.tree.GeneralObjectTreeFindCondition;
import com.huawei.u2000.component.tree.GeneralObjectTreeNodeStruct;
import com.huawei.u2000.inf.devicetree.DeviceTreeData;
import com.huawei.u2000.inf.devicetree.IDeviceTreeData;
import com.huawei.u2000.inf.devicetree.IDeviceTreeDataCollector;
import com.huawei.u2000.inf.devicetree.IFunctionEnvironment;
import com.huawei.u2000.umcommon.component.devicetree.DeviceTreeUtil;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.topo.adapter.message.EmfTopoNodeInfo;
import com.swimap.external.topo.adapter.message.EmfTopoSubmapInfo;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class UMDeviceTreeDataCollector
implements IDeviceTreeDataCollector {
    private static final int UNVILAIBLE_SUBDEV_TYPE = -1;
    private String funKey = "";
    public static final String DEFAULT_FUNKEY = "defaultFunction";
    private int[] devTypeList = null;
    private int[] subDevTypeList = null;
    private static final String FUNCTION_CONF_PATH = "conf/ext_u2000_unitedmgr/objecttreexthirdparyneconf";
    private GeneralObjectTreeNodeStruct thirdPartyTreeRoot = null;
    Map<String, GeneralObjectTreeNodeStruct> submapBuffer = new HashMap<String, GeneralObjectTreeNodeStruct>();
    public static final String DEV_TYPE_NAME = "devtypename";
    public static final String THIRD_PARTY_NAME = "3rd-Party";

    public UMDeviceTreeDataCollector() {
        this(DEFAULT_FUNKEY);
    }

    public UMDeviceTreeDataCollector(String funKey) {
        this.funKey = funKey;
        this.initDeviceType();
    }

    private void initDeviceType() {
        CommStyleInfo progressbarConf = CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyle(FUNCTION_CONF_PATH);
        AreaDescContainer area = progressbarConf.getAreaDescContainer(0);
        DescContainer desc = area.getDescContainer(this.funKey);
        String strDevTypeList = "";
        String strSubDevTypeList = "";
        try {
            PARA para = desc.getParasItem(0);
            strDevTypeList = para.getValue();
            para = desc.getParasItem(1);
            strSubDevTypeList = para.getValue();
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
        }
        this.devTypeList = this.formatDevType(strDevTypeList);
        this.subDevTypeList = this.formatDevType(strSubDevTypeList);
    }

    private int[] formatDevType(String strTypeList) {
        StringTokenizer tokenizer = new StringTokenizer(null != strTypeList ? strTypeList : "", ",");
        int tokenCount = tokenizer.countTokens();
        int[] typeList = new int[tokenCount];
        String tempStrType = "";
        for (int i = 0; i < tokenCount; ++i) {
            if (!tokenizer.hasMoreTokens()) continue;
            tempStrType = tokenizer.nextToken();
            typeList[i] = Integer.parseInt(tempStrType);
        }
        return typeList;
    }

    private boolean isThirdPartDev(int devType, int subDevType) {
        for (int i = 0; i < this.devTypeList.length; ++i) {
            if (this.devTypeList[i] != devType || this.subDevTypeList[i] != subDevType && -1 != this.subDevTypeList[i]) continue;
            return true;
        }
        return false;
    }

    private GeneralObjectTreeNodeStruct buildThirdPartyTreeAndSubnetMap(DefaultMutableTreeNode node, Map<String, GeneralObjectTreeNodeStruct> submapBuffer) {
        if (node == null) {
            return null;
        }
        GeneralObjectTreeNodeStruct rsData = null;
        int devType = -1;
        int devSbuType = -1;
        Object obj = node.getUserObject();
        if (obj instanceof EmfTopoSubmapInfo) {
            EmfTopoSubmapInfo submapInfo = (EmfTopoSubmapInfo)obj;
            DeviceTreeData submapData = new DeviceTreeData(true, "", submapInfo.m_szLabel, submapInfo.m_szID);
            rsData = new GeneralObjectTreeNodeStruct();
            rsData.setValue((Object)submapData);
            rsData.setName(submapInfo.m_szLabel);
            rsData.setHasChildren(true);
            submapBuffer.put(submapInfo.m_szID, rsData);
        } else if (obj instanceof EmfTopoNodeInfo) {
            EmfTopoNodeInfo currentNode = (EmfTopoNodeInfo)obj;
            devType = null == currentNode.m_szDevType ? -1 : Integer.parseInt(currentNode.m_szDevType);
            int n = devSbuType = null == currentNode.m_szDevVer ? -1 : Integer.parseInt(currentNode.m_szDevVer);
            if (this.isThirdPartDev(devType, devSbuType)) {
                DeviceTreeData currenNodeData = new DeviceTreeData(false, currentNode.m_szID, currentNode.m_szLabel, "");
                this.setDevTypeNameInfo(devType, currenNodeData);
                rsData = new GeneralObjectTreeNodeStruct();
                rsData.setValue((Object)currenNodeData);
                rsData.setName(currentNode.m_szLabel);
                rsData.setHasChildren(false);
            }
        }
        ArrayList<GeneralObjectTreeNodeStruct> newChildrenList = new ArrayList<GeneralObjectTreeNodeStruct>();
        Enumeration<TreeNode> enume = node.children();
        if (enume != null) {
            while (enume.hasMoreElements()) {
                DefaultMutableTreeNode oldNodeTmp = (DefaultMutableTreeNode)enume.nextElement();
                GeneralObjectTreeNodeStruct newNodeDataTmp = this.buildThirdPartyTreeAndSubnetMap(oldNodeTmp, submapBuffer);
                if (null == newNodeDataTmp) continue;
                newChildrenList.add(newNodeDataTmp);
                newNodeDataTmp.setParent(rsData);
            }
        }
        if (!newChildrenList.isEmpty()) {
            rsData.setChildren(newChildrenList);
        }
        return rsData;
    }

    private void setDevTypeNameInfo(int devTypeID, DeviceTreeData currenNodeData) {
        if (256 == devTypeID) {
            Map<String, String> extendMap = currenNodeData.getExtendMap();
            if (null == extendMap) {
                extendMap = new HashMap<String, String>();
                currenNodeData.setExtendMap(extendMap);
            }
            extendMap.put(DEV_TYPE_NAME, THIRD_PARTY_NAME);
        }
    }

    @Override
    public List<GeneralObjectTreeNodeStruct> findObjectTreeDatas(GeneralObjectTreeFindCondition condittion, IFunctionEnvironment funEnvironment) {
        Map conditions = condittion.getConditions();
        String searchType = (String)conditions.get("searchType");
        String searchValue = (String)conditions.get("searchValue");
        ArrayList<GeneralObjectTreeNodeStruct> thirdParyDevsResult = new ArrayList<GeneralObjectTreeNodeStruct>();
        if (null != searchValue) {
            if ("ne".equals(searchType)) {
                this.getThirdPartyByNeNameCondition(thirdParyDevsResult, this.thirdPartyTreeRoot, searchValue.toUpperCase());
                return thirdParyDevsResult;
            }
            if ("netype".equals(searchType)) {
                this.getThirdPartyByNeTypeNameCondition(thirdParyDevsResult, this.thirdPartyTreeRoot, searchValue.toUpperCase());
                return thirdParyDevsResult;
            }
        }
        return null;
    }

    private void getThirdPartyByNeNameCondition(List<GeneralObjectTreeNodeStruct> nodeList, GeneralObjectTreeNodeStruct currentNode, String neNameKey) {
        if (!((IDeviceTreeData)currentNode.getValue()).isSubmap()) {
            if (currentNode.getName().toUpperCase().indexOf(neNameKey) > -1) {
                currentNode.setFindTargetNode(true);
                nodeList.add(currentNode);
            }
        } else if (null != currentNode.getChildren()) {
            for (GeneralObjectTreeNodeStruct child : currentNode.getChildren()) {
                this.getThirdPartyByNeNameCondition(nodeList, child, neNameKey);
            }
        }
    }

    private void getThirdPartyByNeTypeNameCondition(List<GeneralObjectTreeNodeStruct> nodeList, GeneralObjectTreeNodeStruct currentNode, String neTypeName) {
        if (!((IDeviceTreeData)currentNode.getValue()).isSubmap()) {
            IDeviceTreeData treeData = (IDeviceTreeData)currentNode.getValue();
            String strTypeName = treeData.getExtendMap().get(DEV_TYPE_NAME);
            if (null != strTypeName && strTypeName.toUpperCase().indexOf(neTypeName) > -1) {
                currentNode.setFindTargetNode(true);
                currentNode.set("searchResultSecondColumnName", (Object)strTypeName);
                nodeList.add(currentNode);
            }
        } else if (null != currentNode.getChildren()) {
            for (GeneralObjectTreeNodeStruct child : currentNode.getChildren()) {
                this.getThirdPartyByNeTypeNameCondition(nodeList, child, neTypeName);
            }
        }
    }

    @Override
    public List<GeneralObjectTreeNodeStruct> getNEOnTopo(IFunctionEnvironment funEnvironment) {
        this.thirdPartyTreeRoot = this.buildThirdPartyTreeAndSubnetMap(DeviceTreeUtil.getTopoRoot(), this.submapBuffer);
        return this.getThirdPartDevs(this.thirdPartyTreeRoot.getChildren());
    }

    private List<GeneralObjectTreeNodeStruct> getThirdPartDevs(List<GeneralObjectTreeNodeStruct> nodeList) {
        ArrayList<GeneralObjectTreeNodeStruct> thirdPartyNodeList = new ArrayList<GeneralObjectTreeNodeStruct>();
        if (null == nodeList) {
            return thirdPartyNodeList;
        }
        for (GeneralObjectTreeNodeStruct node : nodeList) {
            if (((IDeviceTreeData)node.getValue()).isSubmap()) continue;
            thirdPartyNodeList.add(node);
        }
        return thirdPartyNodeList;
    }

    @Override
    public List<GeneralObjectTreeNodeStruct> loadNEUnderSubmap(List<GeneralObjectTreeNodeStruct> delayLoadDataList, IFunctionEnvironment funEnvironment) {
        if (null == delayLoadDataList) {
            return new ArrayList<GeneralObjectTreeNodeStruct>();
        }
        for (GeneralObjectTreeNodeStruct node : delayLoadDataList) {
            IDeviceTreeData devData = (IDeviceTreeData)node.getValue();
            if (!devData.isSubmap()) continue;
            if (funEnvironment.getDelayLoagFlag()) {
                node.setChildren(this.getChildren(this.submapBuffer.get(devData.getSubmapID()).getChildren(), false));
                continue;
            }
            node.setChildren(this.getChildren(this.submapBuffer.get(devData.getSubmapID()).getChildren(), true));
        }
        return delayLoadDataList;
    }

    private List<GeneralObjectTreeNodeStruct> getChildren(List<GeneralObjectTreeNodeStruct> children, boolean isContainSubnet) {
        if (null == children) {
            return null;
        }
        List<GeneralObjectTreeNodeStruct> newChildren = null;
        if (isContainSubnet) {
            newChildren = children;
        } else {
            newChildren = new ArrayList<GeneralObjectTreeNodeStruct>();
            for (GeneralObjectTreeNodeStruct child : children) {
                if (((IDeviceTreeData)child.getValue()).isSubmap()) continue;
                newChildren.add(child);
            }
        }
        return newChildren;
    }
}

