/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.devicetree;

import com.huawei.imap12.topo.InmTopoUtil;
import com.huawei.imap12.utility.log.InmLogging;
import com.huawei.u2000.basetool.uid.StrUIDFactory;
import com.huawei.u2000.component.tree.GeneralObjectTreeNodeStruct;
import com.huawei.u2000.inf.devicetree.DeviceTreeData;
import com.huawei.u2000.inf.devicetree.IDeviceTreeData;
import com.huawei.u2000.util.UMFDNUtil;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.topo.adapter.message.EmfTopoContainerInfo;
import com.swimap.external.topo.adapter.message.EmfTopoInterface;
import com.swimap.external.topo.adapter.message.EmfTopoNodeInfo;
import com.swimap.external.topo.adapter.message.EmfTopoResource;
import com.swimap.external.topo.adapter.message.EmfTopoSubmapInfo;
import com.swimap.external.topo.adapter.message.EmfTopoTreeModelFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public final class DeviceTreeUtil {
    private static final int UNINVALAIBLE_FDN_NE_ID = 0;
    private static Map<String, GeneralObjectTreeNodeStruct> nodeInfoMap = new HashMap<String, GeneralObjectTreeNodeStruct>();

    private DeviceTreeUtil() {
    }

    public static GeneralObjectTreeNodeStruct fillSubmapBuffer(Map<String, GeneralObjectTreeNodeStruct> submapBuffer) {
        submapBuffer.clear();
        return DeviceTreeUtil.buildSubmapTree(DeviceTreeUtil.getTopoRoot(), submapBuffer);
    }

    public static DefaultMutableTreeNode getTopoRoot() {
        EmfTopoInterface topoInterface = null;
        try {
            topoInterface = InmTopoUtil.getTopoInterface();
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
        }
        if (null == topoInterface) {
            return null;
        }
        int[] phyViewID = new int[]{101};
        DefaultTreeModel[] treeModel = topoInterface.getTopoTreeModel(phyViewID, (EmfTopoTreeModelFilter)null);
        return (DefaultMutableTreeNode)treeModel[0].getRoot();
    }

    public static List<GeneralObjectTreeNodeStruct> copySubmap(List<GeneralObjectTreeNodeStruct> inputSubmapList) {
        if (inputSubmapList == null) {
            return new ArrayList<GeneralObjectTreeNodeStruct>();
        }
        ArrayList<GeneralObjectTreeNodeStruct> resultSubmapList = new ArrayList<GeneralObjectTreeNodeStruct>();
        GeneralObjectTreeNodeStruct resultSubmap = null;
        for (GeneralObjectTreeNodeStruct submap : inputSubmapList) {
            resultSubmap = new GeneralObjectTreeNodeStruct();
            resultSubmap.setHasChildren(true);
            resultSubmap.setName(submap.getName());
            resultSubmap.setValue(submap.getValue());
            resultSubmapList.add(resultSubmap);
        }
        Collections.sort(resultSubmapList);
        return resultSubmapList;
    }

    private static GeneralObjectTreeNodeStruct buildSubmapTree(DefaultMutableTreeNode node, Map<String, GeneralObjectTreeNodeStruct> submapBuffer) {
        if (node == null) {
            return null;
        }
        GeneralObjectTreeNodeStruct rsData = null;
        Object obj = node.getUserObject();
        if (obj instanceof EmfTopoSubmapInfo) {
            EmfTopoSubmapInfo submapInfo = (EmfTopoSubmapInfo)obj;
            DeviceTreeData submapData = new DeviceTreeData(true, "", submapInfo.m_szLabel, submapInfo.m_szID);
            rsData = new GeneralObjectTreeNodeStruct();
            rsData.setValue((Object)submapData);
            rsData.setName(submapInfo.m_szLabel);
            rsData.setHasChildren(true);
            submapBuffer.put(submapInfo.m_szID, rsData);
        }
        ArrayList<GeneralObjectTreeNodeStruct> newChildrenList = new ArrayList<GeneralObjectTreeNodeStruct>();
        Enumeration<TreeNode> enume = node.children();
        if (enume != null) {
            while (enume.hasMoreElements()) {
                DefaultMutableTreeNode oldNodeTmp = (DefaultMutableTreeNode)enume.nextElement();
                GeneralObjectTreeNodeStruct newNodeDataTmp = DeviceTreeUtil.buildSubmapTree(oldNodeTmp, submapBuffer);
                if (null == newNodeDataTmp) continue;
                newChildrenList.add(newNodeDataTmp);
                newNodeDataTmp.setParent(rsData);
            }
        }
        if (!newChildrenList.isEmpty()) {
            rsData.setChildren(newChildrenList);
        }
        return rsData;
    }

    public static List<GeneralObjectTreeNodeStruct> buildTreeFromTopo(List<GeneralObjectTreeNodeStruct> neInfoList) {
        long buildTreeFromTopoStartTime = System.currentTimeMillis();
        UMLogger.debug("[object tree log]Build tree from topo Start!");
        List resultDataList = new ArrayList();
        Map<String, GeneralObjectTreeNodeStruct> showNEInfoMap = DeviceTreeUtil.adapterNEToNEMap(neInfoList);
        GeneralObjectTreeNodeStruct rootData = DeviceTreeUtil.getTreeModelDataFromTopo(null);
        if (rootData != null) {
            DeviceTreeUtil.trimTreeNode(rootData, showNEInfoMap);
            resultDataList = rootData.getChildren();
        }
        ArrayList<GeneralObjectTreeNodeStruct> resultList = new ArrayList<GeneralObjectTreeNodeStruct>();
        resultList.addAll(resultDataList);
        UMLogger.debug("[object tree log]Build tree from topo Cost:" + (System.currentTimeMillis() - buildTreeFromTopoStartTime));
        UMLogger.debug("[object tree log]Build tree from topo End!");
        return resultList;
    }

    private static void trimTreeNode(GeneralObjectTreeNodeStruct rootData, Map<String, GeneralObjectTreeNodeStruct> showNEInfoMap) {
        DeviceTreeUtil.isAvailableNode(rootData, showNEInfoMap);
    }

    private static boolean isAvailableNode(GeneralObjectTreeNodeStruct nodeData, Map<String, GeneralObjectTreeNodeStruct> showNEInfoMap) {
        if (nodeData == null) {
            return true;
        }
        if (((IDeviceTreeData)nodeData.getValue()).isSubmap() && 0 != nodeData.getChildCount()) {
            List childrenList = nodeData.getChildren();
            boolean isAvailableFlag = false;
            for (int i = childrenList.size() - 1; i >= 0; --i) {
                GeneralObjectTreeNodeStruct nodeDataTmp = (GeneralObjectTreeNodeStruct)childrenList.get(i);
                if (!DeviceTreeUtil.isAvailableNode(nodeDataTmp, showNEInfoMap)) {
                    childrenList.remove(i);
                    continue;
                }
                GeneralObjectTreeNodeStruct currentNode = (GeneralObjectTreeNodeStruct)childrenList.get(i);
                Object userData = currentNode.getValue();
                if (userData instanceof IDeviceTreeData) {
                    IDeviceTreeData userObjData = (IDeviceTreeData)userData;
                    String tempFDN = userObjData.getFDN();
                    GeneralObjectTreeNodeStruct obj = showNEInfoMap.get(tempFDN);
                    if (null != obj) {
                        GeneralObjectTreeNodeStruct newOBJ = (GeneralObjectTreeNodeStruct)obj.clone();
                        childrenList.set(i, newOBJ);
                        newOBJ.setParent(nodeData);
                    } else {
                        currentNode.setParent(nodeData);
                    }
                }
                isAvailableFlag = true;
            }
            return isAvailableFlag;
        }
        if (showNEInfoMap.containsKey(((IDeviceTreeData)nodeData.getValue()).getFDN()) || ((IDeviceTreeData)nodeData.getValue()).isSubmap()) {
            nodeData = showNEInfoMap.get(((IDeviceTreeData)nodeData.getValue()).getFDN());
            return true;
        }
        return false;
    }

    private static Map<String, GeneralObjectTreeNodeStruct> adapterNEToNEMap(List<GeneralObjectTreeNodeStruct> neList) {
        if (neList == null) {
            return null;
        }
        HashMap<String, GeneralObjectTreeNodeStruct> neIDToNEMap = new HashMap<String, GeneralObjectTreeNodeStruct>(neList.size());
        int size = neList.size();
        for (int i = 0; i < size; ++i) {
            GeneralObjectTreeNodeStruct neData = neList.get(i);
            String fdn = ((IDeviceTreeData)neData.getValue()).getFDN();
            neIDToNEMap.put(fdn, neData);
        }
        return neIDToNEMap;
    }

    private static GeneralObjectTreeNodeStruct getTreeModelDataFromTopo(EmfTopoTreeModelFilter filter) {
        EmfTopoInterface topoInterface = InmTopoUtil.getTopoInterface();
        if (null == topoInterface) {
            UMLogger.debug("topoInterface is null.");
            return null;
        }
        int[] phyViewID = new int[]{101};
        DefaultTreeModel[] treeModel = topoInterface.getTopoTreeModel(phyViewID, filter);
        if (null == treeModel || treeModel.length == 0) {
            return null;
        }
        return DeviceTreeUtil.adapterTreeModel(treeModel[0]);
    }

    private static GeneralObjectTreeNodeStruct adapterTreeModel(TreeModel emfTreeModel) {
        DefaultMutableTreeNode oldRootNode = (DefaultMutableTreeNode)emfTreeModel.getRoot();
        GeneralObjectTreeNodeStruct treeNodeStruct = DeviceTreeUtil.copyNode(oldRootNode);
        nodeInfoMap.clear();
        return treeNodeStruct;
    }

    private static GeneralObjectTreeNodeStruct copyNode(DefaultMutableTreeNode oldNode) {
        DeviceTreeData deviceData;
        if (oldNode == null) {
            return null;
        }
        Object obj = oldNode.getUserObject();
        String strParentID = "";
        GeneralObjectTreeNodeStruct rsData = null;
        if (obj instanceof EmfTopoNodeInfo) {
            EmfTopoNodeInfo nodeInfo = (EmfTopoNodeInfo)obj;
            deviceData = new DeviceTreeData();
            deviceData.setSubmap(false);
            deviceData.setName(nodeInfo.m_szLabel);
            String fdn = nodeInfo.m_szID;
            if (0 == UMFDNUtil.getNeIDFromFDN(fdn) && 0 == UMFDNUtil.getOneIDFromFDN(fdn)) {
                fdn = "NE=" + nodeInfo.m_iDevID;
            }
            deviceData.setFdn(fdn);
            rsData = new GeneralObjectTreeNodeStruct();
            rsData.setName(nodeInfo.m_szLabel);
            rsData.setValue((Object)deviceData);
            rsData.setHasChildren(true);
            strParentID = nodeInfo.m_szParentID;
        } else if (obj instanceof EmfTopoContainerInfo) {
            EmfTopoContainerInfo containerInfo = (EmfTopoContainerInfo)obj;
            deviceData = new DeviceTreeData();
            deviceData.setSubmap(false);
            deviceData.setName(containerInfo.m_szLabel);
            int neID = containerInfo.m_iDevID;
            String fdn = "NE=" + neID;
            deviceData.setFdn(fdn);
            rsData = new GeneralObjectTreeNodeStruct();
            rsData.setName(containerInfo.m_szLabel);
            rsData.setValue((Object)deviceData);
            nodeInfoMap.put(containerInfo.m_szID, rsData);
            strParentID = containerInfo.m_szParentID;
        } else if (obj instanceof EmfTopoSubmapInfo) {
            EmfTopoSubmapInfo submapInfo = (EmfTopoSubmapInfo)obj;
            if (submapInfo.m_szID.equals("S102")) {
                submapInfo.m_szLabel = "root";
            }
            deviceData = new DeviceTreeData();
            deviceData.setSubmap(true);
            deviceData.setName(submapInfo.m_szLabel);
            deviceData.setSubmapID(submapInfo.m_szID);
            rsData = new GeneralObjectTreeNodeStruct();
            rsData.setName(submapInfo.m_szLabel);
            rsData.setValue((Object)deviceData);
            nodeInfoMap.put(submapInfo.m_szID, rsData);
            strParentID = submapInfo.m_szParentID;
        } else {
            InmLogging.info((String)"Unknown tree node data type");
        }
        GeneralObjectTreeNodeStruct rsDataTmp = nodeInfoMap.get(strParentID);
        if (null != rsDataTmp) {
            rsData.setParent(rsDataTmp);
        }
        ArrayList<GeneralObjectTreeNodeStruct> newChildrenList = new ArrayList<GeneralObjectTreeNodeStruct>();
        Enumeration<TreeNode> enume = oldNode.children();
        if (enume != null) {
            while (enume.hasMoreElements()) {
                DefaultMutableTreeNode oldNodeTmp = (DefaultMutableTreeNode)enume.nextElement();
                GeneralObjectTreeNodeStruct newNodeDataTmp = DeviceTreeUtil.copyNode(oldNodeTmp);
                newChildrenList.add(newNodeDataTmp);
            }
        }
        if (!newChildrenList.isEmpty()) {
            rsData.setHasChildren(true);
            rsData.setChildren(newChildrenList);
        }
        return rsData;
    }

    public static GeneralObjectTreeNodeStruct createRoot() {
        GeneralObjectTreeNodeStruct root = new GeneralObjectTreeNodeStruct();
        root.setAllChildrenLoaded(true);
        root.setName("root");
        DeviceTreeData rootValue = new DeviceTreeData(true, "root", "root", "root");
        root.setValue((Object)rootValue);
        return root;
    }

    public static GeneralObjectTreeNodeStruct getOSStruct() {
        StrUIDFactory fdnFactory = new StrUIDFactory();
        fdnFactory.append("OS", 1L);
        String fdn = fdnFactory.getStr();
        String localNMNmame = "NMS";
        EmfTopoResource toppResource = InmTopoUtil.getTopoInterface().getResourceByID(fdn);
        if (null != toppResource) {
            localNMNmame = toppResource.m_szLabel;
        }
        GeneralObjectTreeNodeStruct os = new GeneralObjectTreeNodeStruct();
        os.setAllChildrenLoaded(true);
        os.setName(localNMNmame);
        DeviceTreeData osValue = new DeviceTreeData(false, fdn, localNMNmame, "");
        os.setValue((Object)osValue);
        return os;
    }
}

