/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.devicetree;

import com.huawei.u2000.component.tree.ObjectTreeEvent;
import com.huawei.u2000.component.tree.ObjectTreeNoticer;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class DeviceTreeRpcSeverPushHandler
implements RpcServerPushHandler {
    private List<ObjectTreeNoticer> noticerList = new ArrayList<ObjectTreeNoticer>();
    private boolean hasOpen = false;

    public void registerNoticer(ObjectTreeNoticer noticer) {
        if (!this.hasOpen) {
            this.open();
        }
        this.noticerList.add(noticer);
    }

    public void unRegisterNoticer(ObjectTreeNoticer noticer) {
        this.noticerList.remove(noticer);
        if (this.noticerList.isEmpty()) {
            this.close();
        }
    }

    public void clearNoticer() {
        this.noticerList.clear();
        this.close();
    }

    public void open() {
        if (!this.hasOpen) {
            UMLogger.debug("(UMObjRpcSeverPushHandler)opened.");
            RpcServerPush.addHandler((String)"eam.ds.event", (RpcServerPushHandler)this);
            this.hasOpen = true;
        }
    }

    public void close() {
        if (this.hasOpen) {
            UMLogger.debug("(UMObjRpcSeverPushHandler)closed.");
            RpcServerPush.removeHandler((RpcServerPushHandler)this);
            this.hasOpen = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleServerPush(final RpcEvent event) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                RpcMessage msg = event.getMessage();
                String eventType = msg.getString("eventtype");
                UMLogger.debug("UMObjRpcSeverPushHandler receive event type : " + eventType);
                if (!this.isDeviceChangeEvent(eventType)) return;
                int size = this.noticerList.size();
                for (int i = 0; i < size; ++i) {
                    this.noticerList.get(i).notice(new ObjectTreeEvent(ObjectTreeEvent.EventType.NODE_CHANGE));
                }
                return;
            }
            catch (Exception e) {
                UMLogger.debug("process modify attribute error");
                return;
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeviceTreeRpcSeverPushHandler.this.handleServerPush(event);
                }
            });
        }
    }

    public List<ObjectTreeNoticer> getNoticerList() {
        return this.noticerList;
    }

    private boolean isDeviceChangeEvent(String eventType) {
        return eventType.equals("eam.ds.create_ne") || eventType.equals("eam.ds.delete_ne");
    }
}

