/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.devicetree;

import com.huawei.dfw.data.iface.IDFWDataMgr;
import com.huawei.dfw.proxy.ProxyFactory;
import com.huawei.imap12.utility.InmToolkit;
import com.huawei.u2000.component.tree.GeneralObjectTreeFindCondition;
import com.huawei.u2000.component.tree.GeneralObjectTreeNodeStruct;
import com.huawei.u2000.component.tree.IObjectTreeDataSourceExAdapter;
import com.huawei.u2000.component.tree.ObjectTreeNoticer;
import com.huawei.u2000.component.tree.SearchModelStruct;
import com.huawei.u2000.inf.UMCommonSBIInterface;
import com.huawei.u2000.inf.devicetree.IDeviceTreeData;
import com.huawei.u2000.inf.devicetree.IDeviceTreeDataCollector;
import com.huawei.u2000.inf.devicetree.IFunctionEnvironment;
import com.huawei.u2000.umcommon.component.devicetree.DeviceTreeDataAgent;
import com.huawei.u2000.umcommon.component.devicetree.DeviceTreeRpcSeverPushHandler;
import com.huawei.u2000.umcommon.component.devicetree.DeviceTreeUtil;
import com.huawei.u2000.umcommon.component.devicetree.FunctionEnvironment;
import com.huawei.u2000.unitedmgr.UMUnitedMgrModule;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.UMLogger;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class DeviceTreeDataSource
implements IObjectTreeDataSourceExAdapter {
    private Map<String, GeneralObjectTreeNodeStruct> submapBuffer = new HashMap<String, GeneralObjectTreeNodeStruct>();
    private IFunctionEnvironment funEnvironment = null;
    private DeviceTreeDataAgent dataAgent = DeviceTreeDataAgent.getInstance();
    private SearchModelStruct[] serchModel = null;
    private List<IDeviceTreeDataCollector> localCollector = new ArrayList<IDeviceTreeDataCollector>();
    private static final String PHY_SUBMAP_ID = "S102";
    private boolean isContainOS = false;
    DeviceTreeRpcSeverPushHandler rpcHandler = new DeviceTreeRpcSeverPushHandler();
    private static final String SWITCH_VALVE_CONF_PATH = "conf/ext_u2000_unitedmgr/objecttreextendallconf";
    private ObjectTreeNoticer noticer = null;
    private Map<String, Object> extendMap = new HashMap<String, Object>();

    public DeviceTreeDataSource(IFunctionEnvironment funEnvironment) {
        this.funEnvironment = funEnvironment;
        this.initNoticers();
    }

    public GeneralObjectTreeNodeStruct getNodeTreeByCondition(GeneralObjectTreeFindCondition condition) {
        GeneralObjectTreeNodeStruct root = DeviceTreeUtil.createRoot();
        String searchType = (String)condition.getConditions().get("searchType");
        String searchValue = (String)condition.getConditions().get("searchValue");
        if ("submap".equals(searchType)) {
            GeneralObjectTreeNodeStruct rootSubmap = this.submapBuffer.get(PHY_SUBMAP_ID);
            return this.getSearchRsultSubmap(rootSubmap, searchValue);
        }
        ArrayList<IDeviceTreeDataCollector> dataSourceList = new ArrayList<IDeviceTreeDataCollector>();
        List<IDeviceTreeDataCollector> outsideDataSourceList = this.dataAgent.getDataCollectorList();
        dataSourceList.addAll(outsideDataSourceList);
        dataSourceList.addAll(this.localCollector);
        ArrayList<GeneralObjectTreeNodeStruct> children = new ArrayList<GeneralObjectTreeNodeStruct>();
        ArrayList<FutureTask<List<GeneralObjectTreeNodeStruct>>> futureList = new ArrayList<FutureTask<List<GeneralObjectTreeNodeStruct>>>();
        int size = dataSourceList.size();
        for (int i = 0; i < size; ++i) {
            final GeneralObjectTreeFindCondition generalObjectTreeFindCondition = (GeneralObjectTreeFindCondition)condition.clone();
            final IDeviceTreeDataCollector collector = (IDeviceTreeDataCollector)dataSourceList.get(i);
            FutureTask<List<GeneralObjectTreeNodeStruct>> future = new FutureTask<List<GeneralObjectTreeNodeStruct>>(new Callable<List<GeneralObjectTreeNodeStruct>>(){

                @Override
                public List<GeneralObjectTreeNodeStruct> call() {
                    UMLogger.debug("single domain collector-find [" + collector.getClass().getName() + "] start!");
                    ArrayList<GeneralObjectTreeNodeStruct> resultList = new ArrayList();
                    try {
                        UMLogger.debug("tree find condition:" + generalObjectTreeFindCondition.getConditions().toString());
                        resultList = collector.findObjectTreeDatas(generalObjectTreeFindCondition, DeviceTreeDataSource.this.funEnvironment);
                    }
                    catch (Exception ex) {
                        UMLogger.exception(ex);
                    }
                    UMLogger.debug("single domain collector-find [" + collector.getClass().getName() + "] end! resultList is : " + resultList);
                    return resultList;
                }
            });
            futureList.add(future);
            Thread newThread = new Thread(future);
            newThread.start();
        }
        for (FutureTask futureTask : futureList) {
            try {
                List currentChildren = (List)futureTask.get(60L, TimeUnit.SECONDS);
                if (null != currentChildren) {
                    children.addAll(currentChildren);
                    continue;
                }
                UMLogger.debug("single domain collector-find, reuslt is null");
            }
            catch (Exception ex) {
                UMLogger.exception(ex);
            }
        }
        root.setChildren(DeviceTreeUtil.buildTreeFromTopo(children));
        return root;
    }

    public void initNoticers() {
        this.noticer = new ObjectTreeNoticer();
        this.rpcHandler.registerNoticer(this.noticer);
    }

    private GeneralObjectTreeNodeStruct getSearchRsultSubmap(GeneralObjectTreeNodeStruct root, String searchKey) {
        GeneralObjectTreeNodeStruct newRoot = DeviceTreeUtil.createRoot();
        if (null != root.getChildren()) {
            List children = root.getChildren();
            this.addSearchSubmap(newRoot, children, searchKey);
        }
        return newRoot;
    }

    private void addSearchSubmap(GeneralObjectTreeNodeStruct currentSubmap, List<GeneralObjectTreeNodeStruct> children, String searchKey) {
        GeneralObjectTreeNodeStruct currentChild = null;
        if (null == children) {
            return;
        }
        for (GeneralObjectTreeNodeStruct child : children) {
            if (!this.isSearchRelatedSubmap(child, searchKey)) continue;
            currentChild = this.cloneSubmap(child);
            if (child.getName().toUpperCase().indexOf(searchKey.toUpperCase()) > -1) {
                currentChild.setFindTargetNode(true);
            }
            currentSubmap.addChild(currentChild);
            currentChild.setParent(currentSubmap);
            if (null == child.getChildren()) continue;
            this.addSearchSubmap(currentChild, child.getChildren(), searchKey);
        }
    }

    private GeneralObjectTreeNodeStruct cloneSubmap(GeneralObjectTreeNodeStruct submap) {
        GeneralObjectTreeNodeStruct newSubmap = new GeneralObjectTreeNodeStruct();
        newSubmap.setName(submap.getName());
        newSubmap.setValue(submap.getValue());
        return newSubmap;
    }

    private boolean isSearchRelatedSubmap(GeneralObjectTreeNodeStruct submap, String searchKey) {
        if (submap.getName().toUpperCase().indexOf(searchKey.toUpperCase()) > -1) {
            return true;
        }
        if (null != submap.getChildren()) {
            List children = submap.getChildren();
            for (GeneralObjectTreeNodeStruct child : children) {
                if (!this.isSearchRelatedSubmap(child, searchKey)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public List<GeneralObjectTreeNodeStruct> mountObjectiveChildren(List<GeneralObjectTreeNodeStruct> parentNodes) {
        final ArrayList<GeneralObjectTreeNodeStruct> resultList = new ArrayList<GeneralObjectTreeNodeStruct>();
        if ("true".equals(this.getExtendFields().get("noLoade"))) {
            return parentNodes;
        }
        ArrayList<IDeviceTreeDataCollector> dataSourceList = new ArrayList<IDeviceTreeDataCollector>();
        List<IDeviceTreeDataCollector> outsideDataSourceList = this.dataAgent.getDataCollectorList();
        dataSourceList.addAll(outsideDataSourceList);
        dataSourceList.addAll(this.localCollector);
        ArrayList<FutureTask<List<GeneralObjectTreeNodeStruct>>> futureList = new ArrayList<FutureTask<List<GeneralObjectTreeNodeStruct>>>();
        final FunctionEnvironment currentFun = new FunctionEnvironment(this.funEnvironment.getFunID());
        currentFun.setDataStructType(this.funEnvironment.getDataStructType());
        currentFun.setDelayLoadFlag(false);
        int size = dataSourceList.size();
        for (int i = 0; i < size; ++i) {
            final List<GeneralObjectTreeNodeStruct> list = this.cloneNodes(parentNodes);
            final IDeviceTreeDataCollector collector = (IDeviceTreeDataCollector)dataSourceList.get(i);
            FutureTask<List<GeneralObjectTreeNodeStruct>> future = new FutureTask<List<GeneralObjectTreeNodeStruct>>(new Callable<List<GeneralObjectTreeNodeStruct>>(){

                @Override
                public List<GeneralObjectTreeNodeStruct> call() {
                    try {
                        UMLogger.debug("single domain collector-loadNEUnderSubmap All [" + collector.getClass().getName() + "] start!");
                        List<GeneralObjectTreeNodeStruct> currentResult = collector.loadNEUnderSubmap(list, currentFun);
                        UMLogger.debug("single domain collector-loadNEUnderSubmap All [" + collector.getClass().getName() + "] end!");
                        if (null != resultList && null != currentResult) {
                            resultList.addAll(currentResult);
                            UMLogger.debug("single domain collector-loadNEUnderSubmap All [" + collector.getClass().getName() + "] result size:" + resultList.size());
                        } else {
                            UMLogger.debug("single domain collector-loadNEUnderSubmap All [" + collector.getClass().getName() + "] result is null");
                        }
                    }
                    catch (Exception ex) {
                        UMLogger.exception(ex);
                    }
                    return list;
                }
            });
            futureList.add(future);
            Thread newThread = new Thread(future);
            newThread.start();
        }
        for (FutureTask futureTask : futureList) {
            try {
                List<GeneralObjectTreeNodeStruct> tempParent = this.getObjTreeNodeList(futureTask);
                if (null != tempParent) {
                    UMLogger.debug(DeviceTreeDataSource.class, " mountObjectiveChildren ", " tempParent size :" + tempParent.size());
                    this.mergeNodes(parentNodes, tempParent);
                    resultList.addAll(tempParent);
                    continue;
                }
                UMLogger.debug(DeviceTreeDataSource.class, " mountObjectiveChildren ", " tempParent is null. future is :" + futureTask);
            }
            catch (Exception ex) {
                UMLogger.exception(ex);
            }
        }
        Collections.sort(resultList);
        return resultList;
    }

    private List<GeneralObjectTreeNodeStruct> getObjTreeNodeList(final FutureTask<List<GeneralObjectTreeNodeStruct>> future) {
        SyncCommand sc = new SyncCommand(){

            public Object call() {
                try {
                    return future.get();
                }
                catch (Exception ex) {
                    UMLogger.exception(ex);
                    return null;
                }
            }
        };
        sc.startCall((Component)FrameworkUtilities.getMainFrame(), true);
        return (List)sc.getResult();
    }

    public List<GeneralObjectTreeNodeStruct> mountChildren(List<GeneralObjectTreeNodeStruct> selectDataList) {
        if (null == selectDataList || selectDataList.isEmpty()) {
            return null;
        }
        ArrayList<GeneralObjectTreeNodeStruct> resultList = new ArrayList<GeneralObjectTreeNodeStruct>();
        try {
            if (selectDataList.size() == 1) {
                GeneralObjectTreeNodeStruct selectData = selectDataList.get(0);
                if ("root".equals(selectData.getName())) {
                    return null;
                }
                ArrayList<GeneralObjectTreeNodeStruct> children = new ArrayList<GeneralObjectTreeNodeStruct>();
                List<GeneralObjectTreeNodeStruct> tempResultList = null;
                IDeviceTreeData deviceData = (IDeviceTreeData)selectData.getValue();
                if (deviceData.isSubmap()) {
                    GeneralObjectTreeNodeStruct currentSubmap = this.submapBuffer.get(deviceData.getSubmapID());
                    if (currentSubmap != null) {
                        tempResultList = DeviceTreeUtil.copySubmap(currentSubmap.getChildren());
                        children.addAll(tempResultList);
                        resultList.addAll(tempResultList);
                    }
                    ArrayList<IDeviceTreeDataCollector> dataSourceList = new ArrayList<IDeviceTreeDataCollector>();
                    List<IDeviceTreeDataCollector> outsideDataSourceList = this.dataAgent.getDataCollectorList();
                    dataSourceList.addAll(outsideDataSourceList);
                    dataSourceList.addAll(this.localCollector);
                    ArrayList<FutureTask<List<GeneralObjectTreeNodeStruct>>> futureList = new ArrayList<FutureTask<List<GeneralObjectTreeNodeStruct>>>();
                    int size = dataSourceList.size();
                    for (int i = 0; i < size; ++i) {
                        final List<GeneralObjectTreeNodeStruct> list = this.cloneNodes(selectDataList);
                        final IDeviceTreeDataCollector collector = (IDeviceTreeDataCollector)dataSourceList.get(i);
                        FutureTask<List<GeneralObjectTreeNodeStruct>> future = new FutureTask<List<GeneralObjectTreeNodeStruct>>(new Callable<List<GeneralObjectTreeNodeStruct>>(){

                            @Override
                            public List<GeneralObjectTreeNodeStruct> call() {
                                UMLogger.debug("single domain collector-loadNEUnderSubmap [" + collector.getClass().getName() + "] start!");
                                try {
                                    List<GeneralObjectTreeNodeStruct> resultList = collector.loadNEUnderSubmap(list, DeviceTreeDataSource.this.funEnvironment);
                                    UMLogger.debug("single domain collector-loadNEUnderSubmap [" + collector.getClass().getName() + "] end!");
                                    if (null != resultList) {
                                        UMLogger.debug("single domain collector-loadNEUnderSubmap [" + collector.getClass().getName() + "] result size:" + resultList.size());
                                    } else {
                                        UMLogger.debug("single domain collector-loadNEUnderSubmap [" + collector.getClass().getName() + "] result is null");
                                    }
                                }
                                catch (Exception ex) {
                                    UMLogger.exception(ex);
                                }
                                return list;
                            }
                        });
                        futureList.add(future);
                        Thread newThread = new Thread(future);
                        newThread.start();
                    }
                    for (FutureTask futureTask : futureList) {
                        try {
                            List tempChildren = (List)futureTask.get();
                            if (null != tempChildren) {
                                UMLogger.debug(DeviceTreeDataSource.class, " mountChildren ", " tempChildren size :" + tempChildren.size());
                                resultList.addAll(tempChildren);
                                this.mergeNodes(selectDataList, tempChildren);
                                continue;
                            }
                            UMLogger.debug(DeviceTreeDataSource.class, " mountChildren ", " tempChildren is null ");
                        }
                        catch (Exception ex) {
                            UMLogger.exception(ex);
                        }
                    }
                    List loadedList = selectData.getChildren();
                    if (null != loadedList) {
                        children.addAll(loadedList);
                    }
                    selectData.setChildren(children);
                } else {
                    String fdn = ((IDeviceTreeData)selectData.getValue()).getFDN();
                    UMUnitedMgrModule mgrModule = (UMUnitedMgrModule)U2kModuleManagerFactory.getModule("united_common");
                    UMCommonSBIInterface sbiInf = mgrModule.getSBIInterfaceFromFDN(fdn);
                    List<GeneralObjectTreeNodeStruct> objectUnderNeList = sbiInf.loadObjectUnderNE(selectData, this.funEnvironment);
                    if (null != objectUnderNeList && !objectUnderNeList.isEmpty()) {
                        resultList.addAll(objectUnderNeList);
                    }
                }
                this.setParentInfo(selectData);
            } else {
                UMLogger.debug("need to mount datas is error");
            }
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
        }
        return resultList;
    }

    private void setParentInfo(GeneralObjectTreeNodeStruct node) {
        if (null == node || null == node.getChildren()) {
            return;
        }
        for (GeneralObjectTreeNodeStruct child : node.getChildren()) {
            if (null == child) continue;
            child.setParent(node);
        }
    }

    private List<GeneralObjectTreeNodeStruct> cloneNodes(List<GeneralObjectTreeNodeStruct> inputNodes) {
        if (null == inputNodes) {
            return null;
        }
        ArrayList<GeneralObjectTreeNodeStruct> newNodes = new ArrayList<GeneralObjectTreeNodeStruct>();
        for (GeneralObjectTreeNodeStruct oldNode : inputNodes) {
            newNodes.add((GeneralObjectTreeNodeStruct)oldNode.clone());
        }
        return newNodes;
    }

    private void mergeNodes(List<GeneralObjectTreeNodeStruct> targetNodes, List<GeneralObjectTreeNodeStruct> inputNodes) {
        if (null == inputNodes) {
            return;
        }
        int size = targetNodes.size();
        List nextChildren = null;
        GeneralObjectTreeNodeStruct tempChild = null;
        boolean isContain = false;
        List tempChildren = null;
        for (int i = 0; i < size; ++i) {
            List children;
            tempChild = inputNodes.get(i);
            if (null != tempChild) {
                nextChildren = tempChild.getChildren();
            }
            if (null == (children = targetNodes.get(i).getChildren())) {
                children = nextChildren;
            } else if (null != nextChildren) {
                for (GeneralObjectTreeNodeStruct nodeStruct : nextChildren) {
                    isContain = false;
                    for (GeneralObjectTreeNodeStruct targeNodeStruct : children) {
                        if (!nodeStruct.getValue().equals(targeNodeStruct.getValue())) continue;
                        isContain = true;
                        tempChildren = targeNodeStruct.getChildren();
                        if (null != tempChildren) {
                            ArrayList<GeneralObjectTreeNodeStruct> cuurentTargerList = new ArrayList<GeneralObjectTreeNodeStruct>();
                            cuurentTargerList.add(targeNodeStruct);
                            ArrayList<GeneralObjectTreeNodeStruct> cuurentSourceList = new ArrayList<GeneralObjectTreeNodeStruct>();
                            cuurentSourceList.add(nodeStruct);
                            this.mergeNodes(cuurentTargerList, cuurentSourceList);
                            break;
                        }
                        targeNodeStruct.setChildren(nodeStruct.getChildren());
                        break;
                    }
                    if (isContain) continue;
                    children.add(nodeStruct);
                }
            }
            if (children == null) continue;
            Collections.sort(children);
            targetNodes.get(i).setChildren(children);
        }
    }

    public GeneralObjectTreeNodeStruct getRootNode() {
        GeneralObjectTreeNodeStruct root = DeviceTreeUtil.createRoot();
        GeneralObjectTreeNodeStruct fullRoot = DeviceTreeUtil.fillSubmapBuffer(this.submapBuffer);
        ArrayList<Object> rootChildrenList = new ArrayList<Object>();
        ArrayList rootNEList = new ArrayList();
        rootChildrenList.addAll(DeviceTreeUtil.copySubmap(fullRoot.getChildren()));
        if (this.isContainOS && !InmToolkit.isLCT()) {
            GeneralObjectTreeNodeStruct os = DeviceTreeUtil.getOSStruct();
            rootChildrenList.add(os);
        }
        ArrayList<FutureTask<List<GeneralObjectTreeNodeStruct>>> futureList = new ArrayList<FutureTask<List<GeneralObjectTreeNodeStruct>>>();
        ArrayList<IDeviceTreeDataCollector> dataSourceList = new ArrayList<IDeviceTreeDataCollector>();
        List<IDeviceTreeDataCollector> outsideDataSourceList = this.dataAgent.getDataCollectorList();
        dataSourceList.addAll(outsideDataSourceList);
        dataSourceList.addAll(this.localCollector);
        int size = dataSourceList.size();
        for (int i = 0; i < size; ++i) {
            final IDeviceTreeDataCollector iDeviceTreeDataCollector = (IDeviceTreeDataCollector)dataSourceList.get(i);
            FutureTask<List<GeneralObjectTreeNodeStruct>> future = new FutureTask<List<GeneralObjectTreeNodeStruct>>(new Callable<List<GeneralObjectTreeNodeStruct>>(){

                @Override
                public List<GeneralObjectTreeNodeStruct> call() {
                    UMLogger.debug("single domain collector-getroot [" + iDeviceTreeDataCollector.getClass().getName() + "] start!");
                    ArrayList<GeneralObjectTreeNodeStruct> resultList = new ArrayList();
                    try {
                        resultList = iDeviceTreeDataCollector.getNEOnTopo(DeviceTreeDataSource.this.funEnvironment);
                        UMLogger.debug("single domain collector-getroot [" + iDeviceTreeDataCollector.getClass().getName() + "] end!");
                        if (null != resultList) {
                            UMLogger.debug("single domain collector-getroot [" + iDeviceTreeDataCollector.getClass().getName() + "] result size:" + resultList.size());
                        } else {
                            UMLogger.debug("single domain collector-getroot [" + iDeviceTreeDataCollector.getClass().getName() + "] result is null");
                        }
                    }
                    catch (Exception ex) {
                        UMLogger.exception(ex);
                    }
                    UMLogger.debug("single domain collector-getroot [" + iDeviceTreeDataCollector.getClass().getName() + "] end!");
                    return resultList;
                }
            });
            futureList.add(future);
            Thread newThread = new Thread(future);
            newThread.start();
        }
        for (FutureTask futureTask : futureList) {
            try {
                List currentChildren = (List)futureTask.get(10L, TimeUnit.SECONDS);
                if (null != currentChildren) {
                    UMLogger.debug(DeviceTreeDataSource.class, " getRootNode() ", " currentChildren size :" + currentChildren.size());
                    rootNEList.addAll(currentChildren);
                    continue;
                }
                UMLogger.debug("single domain collector-getroot, result is null!");
            }
            catch (Exception ex) {
                UMLogger.exception(ex);
            }
        }
        Collections.sort(rootNEList);
        rootChildrenList.addAll(rootNEList);
        root.setChildren(rootChildrenList);
        return root;
    }

    public List<ObjectTreeNoticer> getNoticerList() {
        return this.rpcHandler.getNoticerList();
    }

    public void setSerchModel(SearchModelStruct[] serchModel) {
        this.serchModel = serchModel;
    }

    public SearchModelStruct[] getSearchModel() {
        return this.serchModel;
    }

    public void setContainOS(boolean isContainOS) {
        this.isContainOS = isContainOS;
    }

    public Map<String, Object> getExtendFields() {
        return this.extendMap;
    }

    public int isExtendAllEnabled() {
        ProxyFactory proxyFactory = ProxyFactory.getInstance();
        IDFWDataMgr dataMgr = proxyFactory.getDFWDataMgr();
        int allNECount = dataMgr.getAllNeID().size();
        CommStyleInfo progressbarConf = CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyle(SWITCH_VALVE_CONF_PATH);
        AreaDescContainer area = progressbarConf.getAreaDescContainer(0);
        DescContainer desc = area.getDescContainer("ExpandAllNENumberConf");
        int promptValue = -1;
        int forbidValue = -1;
        try {
            PARA para = desc.getParasItem(0);
            promptValue = new Integer(para.getValue());
            para = desc.getParasItem(1);
            forbidValue = new Integer(para.getValue());
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
            return 1;
        }
        if (allNECount < promptValue) {
            return 1;
        }
        if (allNECount >= promptValue && allNECount <= forbidValue) {
            return 2;
        }
        return 0;
    }

    public void registerLocalCollector(IDeviceTreeDataCollector collector) {
        UMLogger.debug(this.getClass(), " registerLocalCollector ", " [Object Tree KeyLogger] IDeviceTreeDataCollector register:" + collector);
        this.localCollector.add(collector);
    }

    public void unregisterLocalCollector(IDeviceTreeDataCollector collector) {
        UMLogger.debug(this.getClass(), " unregisterLocalCollector ", " [Object Tree KeyLogger] IDeviceTreeDataCollector unregister:" + collector);
        this.localCollector.remove(collector);
    }

    public GeneralObjectTreeNodeStruct[] getSubmapPath(String submapID) {
        GeneralObjectTreeNodeStruct submap = this.submapBuffer.get(submapID);
        ArrayList<GeneralObjectTreeNodeStruct> submapIDList = new ArrayList<GeneralObjectTreeNodeStruct>();
        if (null != submap) {
            submapIDList.add(submap);
            GeneralObjectTreeNodeStruct parent = submap.getParent();
            while (null != parent && !PHY_SUBMAP_ID.equals(((IDeviceTreeData)parent.getValue()).getSubmapID())) {
                submap = parent;
                parent = submap.getParent();
                submapIDList.add(submap);
            }
            int size = submapIDList.size();
            GeneralObjectTreeNodeStruct[] submapIDArray = new GeneralObjectTreeNodeStruct[size];
            for (int i = 0; i < size; ++i) {
                submapIDArray[i] = (GeneralObjectTreeNodeStruct)submapIDList.get(size - 1 - i);
            }
            return submapIDArray;
        }
        return null;
    }

    public void destroy() {
        if (null != this.noticer) {
            this.rpcHandler.unRegisterNoticer(this.noticer);
        }
        this.noticer = null;
    }

    public IFunctionEnvironment getFunEnvironment() {
        return this.funEnvironment;
    }

    public GeneralObjectTreeNodeStruct getNodeTreeByFile(File file) {
        return null;
    }
}

