/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component;

import com.huawei.core.util.TENameValuePair;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class UMAutoCompleteCombobox
extends JComboBox {
    private final ArrayList<Object> allItemObjs = new ArrayList();
    private final Vector<Object> loadedItemObjs = new Vector();
    private final MyComboBoxModel model = new MyComboBoxModel(this.loadedItemObjs);
    public static final int DEFAULT_MAX_VISIBLE_ITEM_COUNT = 8;
    private static final int ALL_ITEMS_ID = 0;
    private final TENameValuePair defaultObj = new TENameValuePair(0, "All");
    private boolean allowAllItems = false;
    private transient KeyListener keyListener = new KeyAdapter(){
        String tmpStr = null;

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                this.tmpStr = ((JTextField)UMAutoCompleteCombobox.this.getEditor().getEditorComponent()).getText();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                if (UMAutoCompleteCombobox.this.getItemCount() > 0) {
                    Object selectItem = UMAutoCompleteCombobox.this.getSelectedItem();
                    if (!UMAutoCompleteCombobox.this.loadedItemObjs.contains(selectItem)) {
                        selectItem = UMAutoCompleteCombobox.this.getItemAt(0);
                        for (int i = 0; i < UMAutoCompleteCombobox.this.loadedItemObjs.size(); ++i) {
                            if (!UMAutoCompleteCombobox.this.loadedItemObjs.get(i).toString().equals(this.tmpStr)) continue;
                            selectItem = UMAutoCompleteCombobox.this.loadedItemObjs.get(i);
                            break;
                        }
                    }
                    UMAutoCompleteCombobox.this.setPopupVisible(false);
                    UMAutoCompleteCombobox.this.setSelectedItem(selectItem);
                }
                return;
            }
            int caretPosition = ((JTextField)UMAutoCompleteCombobox.this.getEditor().getEditorComponent()).getCaretPosition();
            String inputStr = ((JTextField)UMAutoCompleteCombobox.this.getEditor().getEditorComponent()).getText();
            if (UMAutoCompleteCombobox.this.getSelectedItem() != null && inputStr.equals(UMAutoCompleteCombobox.this.getSelectedItem().toString())) {
                return;
            }
            if (inputStr.length() == 0) {
                UMAutoCompleteCombobox.this.reLoadAllItems();
                ((JTextField)UMAutoCompleteCombobox.this.getEditor().getEditorComponent()).setText("");
            } else {
                UMAutoCompleteCombobox.this.loadedItemObjs.clear();
                int size = UMAutoCompleteCombobox.this.allItemObjs.size();
                for (int i = 0; i < size; ++i) {
                    if (UMAutoCompleteCombobox.this.allItemObjs.get(i).toString().toLowerCase().indexOf(inputStr.toLowerCase()) < 0) continue;
                    UMAutoCompleteCombobox.this.loadedItemObjs.add(UMAutoCompleteCombobox.this.allItemObjs.get(i));
                }
                if (UMAutoCompleteCombobox.this.loadedItemObjs.isEmpty() && UMAutoCompleteCombobox.this.allowAllItems) {
                    UMAutoCompleteCombobox.this.loadedItemObjs.add(UMAutoCompleteCombobox.this.defaultObj);
                }
                if (UMAutoCompleteCombobox.this.loadedItemObjs.size() > 0) {
                    UMAutoCompleteCombobox.this.model.fireIntervalAdded(UMAutoCompleteCombobox.this.model, 0, UMAutoCompleteCombobox.this.loadedItemObjs.size() - 1);
                } else {
                    UMAutoCompleteCombobox.this.model.fireIntervalAdded(UMAutoCompleteCombobox.this.model, 0, 0);
                }
                ((JTextField)UMAutoCompleteCombobox.this.getEditor().getEditorComponent()).setText(inputStr);
            }
            if (caretPosition > ((JTextField)UMAutoCompleteCombobox.this.getEditor().getEditorComponent()).getText().length()) {
                ((JTextField)UMAutoCompleteCombobox.this.getEditor().getEditorComponent()).setCaretPosition(((JTextField)UMAutoCompleteCombobox.this.getEditor().getEditorComponent()).getText().length() - 1);
            } else {
                ((JTextField)UMAutoCompleteCombobox.this.getEditor().getEditorComponent()).setCaretPosition(caretPosition);
            }
            UMAutoCompleteCombobox.this.fixMaxVisibleItemCount();
            UMAutoCompleteCombobox.this.setPopupVisible(false);
            UMAutoCompleteCombobox.this.setPopupVisible(true);
        }
    };
    private transient FocusListener focusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            Object obj = UMAutoCompleteCombobox.this.getSelectedItem();
            if (!UMAutoCompleteCombobox.this.loadedItemObjs.contains(obj)) {
                UMAutoCompleteCombobox.this.reLoadAllItems();
                if (UMAutoCompleteCombobox.this.allowAllItems) {
                    UMAutoCompleteCombobox.this.setSelectedItem(UMAutoCompleteCombobox.this.defaultObj);
                } else {
                    UMAutoCompleteCombobox.this.setSelectedItem(null);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            UMAutoCompleteCombobox.this.fixMaxVisibleItemCount();
        }
    };

    public UMAutoCompleteCombobox() {
        this(false);
    }

    public UMAutoCompleteCombobox(boolean allowAllItems) {
        this.allowAllItems = allowAllItems;
        this.setModel(this.model);
        this.setEditable(true);
        ((JTextField)this.getEditor().getEditorComponent()).addKeyListener(this.keyListener);
        this.getEditor().getEditorComponent().addFocusListener(this.focusListener);
    }

    public void addItem(Object anObject) {
        super.addItem(anObject);
        if (!this.allItemObjs.contains(anObject)) {
            this.allItemObjs.add(anObject);
        }
    }

    public void addItems(List<? extends Object> items, boolean isNeedCheck) {
        int begin = this.loadedItemObjs.size();
        if (isNeedCheck) {
            for (Object object : items) {
                if (this.allItemObjs.contains(object)) continue;
                this.allItemObjs.add(object);
                this.loadedItemObjs.add(object);
            }
        } else {
            this.allItemObjs.addAll(items);
            this.loadedItemObjs.addAll(items);
        }
        int end = this.loadedItemObjs.size() - 1;
        this.fixMaxVisibleItemCount();
        this.model.fireIntervalAdded(this.model, begin, end);
    }

    public void addItems(List<? extends Object> items) {
        this.addItems(items, true);
    }

    private void reLoadAllItems() {
        this.loadedItemObjs.clear();
        this.loadedItemObjs.addAll(this.allItemObjs);
        this.fixMaxVisibleItemCount();
        this.model.fireIntervalAdded(this.model, 0, this.loadedItemObjs.size() - 1);
    }

    public void fixMaxVisibleItemCount() {
        if (this.loadedItemObjs.size() < 8) {
            this.setMaximumRowCount(this.loadedItemObjs.size());
        } else {
            this.setMaximumRowCount(8);
        }
    }

    public void clearCacheItems() {
        this.allItemObjs.clear();
    }

    public void clearCacheAndModelItems() {
        this.allItemObjs.clear();
        if (this.loadedItemObjs.size() > 0) {
            int index = this.loadedItemObjs.size() - 1;
            this.loadedItemObjs.clear();
            this.model.fireIntervalRemoved(this.model, 0, index);
        }
    }

    private static class MyComboBoxModel
    extends DefaultComboBoxModel {
        private MyComboBoxModel(Vector<?> items) {
            super(items);
        }

        @Override
        public void fireIntervalAdded(Object source, int index0, int index1) {
            super.fireIntervalAdded(source, index0, index1);
        }

        @Override
        public void fireIntervalRemoved(Object source, int index0, int index1) {
            super.fireIntervalRemoved(source, index0, index1);
        }
    }
}

