/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.inf.unitedmgr.telnet;

import com.huawei.imap12.utility.log.InmLogging;
import com.huawei.network.qasn.m_q_ip_dmf.AsnResult;
import com.huawei.u2000.basetool.UMFrameAppAdapter;
import com.huawei.u2000.unitedmgr.UMUnitedMgrModule;
import com.huawei.u2000.unitedmgr.telnet.asn1.dmfres.AsnResTestParaReq;
import com.huawei.u2000.unitedmgr.telnet.asn1.emldevcommon.AsnDmfGetDevBaseInfoRep;
import com.huawei.u2000.unitedmgr.telnet.asn1.emldevcommon.AsnDmfGetDevBaseInfoReq;
import com.huawei.u2000.unitedmgr.telnet.common.toolkit.DMFDebugTracer;
import com.huawei.u2000.unitedmgr.telnet.common.toolkit.DMFUtils;
import com.huawei.u2000.unitedmgr.telnet.eml.common.communicate.EMLCommManager;
import com.huawei.u2000.unitedmgr.telnet.eml.common.communicate.IEMLCommService;
import com.huawei.u2000.unitedmgr.telnet.eml.common.toolkit.EMLNEUtils;
import com.huawei.u2000.unitedmgr.telnet.eml.common.toolkit.EMLUtils;
import com.huawei.u2000.unitedmgr.telnet.eml.telnetdeviceconfig.TelnetDeviceConfigController;
import com.huawei.u2000.unitedmgr.telnet.eml.telnetdeviceconfig.TelnetDeviceConfigDialog;
import com.huawei.u2000.unitedmgr.telnet.protocol.common.data.parammodel.TelnetParamEntity;
import com.huawei.u2000.unitedmgr.telnet.protocol.common.util.ProtocolUtils;
import com.huawei.u2000.unitedmgr.telnet.protocol.snmpexttemplate.SNMPExtTemplateMgrDlg;
import com.huawei.u2000.unitedmgr.telnet.protocol.telnettemplate.TelnetTemplateDialog;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.U2kUnitedUtilities;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.topo.adapter.message.EmfTopoContainerInfo;
import com.swimap.external.topo.adapter.message.EmfTopoNodeInfo;
import com.swimap.external.topo.adapter.message.EmfTopoObjectInfo;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.util.FrameworkUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TelnetCommon {
    public static List<TelnetParamEntity> getDevTelnetInfo(List<EmfTopoObjectInfo> nodeList) {
        TelnetDeviceConfigController controller = new TelnetDeviceConfigController();
        controller.setDevList(nodeList);
        return controller.getServerTableInfo();
    }

    public static void telnetParameter(String neID) {
        int iReturnCode;
        AsnDmfGetDevBaseInfoReq getDevBaseInfoReq = new AsnDmfGetDevBaseInfoReq();
        getDevBaseInfoReq.iUserID = BigInteger.valueOf(DMFUtils.getUserID());
        getDevBaseInfoReq.iDevID = new BigInteger(neID);
        AsnDmfGetDevBaseInfoRep getDevBaseInfoRep = new AsnDmfGetDevBaseInfoRep();
        InmLogging.asn((FStruct)getDevBaseInfoRep);
        IEMLCommService commService = EMLCommManager.getEMLCommService();
        int iRet = commService.sendSyncMessage(48310, neID, (FStruct)getDevBaseInfoReq, (FStruct)getDevBaseInfoRep);
        if (0 != iRet) {
            DMFUtils.showOperResultDialog((int)48310, (int)iRet);
        }
        if (0 != (iReturnCode = getDevBaseInfoRep.iReturnCode.intValue())) {
            String strErrMsg = DMFUtils.getErrMsg((int)iReturnCode);
            DMFUtils.showPromptMessageDialog(null, (String)strErrMsg);
        }
    }

    public static void initTelnetConfig() {
        List<EmfTopoObjectInfo> devList = TelnetCommon.getCurrTopoSelectedData();
        if (null == devList || devList.isEmpty()) {
            DMFUtils.showPromptMessageDialog(null, (String)DMFUtils.getString((String)"telnet.notSupport"));
            return;
        }
        TelnetCommon.initTelnetConfig(devList);
    }

    public static void initTelnetConfig(List<?> devList) {
        UMLogger.debug(TelnetCommon.class, " initTelnetConfig ", " devList : " + devList);
        if (devList.isEmpty()) {
            DMFUtils.showPromptMessageDialog(null, (String)DMFUtils.getString((String)"telnet.noDevice"));
            return;
        }
        TelnetDeviceConfigDialog.getInstance(devList).setVisible(true);
    }

    public static void initTelnetTemplate() {
        if (!TelnetTemplateDialog.hasRight()) {
            DMFUtils.showPromptMessageDialog((Component)FrameworkUtilities.getMainFrame(), (String)DMFUtils.getString((String)"noOperationRight"));
            return;
        }
        TelnetTemplateDialog telnetTemplate = new TelnetTemplateDialog();
        telnetTemplate.initTableModel();
        telnetTemplate.firstShow = false;
        telnetTemplate.setVisible(true);
        telnetTemplate.getCloseButton().requestFocus();
    }

    public static void initSNMPExtTemplate() {
        SNMPExtTemplateMgrDlg dlg = new SNMPExtTemplateMgrDlg();
        dlg.setVisible(true);
    }

    public static void testDevConn(List<EmfTopoObjectInfo> devList) {
        UMLogger.debug(TelnetCommon.class, " testDevConn ", " devList : " + devList);
        List telnetParamList = new TelnetDeviceConfigController().getTelnetParamList(devList);
        StringBuilder oSB = new StringBuilder();
        try {
            FrameworkUtilities.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            for (TelnetParamEntity oTelnetParamEntity : telnetParamList) {
                oSB.append(oTelnetParamEntity.devName).append(" : ").append(TelnetCommon.testSingleDevConn(oTelnetParamEntity)).append('\n');
            }
        }
        catch (Exception e) {
            UMLogger.exception(e);
        }
        FrameworkUtilities.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        DMFUtils.showPromptMessageDialog((Component)FrameworkUtilities.getMainFrame(), (String)oSB.toString());
    }

    private static String testSingleDevConn(TelnetParamEntity oTelnetParamEntity) {
        UMLogger.debug(TelnetCommon.class, " testSingleDevConn ", " oTelnetParamEntity : " + oTelnetParamEntity);
        if (!EMLUtils.checkUserOeration((String)("" + oTelnetParamEntity.devID), (int)47880)) {
            return DMFUtils.getString((String)"noOperationRight");
        }
        AsnResTestParaReq oReq = new AsnResTestParaReq();
        oReq.iUserID = BigInteger.valueOf(DMFUtils.getUserID());
        oReq.iDevID = oTelnetParamEntity.devID;
        AsnResult oResp = new AsnResult();
        int r = EMLCommManager.getEMLCommService().sendSyncMessage(47880, oReq.iDevID.toString(), (FStruct)oReq, (FStruct)oResp);
        if (r != 0) {
            return DMFUtils.getEmfSecurityInterface().getErrorInfo(String.valueOf(103));
        }
        if (BigInteger.ZERO.equals(oResp.iCode)) {
            return ProtocolUtils.getString((String)"telnetDevice.strTestSucceedInfo");
        }
        return DMFUtils.getEmfSecurityInterface().getErrorInfo(String.valueOf(oResp.iCode.intValue()));
    }

    public static List<EmfTopoObjectInfo> getCurrTopoSelectedData() {
        UMUnitedMgrModule module = U2kModuleManagerFactory.getUMUnitedMgrModule();
        if (null == module) {
            UMLogger.debug(TelnetCommon.class, " getCurrTopoSelectedData() ", " module is null. ");
            return null;
        }
        InternalLocalMsg event = new InternalLocalMsg();
        event.ID = 4099;
        event.sendModule = module.getModuleName();
        event.data = null;
        List topoInfoList = null;
        try {
            UMLogger.debug(TelnetCommon.class.getName() + " sendEvent , module is :" + module + " destModuleId is : " + "com.swimap.adapter.message.tm");
            topoInfoList = (List)UMFrameAppAdapter.getInstance().sendEvent((BaseModule)module, "com.swimap.adapter.message.tm", event);
        }
        catch (Exception ex) {
            DMFDebugTracer.trace((Exception)ex);
        }
        event.ID = 4098;
        List devSubmapInfo = (List)UMFrameAppAdapter.getInstance().sendEvent((BaseModule)module, "com.swimap.adapter.message.tm", event);
        LinkedList<EmfTopoObjectInfo> devList = new LinkedList<EmfTopoObjectInfo>();
        ArrayList<Integer> neIDLst = new ArrayList<Integer>();
        Iterator iteratorSubmap = devSubmapInfo.iterator();
        EmfTopoObjectInfo emfTopoObj = null;
        while (iteratorSubmap.hasNext()) {
            emfTopoObj = (EmfTopoObjectInfo)iteratorSubmap.next();
            if (!(emfTopoObj instanceof EmfTopoContainerInfo) || !EMLNEUtils.isOwnedNEType((int)Integer.parseInt(((EmfTopoContainerInfo)emfTopoObj).m_szDevType))) continue;
            devList.add(emfTopoObj);
            neIDLst.add(((EmfTopoContainerInfo)emfTopoObj).m_iDevID);
        }
        Iterator iterator = topoInfoList.iterator();
        EmfTopoNodeInfo node = null;
        while (iterator.hasNext()) {
            node = (EmfTopoNodeInfo)iterator.next();
            if (!U2kUnitedUtilities.isU2KDevTypeID(node.m_szDevType) || !EMLNEUtils.isOwnedNEType((int)Integer.parseInt(node.m_szDevType)) || neIDLst.contains(node.m_iDevID)) continue;
            devList.add((EmfTopoObjectInfo)node);
        }
        return devList;
    }
}

