/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.inf.unitedmgr.fault;

import com.huawei.core.util.TEResourceUtil;
import com.huawei.u2000.basetool.uid.StrUIDParser;
import com.huawei.u2000.inf.unitedmgr.fault.UMAlarmSourceSimpleStruct;
import com.huawei.u2000.unitedmgr.fault.common.U2kAlmConstant;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.ifms.common.filter.FieldFilterInfo;
import com.swimap.external.ifms.ifmsclientmanagement.IfmsFunctionInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class UMFaultInfAdapter {
    private static UMFaultInfAdapter instance = null;
    protected TEResourceUtil res = TEResourceUtil.getInstance((String)U2kAlmConstant.resourceFile);
    private static final int MAINTANCE_VALUE = 16;

    private UMFaultInfAdapter() {
    }

    public void openFaultWindowWithFilterEnable(List<UMAlarmSourceSimpleStruct> alarmSourceList, String title, String windowID) {
        DataTable dt = this.getAlarmDataTable(alarmSourceList);
        IfmsFunctionInterface functionInterface = U2kModuleManagerFactory.getIfmsFunctionInterface();
        if (null == functionInterface) {
            UMLogger.debug(this.getClass(), " openFaultWindowWithFilterEnable ", " functionInterface is null");
            return;
        }
        HashMap<String, DataTable> alarmSource = new HashMap<String, DataTable>();
        alarmSource.put("u2000alarmsource", dt);
        functionInterface.openFaultWindow("Fault", title, windowID, null, null, null, alarmSource, null);
    }

    public void openFaultWindowWithFilterEnable(List<UMAlarmSourceSimpleStruct> alarmSourceList, String title, String windowID, int alarmSeverity) {
        DataTable dt = this.getAlarmDataTable(alarmSourceList);
        IfmsFunctionInterface functionInterface = U2kModuleManagerFactory.getIfmsFunctionInterface();
        if (null == functionInterface) {
            UMLogger.debug(this.getClass(), " openFaultWindowWithFilterEnable ", " functionInterface is null");
            return;
        }
        HashMap<String, DataTable> alarmSource = new HashMap<String, DataTable>();
        alarmSource.put("u2000alarmsource", dt);
        FieldFilterInfo fieldCond = new FieldFilterInfo();
        fieldCond.setName("severity");
        fieldCond.setField("severity");
        fieldCond.setOp("EQ");
        String[] valueSet = new String[]{String.valueOf(alarmSeverity)};
        fieldCond.setValueSet(valueSet);
        FieldFilterInfo[] filterInfo = new FieldFilterInfo[]{fieldCond};
        functionInterface.openFaultWindow("Fault", title, windowID, null, filterInfo, null, alarmSource, null);
    }

    public void showMaintanceAlmOnFaultWindow(List<UMAlarmSourceSimpleStruct> alarmSourceList, String title, String windowID) {
        DataTable dt = this.getAlarmDataTable(alarmSourceList);
        IfmsFunctionInterface functionInterface = U2kModuleManagerFactory.getIfmsFunctionInterface();
        if (null == functionInterface) {
            UMLogger.debug(this.getClass(), " showMaintanceAlmOnFaultWindow ", " functionInterface is null");
            return;
        }
        HashMap<String, DataTable> alarmSource = new HashMap<String, DataTable>();
        alarmSource.put("u2000alarmsource", dt);
        FieldFilterInfo fieldCond = new FieldFilterInfo();
        fieldCond.setName("ifms.base.specialalarmstatus");
        fieldCond.setField("specialAlarmStatus");
        fieldCond.setOp("EQ");
        String[] valueSet = new String[]{String.valueOf(16)};
        fieldCond.setValueSet(valueSet);
        FieldFilterInfo[] filterInfo = new FieldFilterInfo[]{fieldCond};
        functionInterface.openFaultWindow("Fault", title, windowID, null, filterInfo, null, alarmSource, null);
    }

    public void openHistoryFaultWindowWithFilterEnable(List<UMAlarmSourceSimpleStruct> alarmSourceList, String title, String windowID) {
        DataTable dataTable = this.getAlarmDataTable(alarmSourceList);
        IfmsFunctionInterface functionInterface = U2kModuleManagerFactory.getIfmsFunctionInterface();
        if (null == functionInterface) {
            UMLogger.debug(this.getClass(), " openHistoryFaultWindowWithFilterEnable ", " functionInterface is null");
            return;
        }
        HashMap<String, DataTable> alarmSource = new HashMap<String, DataTable>();
        alarmSource.put("u2000alarmsource", dataTable);
        functionInterface.openFaultWindow("HistoryLog", title, windowID, null, null, null, alarmSource, null);
    }

    private DataTable getAlarmDataTable(List<UMAlarmSourceSimpleStruct> alarmSourceList) {
        DataTable dt = new DataTable("u2000alarmsource");
        dt.setColumns(new String[]{"type", "name", "id", "alarmsourcetype"});
        String fdn = "";
        String strMOC = "";
        Iterator<UMAlarmSourceSimpleStruct> i$ = alarmSourceList.iterator();
        while (i$.hasNext()) {
            StrUIDParser fdnParser = new StrUIDParser();
            UMAlarmSourceSimpleStruct alarmSource = i$.next();
            fdn = alarmSource.getFdn();
            strMOC = fdnParser.parse(fdn) ? fdnParser.getMOC() : "";
            strMOC = this.res.getString(strMOC);
            dt.add(new Object[]{strMOC, alarmSource.getObjLabel(), fdn, "obj"});
        }
        return dt;
    }

    public static UMFaultInfAdapter getInstance() {
        if (null == instance) {
            instance = new UMFaultInfAdapter();
        }
        return instance;
    }
}

