/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.inf.inventory.autoexport;

import com.huawei.u2000.inf.inventory.autoexport.UMAutoExportConstant;
import com.huawei.u2000.inf.inventory.autoexport.UMAutoExportParam;
import com.huawei.u2000.inf.inventory.autoexport.UMAutoExportRunTask;
import com.huawei.u2000.util.U2kUnitedUtilities;
import com.huawei.u2000.util.UMLogger;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.PropertyResourceBundleEx;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class UMAutoExportFactory {
    private static UMAutoExportFactory instance;
    private List<UMAutoExportRunTask> autoExportRunTasks = new ArrayList<UMAutoExportRunTask>();

    private UMAutoExportFactory() {
    }

    public static synchronized UMAutoExportFactory getInstance() {
        if (null == instance) {
            instance = new UMAutoExportFactory();
        }
        return instance;
    }

    public UMAutoExportParam getExportParam() {
        UMAutoExportParam exportParam = new UMAutoExportParam();
        exportParam.setSettingsFlag(false);
        exportParam.setExistFile(false);
        CommStyleParser styleParser = U2kUnitedUtilities.getCommStyleParser();
        if (null == styleParser) {
            UMLogger.debug(this.getClass(), "getExportParam()", " styleParser is null.");
            return this.getClientSerialExportParam(exportParam);
        }
        try {
            CommStyleInfo styleInfo = styleParser.getUserCommStyleInfo("unitedmgr_cfg/u2000/inventory/autoexport/autoexport");
            if (null == styleInfo) {
                return this.getClientSerialExportParam(exportParam);
            }
            AreaDescContainer area = styleInfo.getAreaDescContainer(0);
            DescContainer descCon = area.getDescContainer("exportinvpara");
            if (null == descCon) {
                return this.getClientSerialExportParam(exportParam);
            }
            String strValue = this.getParaFromExportObject("settingsFlag", descCon);
            exportParam.setSettingsFlag(Boolean.valueOf(strValue.trim()));
            strValue = this.getParaFromExportObject("startDate", descCon);
            exportParam.setStartDate(Long.valueOf(strValue.trim()));
            strValue = this.getParaFromExportObject("endDate", descCon);
            exportParam.setEndDate(Long.valueOf(strValue.trim()));
            strValue = this.getParaFromExportObject("periodTextfield", descCon);
            exportParam.setPeriodTextField(Integer.valueOf(strValue.trim()));
            strValue = this.getParaFromExportObject("periodCombox", descCon);
            exportParam.setPeriodCombox(Integer.valueOf(strValue.trim()));
            strValue = this.getParaFromExportObject("filePath", descCon);
            exportParam.setFilepath(strValue.trim());
            strValue = this.getParaFromExportObject("fileFormat", descCon);
            exportParam.setFileFormat(Integer.valueOf(strValue.trim()));
            strValue = this.getParaFromExportObject("fileEncode", descCon);
            exportParam.setFileEncode(strValue.trim());
            strValue = this.getParaFromExportObject("lastExportDate", descCon);
            exportParam.setLastExportDate(Long.valueOf(strValue.trim()));
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
            return exportParam;
        }
        exportParam.setExistFile(true);
        return exportParam;
    }

    private UMAutoExportParam getClientSerialExportParam(UMAutoExportParam exportParam) {
        File file = new File(UMAutoExportConstant.getFilepath());
        if (file.exists()) {
            try {
                Properties prop1 = ResourceMng.getProperties((String)UMAutoExportConstant.getFilepath());
                PropertyResourceBundleEx prop = new PropertyResourceBundleEx(prop1);
                exportParam.setSettingsFlag(Boolean.valueOf(prop.getString("settingsFlag")));
                exportParam.setStartDate(Long.valueOf(prop.getString("startDate")));
                exportParam.setEndDate(Long.valueOf(prop.getString("endDate")));
                exportParam.setPeriodTextField(Integer.valueOf(prop.getString("periodTextfield")));
                exportParam.setPeriodCombox(Integer.valueOf(prop.getString("periodCombox")));
                exportParam.setFilepath(prop.getString("filePath"));
                exportParam.setFileFormat(Integer.valueOf(prop.getString("fileFormat")));
                exportParam.setFileEncode(prop.getString("fileEncode"));
                String strLastTime = prop.getString("lastExportDate");
                if (null == strLastTime || strLastTime.trim().isEmpty()) {
                    exportParam.setLastExportDate(System.currentTimeMillis());
                } else {
                    exportParam.setLastExportDate(Long.valueOf(prop.getString("lastExportDate")));
                }
            }
            catch (Exception e) {
                exportParam.setSettingsFlag(false);
                UMLogger.exception(e);
            }
        }
        exportParam.setExistFile(file.exists());
        return exportParam;
    }

    private String getParaFromExportObject(String strKey, DescContainer dcObject) {
        PARA para = dcObject.getParasItem(strKey);
        if (null == para) {
            return "";
        }
        return para.getValue();
    }

    public boolean registerExportRunTask(UMAutoExportRunTask exportRunTask) {
        if (null == exportRunTask) {
            UMLogger.debug("autoexport registerExportRunTask failed, the reason is: exportRunTask = null ");
            return false;
        }
        if (!this.autoExportRunTasks.contains(exportRunTask)) {
            boolean flag = this.autoExportRunTasks.add(exportRunTask);
            if (flag) {
                UMLogger.debug("the register auto export class is success:" + exportRunTask);
                UMLogger.debug("the wait for auto export now has:" + this.autoExportRunTasks);
                return true;
            }
            UMLogger.debug("the register auto export class is failed:" + exportRunTask);
            return false;
        }
        UMLogger.debug("autoexport registerExportRunTask failed:" + exportRunTask);
        UMLogger.debug("the " + exportRunTask + " has exist!");
        return false;
    }

    public boolean unRegisterExportRunTask(UMAutoExportRunTask exportRunTask) {
        return this.autoExportRunTasks.remove(exportRunTask);
    }

    public void clearExportRunTask() {
        this.autoExportRunTasks.clear();
    }

    public List<UMAutoExportRunTask> getAutoExportRunTasks() {
        return this.autoExportRunTasks;
    }
}

