/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.startup;

import com.swimap.startup.NotValidStartupXMLException;
import com.swimap.startup.PatchInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public class StartupClassLoader
extends URLClassLoader {
    private static StartupClassLoader instance = null;
    private static final String PATCH_FOLDER = System.getProperty("user.dir") + "/patch";
    private static final String JAR_SUFFIX = ".jar";
    private static final String LIB = System.getProperty("user.dir") + "/lib";
    private static final String PRODUCTLIB_FOLDER = System.getProperty("user.dir") + "/productlib";
    private static String pathName = "link.properties";
    private static final boolean LINK_EXIST = StartupClassLoader.checklinkExists();
    private Map<String, List<URL>> pluginJarMap = new HashMap<String, List<URL>>(16);
    private Map<String, String> normalPluginsMap = new TreeMap<String, String>();
    private Map<String, String> osgiPluginsMap = new TreeMap<String, String>();
    private Map<String, List<URL>> urlMap = new HashMap<String, List<URL>>(16);
    private volatile boolean isConfigurationPresent = false;
    private boolean enableSerialization = Boolean.getBoolean("serialize");
    private LinkedHashMap<String, LinkedHashSet<String>> startupJarsXMLMap = new LinkedHashMap(16);
    private boolean isNeedWrite = false;
    private boolean isLogin = true;
    private ConcurrentHashMap<String, Integer> indexMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, URL> resMap = new ConcurrentHashMap();
    private static int scanLen = 100;
    private static final String SER_DIR = System.getProperty("user.dir") + "/configuration/Serializable/";
    private static String patchFilePath = null;
    private Vector<URLClassPath> dynamicUCPList = new Vector();
    private AccessControlContext dynamicAcc = AccessController.getContext();

    public StartupClassLoader(ClassLoader classLoader) {
        this(classLoader, true);
    }

    public StartupClassLoader(ClassLoader classLoader, boolean bl) {
        super(new URL[0], classLoader);
        try {
            patchFilePath = new File(PATCH_FOLDER).getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bl) {
            this.initializeURLAndPath(true);
        }
        instance = this;
        if (this.enableSerialization) {
            this.loadIndex();
        }
    }

    private void loadIndex() {
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this.readData(File.separator + "CINDEX.dat");
        if (concurrentHashMap != null) {
            this.indexMap.putAll(concurrentHashMap);
        }
        ConcurrentHashMap concurrentHashMap2 = (ConcurrentHashMap)this.readData(File.separator + "RINDEX.dat");
        if (concurrentHashMap != null) {
            this.resMap.putAll(concurrentHashMap2);
        }
    }

    public void writeSrealizedIndex() {
        this.writeData(File.separator + "CINDEX" + ".dat", this.indexMap);
        this.writeData(File.separator + "RINDEX" + ".dat", this.resMap);
    }

    public static StartupClassLoader getInstance() {
        return instance;
    }

    public static StartupClassLoader createInstance() {
        if (null == instance) {
            instance = new StartupClassLoader(StartupClassLoader.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(instance);
        }
        return instance;
    }

    private void initURL() {
        URL[] uRLArray;
        LinkedHashMap<String, ArrayList> linkedHashMap = this.readConfigFile("loadingstrategy.cfg");
        File file = new File(PATCH_FOLDER);
        if (file.exists() && !LINK_EXIST) {
            uRLArray = this.searchURL(PATCH_FOLDER);
            boolean bl = Boolean.valueOf(System.getProperty("patchtime"));
            if (bl) {
                this.addURLTimeStampStratergy(uRLArray, false);
            } else {
                this.addURL(uRLArray, linkedHashMap, patchFilePath);
            }
        }
        if (!this.loadURLFromCfg(linkedHashMap)) {
            uRLArray = this.searchURL(LIB);
            this.addURL(uRLArray, linkedHashMap, LIB);
        }
    }

    private boolean loadURLFromCfg(LinkedHashMap<String, ArrayList> linkedHashMap) {
        boolean bl = false;
        if (null != linkedHashMap && !linkedHashMap.isEmpty()) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(linkedHashMap.keySet());
            Iterator iterator = linkedHashSet.iterator();
            String string = null;
            String string2 = null;
            try {
                string = new File(LIB).getCanonicalPath();
                string2 = new File(PRODUCTLIB_FOLDER).getCanonicalPath();
            }
            catch (IOException iOException) {
                StartupClassLoader.printStackTrace(iOException);
            }
            String string3 = null;
            String string4 = null;
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                try {
                    string3 = new File(string4).getCanonicalPath();
                    if (string3.equals(string)) {
                        bl = true;
                    } else if (string3.equals(patchFilePath) || string3.equals(string2) && LINK_EXIST) continue;
                    URL[] uRLArray = this.searchURL(string3);
                    this.addURL(uRLArray, linkedHashMap, string4);
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
            }
        }
        return bl;
    }

    public void loadProductLibJars(List<String> list) {
        ArrayList arrayList = new ArrayList(10);
        ArrayList arrayList2 = null;
        for (String object : list) {
            arrayList2 = new ArrayList(10);
            if (this.enableSerialization && this.urlMap.containsKey(PRODUCTLIB_FOLDER + '/' + object)) {
                arrayList2 = (ArrayList)this.urlMap.get(PRODUCTLIB_FOLDER + '/' + object);
            } else {
                this.getURLList(PRODUCTLIB_FOLDER + '/' + object, arrayList2);
                if (this.enableSerialization) {
                    this.urlMap.put(PRODUCTLIB_FOLDER + '/' + object, arrayList2);
                }
            }
            arrayList.addAll(arrayList2);
        }
        for (URL uRL : arrayList) {
            this.addURL(uRL, true);
        }
    }

    public void loadPatchJars(List<String> list) {
        ArrayList arrayList = new ArrayList(10);
        ArrayList arrayList2 = null;
        for (String uRLArray : list) {
            arrayList2 = new ArrayList(10);
            if (this.enableSerialization && this.urlMap.containsKey(PATCH_FOLDER + '/' + uRLArray)) {
                arrayList2 = (ArrayList)this.urlMap.get(PATCH_FOLDER + '/' + uRLArray);
            } else {
                this.getURLList(PATCH_FOLDER + '/' + uRLArray, arrayList2);
                if (this.enableSerialization) {
                    this.urlMap.put(PATCH_FOLDER + '/' + uRLArray, arrayList2);
                }
            }
            arrayList.addAll(arrayList2);
        }
        int n = arrayList.size();
        if (n > 0) {
            URL[] uRLArray = new URL[n];
            arrayList.toArray(uRLArray);
            this.addURLTimeStampStratergy(uRLArray, true);
        }
    }

    private static File getAbsoluteFile(String string) {
        File file = new File(string);
        return file.getAbsoluteFile();
    }

    private static boolean checklinkExists() {
        String string = System.getProperty("linkfile");
        File file = null;
        if (null != string) {
            file = StartupClassLoader.getAbsoluteFile(string);
            if (!file.exists()) {
                string = pathName;
                file = StartupClassLoader.getAbsoluteFile(string);
            }
        } else {
            string = pathName;
            file = StartupClassLoader.getAbsoluteFile(string);
        }
        return file.exists();
    }

    private void initLibrary() {
        File file = new File(LIB);
        if (file.exists()) {
            String string = System.getProperty("java.library.path");
            if (string != null) {
                string = string.endsWith(System.getProperty("path.separator")) ? string + file.getAbsoluteFile().toString() : string + System.getProperty("path.separator") + file.getAbsoluteFile().toString();
                System.setProperty("java.library.path", string);
            } else {
                System.setProperty("java.library.path", file.getAbsoluteFile().toString());
            }
        }
    }

    public void addURL(URL[] uRLArray) {
        this.addURL(uRLArray, false);
    }

    private void addURL(URL[] uRLArray, boolean bl) {
        if (null != uRLArray) {
            for (URL uRL : uRLArray) {
                this.addURL(uRL, bl);
            }
        }
    }

    public void clearDynamicUCP() {
        for (URLClassPath uRLClassPath : this.dynamicUCPList) {
            uRLClassPath = null;
        }
        this.dynamicUCPList.clear();
    }

    protected void addURL(URL uRL, boolean bl) {
        if (bl) {
            if (this.dynamicUCPList.size() == 0 || this.dynamicUCPList.size() > 0 && this.dynamicUCPList.get(this.dynamicUCPList.size() - 1).getURLs().length > scanLen) {
                URLClassPath uRLClassPath = new URLClassPath(new URL[0]);
                this.dynamicUCPList.add(uRLClassPath);
            }
            this.dynamicUCPList.get(this.dynamicUCPList.size() - 1).addURL(uRL);
        } else {
            super.addURL(uRL);
        }
    }

    @Override
    public URL[] getURLs() {
        URL[] uRLArray2 = super.getURLs();
        if (this.dynamicUCPList.size() == 0) {
            return uRLArray2;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(16);
        for (URLClassPath uRLArray3 : this.dynamicUCPList) {
            arrayList.addAll(Arrays.asList(uRLArray3.getURLs()));
        }
        URL[] uRLArray4 = arrayList.toArray(new URL[arrayList.size()]);
        URL[] uRLArray = new URL[uRLArray4.length + uRLArray2.length];
        System.arraycopy(uRLArray4, 0, uRLArray, 0, uRLArray4.length);
        System.arraycopy(uRLArray2, 0, uRLArray, uRLArray4.length, uRLArray2.length);
        return uRLArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> T readData(String string) {
        Serializable serializable = null;
        if (string == null) {
            return null;
        }
        File file = new File(SER_DIR + string);
        ObjectInputStream objectInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(fileInputStream);
                serializable = (Serializable)objectInputStream.readObject();
            }
        }
        catch (IOException iOException) {
            System.out.println("Serialization Reading Error " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Serialization Reading Error " + classNotFoundException);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println("Stream not able to close " + iOException);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println("Stream not able to close " + iOException);
                }
            }
        }
        return (T)serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> void writeData(String string, T t) {
        File file = new File(SER_DIR + string);
        if (!file.exists()) {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        if (t != null) {
            boolean bl = false;
            ObjectOutput objectOutput = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                objectOutput = new ObjectOutputStream(fileOutputStream);
                objectOutput.writeObject(t);
            }
            catch (IOException iOException) {
                System.out.println("Serialization Writing Error " + iOException);
                bl = true;
            }
            finally {
                if (objectOutput != null) {
                    try {
                        objectOutput.close();
                    }
                    catch (IOException iOException) {
                        System.out.println("Stream not able to close" + iOException);
                        bl = true;
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        System.out.println("Stream not able to close" + iOException);
                    }
                }
                if (bl) {
                    file.delete();
                }
            }
        }
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        if (this.isLogin) {
            if (this.dynamicUCPList.size() > 0) {
                for (URLClassPath uRLClassPath : this.dynamicUCPList) {
                    try {
                        return this.findClass(string, uRLClassPath);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            return super.findClass(string);
        }
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.dynamicUCPList.size() > 0) {
                int n;
                if (null != this.indexMap.get(string)) {
                    n = this.indexMap.get(string);
                    if (this.dynamicUCPList.size() > n) {
                        try {
                            return this.findClass(string, this.dynamicUCPList.get(n));
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            // empty catch block
                        }
                    }
                }
                n = -1;
                for (URLClassPath uRLClassPath : this.dynamicUCPList) {
                    ++n;
                    try {
                        Class<?> clazz = this.findClass(string, uRLClassPath);
                        this.indexMap.put(string, n);
                        return clazz;
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                    }
                }
            }
            throw classNotFoundException;
        }
    }

    @Override
    public URL findResource(String string) {
        if (this.isLogin) {
            if (this.dynamicUCPList.size() > 0) {
                URL uRL = null;
                for (URLClassPath uRLClassPath : this.dynamicUCPList) {
                    uRL = this.findResource(string, uRLClassPath);
                    if (null == uRL) continue;
                    return uRL;
                }
            }
            return super.findResource(string);
        }
        if (null != this.resMap.get(string)) {
            URL uRL = this.resMap.get(string);
            return uRL;
        }
        URL uRL = super.findResource(string);
        if (null == uRL && this.dynamicUCPList.size() > 0) {
            for (URLClassPath uRLClassPath : this.dynamicUCPList) {
                uRL = this.findResource(string, uRLClassPath);
                if (null == uRL) continue;
                if (null != string) {
                    this.resMap.put(string, uRL);
                }
                return uRL;
            }
        } else if (null != string && null != uRL) {
            this.resMap.put(string, uRL);
        }
        return uRL;
    }

    private URL findResource(final String string, final URLClassPath uRLClassPath) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return uRLClassPath.findResource(string, true);
            }
        }, this.dynamicAcc);
        return uRL != null ? uRLClassPath.checkURL(uRL) : null;
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        Vector<URL> vector = new Vector<URL>();
        if (this.dynamicUCPList.size() > 0) {
            for (URLClassPath uRLClassPath : this.dynamicUCPList) {
                try {
                    vector.addAll(this.findResources(string, uRLClassPath));
                }
                catch (IOException iOException) {}
            }
        }
        Enumeration<URL> enumeration = super.findResources(string);
        while (enumeration.hasMoreElements()) {
            vector.add((URL)enumeration.nextElement());
        }
        return vector.elements();
    }

    private Vector<URL> findResources(String string, final URLClassPath uRLClassPath) throws IOException {
        final Enumeration enumeration = uRLClassPath.findResources(string, true);
        Enumeration<URL> enumeration2 = new Enumeration<URL>(){
            private URL url = null;

            private boolean next() {
                URL uRL;
                if (this.url != null) {
                    return true;
                }
                while ((uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (!enumeration.hasMoreElements()) {
                            return null;
                        }
                        return enumeration.nextElement();
                    }
                }, StartupClassLoader.this.dynamicAcc)) != null) {
                    this.url = uRLClassPath.checkURL(uRL);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }
        };
        Vector<URL> vector = new Vector<URL>();
        while (enumeration2.hasMoreElements()) {
            vector.add((URL)enumeration2.nextElement());
        }
        return vector;
    }

    protected Class<?> findClass(final String string, final URLClassPath uRLClassPath) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String string2 = string.replace('.', '/').concat(".class");
                    Resource resource = uRLClassPath.getResource(string2, false);
                    if (resource != null) {
                        try {
                            return StartupClassLoader.this.defineClass(string, resource);
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(string, iOException);
                        }
                    }
                    throw new ClassNotFoundException(string);
                }
            }, this.dynamicAcc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        CodeSigner[] codeSignerArray;
        CodeSigner[] codeSignerArray2;
        Object object;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object = string.substring(0, n);
            codeSignerArray2 = this.getPackage((String)object);
            codeSignerArray = resource.getManifest();
            if (codeSignerArray2 != null) {
                if (codeSignerArray2.isSealed()) {
                    if (!codeSignerArray2.isSealed(uRL)) {
                        throw new SecurityException("sealing violation: package " + (String)object + " is sealed");
                    }
                } else if (codeSignerArray != null && this.isSealed((String)object, (Manifest)codeSignerArray)) {
                    throw new SecurityException("sealing violation: can't seal package " + (String)object + ": already loaded");
                }
            } else if (codeSignerArray != null) {
                this.definePackage((String)object, (Manifest)codeSignerArray, uRL);
            } else {
                this.definePackage((String)object, null, null, null, null, null, null, null);
            }
        }
        if ((object = resource.getByteBuffer()) != null) {
            codeSignerArray2 = resource.getCodeSigners();
            codeSignerArray = new CodeSource(uRL, codeSignerArray2);
            return this.defineClass(string, (ByteBuffer)object, (CodeSource)codeSignerArray);
        }
        codeSignerArray2 = (CodeSigner[])resource.getBytes();
        codeSignerArray = resource.getCodeSigners();
        CodeSource codeSource = new CodeSource(uRL, codeSignerArray);
        return this.defineClass(string, (byte[])codeSignerArray2, 0, codeSignerArray2.length, codeSource);
    }

    @Override
    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    private void getURLList(String string, ArrayList<URL> arrayList) {
        File file = null;
        try {
            file = new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            StartupClassLoader.printStackTrace(iOException);
        }
        if (null != file && file.exists()) {
            this.searchURL(file, arrayList);
        }
    }

    private URL[] searchURL(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>(10);
        this.getURLList(string, arrayList);
        URL[] uRLArray = new URL[arrayList.size()];
        return arrayList.toArray(uRLArray);
    }

    public void installPlugins(File[] fileArray, boolean bl) {
        ArrayList<File> arrayList = null;
        ArrayList<File> arrayList2 = null;
        File[] fileArray2 = fileArray;
        if (null != fileArray2) {
            int n = fileArray.length;
            arrayList = new ArrayList<File>(n);
            arrayList2 = new ArrayList<File>(n);
            for (File file : fileArray2) {
                boolean bl2 = false;
                if (this.isConfigurationPresent) {
                    bl2 = this.checkPluginExists(file, arrayList2, arrayList);
                }
                if (bl2) continue;
                if (this.isOSGIPlugin(file)) {
                    arrayList.add(file);
                    if (!this.enableSerialization) continue;
                    this.osgiPluginsMap.put(file.getName(), file.getAbsolutePath());
                    this.isNeedWrite = true;
                    continue;
                }
                arrayList2.add(file);
                if (!this.enableSerialization) continue;
                this.normalPluginsMap.put(file.getName(), file.getAbsolutePath());
                this.isNeedWrite = true;
            }
        }
        if (null != arrayList2) {
            URL[] uRLArray = this.searchPluginLibs(arrayList2);
            this.addURL(uRLArray, bl);
        }
    }

    private boolean checkPluginExists(File file, List<File> list, List<File> list2) {
        String string = file.getName();
        if (this.normalPluginsMap.containsKey(string)) {
            list.add(file);
            return true;
        }
        if (this.osgiPluginsMap.containsKey(string)) {
            list2.add(file);
            return true;
        }
        return false;
    }

    private URL[] searchPluginLibs(List<File> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(5);
        ArrayList<Object> arrayList2 = new ArrayList(10);
        String string = null;
        for (File file : list) {
            arrayList2 = new ArrayList(10);
            string = file.getAbsolutePath();
            if (this.enableSerialization && this.pluginJarMap.containsKey(string)) {
                try {
                    if (file.getName().endsWith(JAR_SUFFIX)) {
                        this.handleJarInsideJar(file);
                    }
                }
                catch (Exception exception) {
                    StartupClassLoader.printStackTrace(exception);
                }
                arrayList2.addAll((Collection)this.pluginJarMap.get(string));
            } else {
                arrayList2 = this.searchSinglePlugin(file);
                if (this.enableSerialization) {
                    this.pluginJarMap.put(string, arrayList2);
                }
            }
            arrayList.addAll(arrayList2);
        }
        URL[] uRLArray = new URL[arrayList.size()];
        return arrayList.toArray(uRLArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOSGIPlugin(File file) {
        File file2;
        if (null == file) {
            return false;
        }
        if (file.toString().endsWith(JAR_SUFFIX)) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                JarEntry jarEntry = null;
                String string = null;
                while (enumeration.hasMoreElements()) {
                    InputStream inputStream;
                    jarEntry = enumeration.nextElement();
                    string = jarEntry.getName();
                    if (!string.startsWith("META-INF") || !string.endsWith("MANIFEST.MF") || null == (inputStream = jarFile.getInputStream(jarEntry))) continue;
                    Manifest manifest = new Manifest(inputStream);
                    Attributes attributes = manifest.getMainAttributes();
                    boolean bl = attributes.getValue("Bundle-SymbolicName") != null;
                    try {
                        inputStream.close();
                        return bl;
                    }
                    catch (IOException iOException) {
                        StartupClassLoader.printStackTrace(iOException);
                    }
                    return bl;
                    catch (IOException iOException) {
                        try {
                            try {
                                StartupClassLoader.printStackTrace(iOException);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException2) {
                                    StartupClassLoader.printStackTrace(iOException2);
                                }
                            }
                        }
                        catch (IOException iOException3) {
                            StartupClassLoader.printStackTrace(iOException3);
                            return false;
                        }
                        catch (SecurityException securityException) {
                            StartupClassLoader.printStackTrace(securityException);
                            return false;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return false;
                        }
                    }
                }
            }
            finally {
                if (null != jarFile) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        StartupClassLoader.printStackTrace(iOException);
                    }
                }
            }
        }
        File file3 = new File(file, "META-INF");
        if (!file3.exists() || !(file2 = new File(file3, "MANIFEST.MF")).exists()) return false;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            Manifest manifest = new Manifest(fileInputStream);
            Attributes attributes = manifest.getMainAttributes();
            boolean bl = attributes.getValue("Bundle-SymbolicName") != null;
            return bl;
        }
        catch (IOException iOException) {
            StartupClassLoader.printStackTrace(iOException);
            return false;
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
            }
        }
    }

    private ArrayList<URL> searchSinglePlugin(File file) {
        boolean bl = false;
        ArrayList<URL> arrayList = new ArrayList<URL>(10);
        if (file.exists() && !file.getAbsolutePath().endsWith(JAR_SUFFIX)) {
            PluginFileFilter pluginFileFilter = new PluginFileFilter();
            File[] fileArray = file.listFiles(pluginFileFilter);
            for (File file2 : fileArray) {
                try {
                    if (file2.isDirectory() && !bl) {
                        arrayList.add(file.toURI().toURL());
                        bl = true;
                        continue;
                    }
                    if (!file2.getName().endsWith(JAR_SUFFIX)) continue;
                    arrayList.add(file2.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    StartupClassLoader.printStackTrace(malformedURLException);
                }
            }
            File file3 = new File(file, "lib");
            if (file3.exists()) {
                this.searchURL(file3, arrayList);
            }
        } else {
            this.handleJarInsideJar(file);
            try {
                arrayList.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                StartupClassLoader.printStackTrace(malformedURLException);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJarInsideJar(File file) {
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            String string = this.getNameFromPluginURL(file);
            zipFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
            JarEntry jarEntry = null;
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !(string2 = jarEntry.getName()).startsWith("lib") || !string2.endsWith(JAR_SUFFIX) || null == (inputStream = ((JarFile)zipFile).getInputStream(jarEntry))) continue;
                String string3 = System.getProperty("user.dir") + "/configuration/iView/plugins/" + string + '/' + jarEntry;
                this.copy(inputStream, string3);
                File file2 = new File(string3);
                this.addURL(file2.toURI().toURL());
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
            }
        }
        catch (IOException iOException) {
            StartupClassLoader.printStackTrace(iOException);
        }
        catch (SecurityException securityException) {
            StartupClassLoader.printStackTrace(securityException);
        }
        finally {
            if (null != zipFile) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
            }
        }
    }

    private String getNameFromPluginURL(File file) {
        String string = file.getPath().replaceAll("%20", " ");
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        int n2 = string.lastIndexOf(JAR_SUFFIX);
        string = string.substring(n + 1, n2);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(InputStream inputStream, String string) {
        File file = new File(string);
        String string2 = file.getParent();
        File file2 = new File(string2);
        file2.getAbsoluteFile().mkdirs();
        if (file.isDirectory()) {
            file = new File(file.getParent(), file.getName());
        }
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        InputStream inputStream2 = inputStream;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[4096];
            int n = inputStream2.read(byArray);
            while (-1 != n) {
                fileOutputStream.write(byArray, 0, n);
                n = inputStream2.read(byArray);
            }
        }
        catch (IOException iOException) {
            StartupClassLoader.printStackTrace(iOException);
        }
        finally {
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
            }
        }
        return true;
    }

    private void searchURL(File file, ArrayList<URL> arrayList) {
        if (null != file) {
            if (file.isFile() && file.getName().endsWith(JAR_SUFFIX)) {
                try {
                    if (!this.startupJarsXMLMap.containsValue(file.getName())) {
                        arrayList.add(file.toURI().toURL());
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    StartupClassLoader.printStackTrace(malformedURLException);
                }
            } else {
                Object[] objectArray = file.listFiles();
                if (null != objectArray) {
                    Arrays.sort(objectArray);
                    for (Object object : objectArray) {
                        this.searchURL((File)object, arrayList);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, ArrayList> readConfigFile(String string) {
        String string2 = System.getProperty("user.dir");
        File file = new File(string2, string);
        LinkedHashMap linkedHashMap = null;
        if (file.exists()) {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                String string3 = bufferedReader.readLine();
                linkedHashMap = new LinkedHashMap();
                ArrayList<String> arrayList = null;
                int n = 0;
                while (null != string3) {
                    n = (string3 = string3.trim()).length();
                    if (n > 1 && string3.charAt(0) == '[' && string3.charAt(n - 1) == ']') {
                        arrayList = new ArrayList<String>(10);
                        linkedHashMap.put(new File(string3.substring(1, n - 1)).getCanonicalPath(), arrayList);
                    } else if (n > 0 && null != arrayList) {
                        arrayList.add(string3);
                    }
                    string3 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                StartupClassLoader.printStackTrace(iOException);
            }
            finally {
                if (null != bufferedReader) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        StartupClassLoader.printStackTrace(iOException);
                    }
                }
                if (null != fileReader) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        StartupClassLoader.printStackTrace(iOException);
                    }
                }
            }
        }
        return linkedHashMap;
    }

    private void addURL(URL[] uRLArray, LinkedHashMap<String, ArrayList> linkedHashMap, String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(uRLArray));
        if (null != linkedHashMap && null != linkedHashMap.get(string)) {
            if (!arrayList.isEmpty()) {
                this.validateAndAddURLFromCfg(arrayList, linkedHashMap, string);
            }
            linkedHashMap.remove(string);
        }
        if (string.equals(patchFilePath)) {
            this.addURLReverseStrategy(arrayList);
        } else {
            this.addURLForwardStrategy(arrayList);
        }
    }

    private void addURLSFromBootupCfg(String string) {
        block6: {
            if (null != this.startupJarsXMLMap && null != this.startupJarsXMLMap.get(string)) {
                String string2 = System.getProperty("file.separator");
                LinkedHashSet<String> linkedHashSet = this.startupJarsXMLMap.get(string);
                URL uRL = null;
                try {
                    File file = null;
                    if (null == linkedHashSet) break block6;
                    for (String string3 : linkedHashSet) {
                        try {
                            file = new File(string + string2 + string3).getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            StartupClassLoader.printStackTrace(iOException);
                        }
                        if (null == file) continue;
                        uRL = file.toURI().toURL();
                        this.addURL(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    StartupClassLoader.printStackTrace(malformedURLException);
                }
            }
        }
    }

    private void validateAndAddURLFromCfg(List<URL> list, LinkedHashMap<String, ArrayList> linkedHashMap, String string) {
        String string2 = System.getProperty("file.separator");
        ArrayList arrayList = linkedHashMap.get(string);
        URL uRL = null;
        try {
            File file = null;
            while (arrayList != null && !arrayList.isEmpty()) {
                try {
                    file = new File(string + string2 + arrayList.get(0)).getCanonicalFile();
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
                if (null != file && list.contains(uRL = file.toURI().toURL())) {
                    this.addURL(uRL);
                    list.remove(uRL);
                }
                arrayList.remove(0);
            }
        }
        catch (MalformedURLException malformedURLException) {
            StartupClassLoader.printStackTrace(malformedURLException);
        }
    }

    private void addURLReverseStrategy(List<URL> list) {
        ListIterator<URL> listIterator = list.listIterator(list.size());
        URL uRL = null;
        boolean bl = listIterator.hasPrevious();
        while (bl) {
            uRL = listIterator.previous();
            this.addURL(uRL);
            bl = listIterator.hasPrevious();
        }
    }

    private void addURLForwardStrategy(List<URL> list) {
        for (URL uRL : list) {
            this.addURL(uRL);
        }
    }

    private void addURLTimeStampStratergy(URL[] uRLArray, boolean bl) {
        Object object;
        ArrayList<PatchInfo> arrayList = new ArrayList<PatchInfo>(10);
        ArrayList<File> arrayList2 = new ArrayList<File>(5);
        JarFile jarFile = null;
        PatchInfo patchInfo = null;
        File file = null;
        URL uRL = null;
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                object = uRLArray[i].toURI().getPath();
                uRL = new URL("file", null, (String)object);
            }
            catch (URISyntaxException uRISyntaxException) {
                StartupClassLoader.printStackTrace(uRISyntaxException);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                StartupClassLoader.printStackTrace(malformedURLException);
                continue;
            }
            file = new File(uRL.getPath());
            if (!file.isFile()) continue;
            try {
                jarFile = new JarFile(file);
            }
            catch (Exception exception) {
                StartupClassLoader.printStackTrace(exception);
                jarFile = null;
                continue;
            }
            patchInfo = PatchInfo.createPatchInfo(jarFile, file);
            if (null != jarFile) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
            }
            if (null != patchInfo) {
                arrayList.add(patchInfo);
                continue;
            }
            arrayList2.add(file);
        }
        Collections.sort(arrayList);
        PatchInfo[] patchInfoArray = arrayList.toArray(new PatchInfo[arrayList.size()]);
        object = null;
        for (int i = patchInfoArray.length - 1; i >= 0; --i) {
            object = patchInfoArray[i].getURL();
            if (null == object) continue;
            this.addURL((URL)object, bl);
        }
        for (File file2 : arrayList2) {
            try {
                object = file2.toURI().toURL();
                if (null == object) continue;
                this.addURL((URL)object, bl);
            }
            catch (MalformedURLException malformedURLException) {
                StartupClassLoader.printStackTrace(malformedURLException);
            }
        }
    }

    private static void printStackTrace(Exception exception) {
        exception.printStackTrace();
    }

    public Map<String, List<URL>> getPluginJarURLsMap() {
        return this.pluginJarMap;
    }

    public void setPluginJarURLsMap(Map<String, List<URL>> map) {
        this.pluginJarMap = map;
    }

    public Map<String, String> getNormalPlugins() {
        return this.normalPluginsMap;
    }

    public void setNormalPlugins(Map<String, String> map) {
        this.normalPluginsMap = map;
    }

    public Map<String, String> getOsgiPlugins() {
        return this.osgiPluginsMap;
    }

    public void setOsgiPlugins(Map<String, String> map) {
        this.osgiPluginsMap = map;
    }

    public Map<String, List<URL>> getUrlMap() {
        return this.urlMap;
    }

    public void setUrlMap(Map<String, List<URL>> map) {
        this.urlMap = map;
    }

    public void setConfigurationPresent(boolean bl) {
        this.isConfigurationPresent = bl;
    }

    public void initializeURLAndPath(boolean bl) {
        this.initURL();
        if (bl) {
            this.initLibrary();
        }
    }

    public boolean isStartupFeatureAsSecurity() {
        String string = System.getProperty("startupfeature");
        String string2 = System.getProperty("subsystem");
        return "securitymanager".equals(string) && null == string2;
    }

    public void initStartupXML(File file) throws NotValidStartupXMLException {
        this.readAndLoadStartupXML(file);
        this.initLibrary();
    }

    private void readAndLoadMultipleStartupXMLS(LinkedHashMap<String, LinkedHashSet<String>> linkedHashMap) {
        File[] fileArray;
        File file = new File(System.getProperty("user.dir"));
        for (File file2 : fileArray = file.listFiles(new StartupFileFilter())) {
            this.readStartupXML(file2, linkedHashMap);
        }
    }

    public void readAndLoadStartupXML(File file) throws NotValidStartupXMLException {
        LinkedHashMap<String, LinkedHashSet<String>> linkedHashMap = new LinkedHashMap<String, LinkedHashSet<String>>();
        if (file.exists()) {
            this.readStartupXML(file, linkedHashMap);
        }
        this.readAndLoadMultipleStartupXMLS(linkedHashMap);
        if (null != linkedHashMap) {
            this.startupJarsXMLMap.putAll(linkedHashMap);
            this.addURLsFromStartupXML(linkedHashMap);
        }
    }

    private void addURLsFromStartupXML(LinkedHashMap<String, LinkedHashSet<String>> linkedHashMap) {
        if (null != linkedHashMap && !linkedHashMap.isEmpty()) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(linkedHashMap.keySet());
            for (String string : linkedHashSet) {
                this.addURLSFromBootupCfg(string);
            }
        }
    }

    private void readStartupXML(File file, LinkedHashMap<String, LinkedHashSet<String>> linkedHashMap) throws NotValidStartupXMLException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        FileInputStream fileInputStream = null;
        Document document = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            fileInputStream = new FileInputStream(file);
            document = documentBuilder.parse(fileInputStream);
            this.getStartupXMLValues(linkedHashMap, document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new NotValidStartupXMLException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            throw new NotValidStartupXMLException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new NotValidStartupXMLException(iOException.toString());
        }
        catch (Throwable throwable) {
            throw new NotValidStartupXMLException(throwable.toString());
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    StartupClassLoader.printStackTrace(iOException);
                }
            }
        }
    }

    private void getStartupXMLValues(LinkedHashMap<String, LinkedHashSet<String>> linkedHashMap, Document document) throws NotValidStartupXMLException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = null;
        XPathExpression xPathExpression2 = null;
        XPathExpression xPathExpression3 = null;
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        try {
            xPathExpression = xPath.compile("/COMMINIDATA/AREADESC/DESC[@descname='startupjars']/*");
            object2 = xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (null == object2) {
                throw new NotValidStartupXMLException("startupjarsDesc is not present");
            }
            NodeList nodeList = (NodeList)object2;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                File[] fileArray;
                File[] fileArray2;
                Node node;
                xPathExpression3 = xPath.compile("/COMMINIDATA/AREADESC/DESC[@descname='startupjars']/DESC[" + (i + 1) + "]");
                object = xPathExpression3.evaluate(document, XPathConstants.NODE);
                if (object == null) continue;
                Node node2 = (Node)object;
                LinkedHashSet<String> linkedHashSet = null;
                if (null == node2 || node2.getAttributes() == null || (node = node2.getAttributes().item(0)) == null) continue;
                String string = node.getNodeValue();
                File file = null;
                try {
                    file = new File(string);
                    String string2 = file.getCanonicalPath();
                    linkedHashSet = linkedHashMap.get(string2);
                    if (null == linkedHashSet) {
                        linkedHashSet = new LinkedHashSet(10);
                        linkedHashMap.put(string2, linkedHashSet);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                xPathExpression2 = xPath.compile("/COMMINIDATA/AREADESC/DESC[@descname='startupjars']/DESC[" + (i + 1) + "]/PARAS/*");
                object3 = xPathExpression2.evaluate(document, XPathConstants.NODESET);
                if (null == object3) continue;
                boolean bl = false;
                NodeList nodeList2 = (NodeList)object3;
                int n2 = nodeList2.getLength();
                Node node3 = null;
                for (int j = 0; j < n2; ++j) {
                    node3 = nodeList2.item(j);
                    if (null == node3 || null == (fileArray2 = node3.getAttributes().item(0))) continue;
                    bl = true;
                    linkedHashSet.add(fileArray2.getNodeValue());
                }
                if (bl || null == (fileArray = file.listFiles(new JarFilter()))) continue;
                fileArray2 = fileArray;
                int n3 = fileArray2.length;
                for (int j = 0; j < n3; ++j) {
                    File file2 = fileArray2[j];
                    linkedHashSet.add(file2.getName());
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new NotValidStartupXMLException(xPathExpressionException.toString());
        }
    }

    public boolean isNeedWrite() {
        return this.isNeedWrite;
    }

    public void setLogin(boolean bl) {
        this.isLogin = bl;
        scanLen = 100;
    }

    class PluginFileFilter
    implements FileFilter {
        PluginFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.getName().endsWith("style") || file.getName().endsWith("lib")) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(StartupClassLoader.JAR_SUFFIX);
        }
    }

    class StartupFileFilter
    implements FilenameFilter {
        StartupFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith("_startup.xml");
        }
    }

    class JarFilter
    implements FileFilter {
        JarFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(StartupClassLoader.JAR_SUFFIX);
        }
    }
}

