/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.startup;

import com.swimap.startup.NotValidStartupXMLException;
import com.swimap.startup.StartupClassLoader;
import com.swimap.startup.StartupSplash;
import java.awt.SplashScreen;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class Startup {
    private static final String CLIENT_DIR = System.getProperty("user.dir");
    private static final String STYLE_LAUNCH_DIR = CLIENT_DIR + "/style/defaultstyle/launch/";
    private static final String CONF_LAUNCH_DIR = CLIENT_DIR + "/configuration/launch/";
    private static final String STARTUP_XML = "/startup.xml";
    private static final String SPLASH_IMAGE = System.getProperty("iview.splashImgPath", "launch.gif");
    private static boolean isSplashScreenShown = false;
    private static StartupSplash startupSplash = null;

    public static void main(String[] stringArray) {
        StartupClassLoader startupClassLoader = new StartupClassLoader(Startup.class.getClassLoader(), false);
        try {
            File[] fileArray;
            Object object;
            Object object2;
            Thread.currentThread().setContextClassLoader(startupClassLoader);
            Startup.showSplashScreen();
            String string = System.getProperty("subsystem");
            if (null != string) {
                startupClassLoader.initializeURLAndPath(true);
            } else {
                object2 = new File(CLIENT_DIR + STARTUP_XML);
                object = new File(System.getProperty("user.dir"));
                fileArray = ((File)object).listFiles(new StartupClassLoader.StartupFileFilter(startupClassLoader));
                if (!((File)object2).exists() && fileArray.length == 0) {
                    startupClassLoader.initializeURLAndPath(true);
                } else {
                    startupClassLoader.initStartupXML((File)object2);
                }
            }
            System.setProperty("osgi.clean", "true");
            object2 = "com.swimap.iview.framework.Main";
            object = System.getProperty("mainClass");
            if (object != null && ((String)object).trim().length() > 0) {
                object2 = object;
            }
            fileArray = startupClassLoader.loadClass((String)object2);
            Class[] classArray = new Class[]{String[].class};
            Method method = fileArray.getMethod("main", classArray);
            method.invoke(null, new Object[]{stringArray});
        }
        catch (NotValidStartupXMLException notValidStartupXMLException) {
            Startup.createFileAndAddLog();
            throw new Error("Startup.xml is not valid");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFileAndAddLog() {
        File file = new File(CLIENT_DIR + "/Iview_Error_log.txt");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("Startup.xml or _startup.xml files are invalid in the client directory. Client path is " + CLIENT_DIR);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (null != bufferedWriter) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (null != fileWriter) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static StartupSplash getStartupSplash() {
        return startupSplash;
    }

    public static boolean isSplashScreenShown() {
        return isSplashScreenShown;
    }

    private static void showSplashScreen() {
        ImageIcon imageIcon = null;
        String string = "";
        String string2 = System.getProperty("splashImgPath");
        if (null != string2 && null == SplashScreen.getSplashScreen()) {
            string2 = string2.trim();
            imageIcon = new ImageIcon(string2);
        } else if (null == SplashScreen.getSplashScreen()) {
            string = CONF_LAUNCH_DIR + SPLASH_IMAGE;
            File file = new File(string);
            if (file.exists()) {
                imageIcon = new ImageIcon(string);
            } else {
                Properties properties = Startup.getProperties("locale.properties");
                String string3 = "";
                if (null != properties) {
                    string3 = properties.getProperty("language");
                    Locale locale = null;
                    if (string3.contains("_") && string3.split("_").length == 2) {
                        String[] stringArray = string3.split("_");
                        stringArray[0] = stringArray[0].toLowerCase();
                        stringArray[1] = stringArray[1].toUpperCase();
                        locale = new Locale(stringArray[0], stringArray[1]);
                    } else {
                        locale = Locale.getDefault();
                    }
                    string = STYLE_LAUNCH_DIR + locale.getLanguage() + "_" + locale.getCountry() + "/" + SPLASH_IMAGE;
                    imageIcon = new ImageIcon(string);
                }
            }
        }
        if (null != imageIcon && imageIcon.getImageLoadStatus() == 8 && imageIcon.getIconHeight() > -1 && imageIcon.getIconWidth() > -1) {
            Startup.createAndshowSplash(imageIcon);
            isSplashScreenShown = true;
        }
    }

    private static void createAndshowSplash(final ImageIcon imageIcon) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Startup.startupSplash = new StartupSplash(imageIcon);
            }
        });
    }

    public static void closeStartupSplashScreen() {
        if (null != startupSplash) {
            startupSplash.close();
            startupSplash = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(String string) {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        Properties properties = new Properties();
        String string2 = CLIENT_DIR + "/" + string;
        try {
            fileInputStream = new FileInputStream(string2);
            if (null == fileInputStream) {
                Properties properties2 = properties;
                return properties2;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            String string3 = System.getProperty("file.encoding", "UTF-8");
            inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string3);
            properties.load(inputStreamReader);
        }
        catch (IOException iOException) {
            properties = null;
        }
        finally {
            try {
                if (null != fileInputStream) {
                    ((InputStream)fileInputStream).close();
                }
                if (null != inputStreamReader) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return properties;
    }
}

