/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.startup;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

final class PatchInfo
implements Comparable {
    private static final String PATCH_TIME = "Patch-Time";
    private static final int NEGATIVE = -1;
    private static final int POSITIVE = 1;
    private Date patchTime = null;
    private File file;

    private PatchInfo(String string, File file) {
        this.parsePatchTime(string);
        this.file = file;
    }

    public int compareTo(Object object) {
        if (null == object) {
            return 1;
        }
        PatchInfo patchInfo = (PatchInfo)object;
        if (null != this.patchTime && null != patchInfo.patchTime) {
            return this.patchTime.compareTo(patchInfo.patchTime);
        }
        if (null == patchInfo.patchTime) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        int n = this.compareTo(object);
        return 0 == n;
    }

    public int hashCode() {
        if (null == this.patchTime) {
            return super.hashCode();
        }
        return this.patchTime.hashCode();
    }

    private void parsePatchTime(String string) {
        if ((string = string.trim()).indexOf(58) != -1) {
            try {
                string = string.replace(' ', ',');
                string = string.replace(':', ',');
                string = string.replace('-', ',');
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int[] nArray = new int[6];
                int n = 0;
                while (stringTokenizer.hasMoreTokens() && n < 6) {
                    String string2 = stringTokenizer.nextToken();
                    Integer n2 = new Integer(string2);
                    nArray[n++] = n2;
                }
                this.patchTime = new Date(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                int[] nArray = new int[3];
                int n = 0;
                while (stringTokenizer.hasMoreTokens() && n < 3) {
                    String string3 = stringTokenizer.nextToken();
                    Integer n3 = new Integer(string3);
                    nArray[n++] = n3;
                }
                this.patchTime = new Date(nArray[0], nArray[1] - 1, nArray[2]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    URL getURL() {
        URL uRL = null;
        try {
            uRL = this.file.toURL();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return uRL;
    }

    static PatchInfo createPatchInfo(JarFile jarFile, File file) {
        String string;
        Attributes attributes;
        Manifest manifest = null;
        try {
            manifest = jarFile.getManifest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null && null != (string = attributes.getValue(PATCH_TIME)) && string.trim().length() > 0) {
            PatchInfo patchInfo = new PatchInfo(string, file);
            return patchInfo;
        }
        return null;
    }
}

