/*
 * Decompiled with CFR 0.152.
 */
package com.oem.iview.startup;

import com.oem.iview.startup.ResUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.GregorianCalendar;

class StartUpDebugTracer {
    private static final GregorianCalendar gregorianCalendar = new GregorianCalendar();
    protected static PrintWriter osWriter = new PrintWriter(System.out, true);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final String DEFAULT_TRACE_FILE_DIR = "tracefile";
    private static StringWriter strWriter = new StringWriter();
    private static PrintWriter printWriter = new PrintWriter(strWriter);

    StartUpDebugTracer() {
    }

    static synchronized void setOutputFileName(String string) {
        int n;
        String string2 = null;
        String string3 = null;
        File file = ResUtil.getAbsoluteFile(DEFAULT_TRACE_FILE_DIR);
        if (!file.exists()) {
            file.mkdir();
        }
        if ((n = (string3 = file.isDirectory() ? DEFAULT_TRACE_FILE_DIR + File.separator + string : string).lastIndexOf(".")) != -1) {
            string2 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        String string4 = StartUpDebugTracer.createTimeString(new GregorianCalendar());
        string3 = string3 + "_" + string4;
        string3 = string2 == null ? string3 : string3 + "." + string2;
        try {
            osWriter = new PrintWriter(new FileOutputStream(ResUtil.getAbsolutePath(string3)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static synchronized void trace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        StartUpDebugTracer.constructPrefix(stringBuffer);
        stringBuffer.append(" | ");
        stringBuffer.append(null == string ? " " : string);
        stringBuffer.append(" | ");
        stringBuffer.append(null == string2 ? " " : string2);
        stringBuffer.append(" | ");
        stringBuffer.append(null == string3 ? " " : string3);
        stringBuffer.append(LINE_SEPARATOR);
        try {
            osWriter.write(stringBuffer.toString());
            osWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static synchronized StringBuffer constructPrefix(StringBuffer stringBuffer) {
        stringBuffer.append('[');
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append(']');
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        stringBuffer.append(gregorianCalendar.get(2) + 1);
        stringBuffer.append('-');
        stringBuffer.append(gregorianCalendar.get(5));
        stringBuffer.append('-');
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append(' ');
        stringBuffer.append(gregorianCalendar.get(11));
        stringBuffer.append(':');
        stringBuffer.append(gregorianCalendar.get(12));
        stringBuffer.append(':');
        stringBuffer.append(gregorianCalendar.get(13));
        return stringBuffer;
    }

    static void trace(String string) {
        StartUpDebugTracer.trace("", "", string);
    }

    static void trace(Throwable throwable) {
        if (throwable != null) {
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            StartUpDebugTracer.trace("Exception trace in DebugTracer " + throwable.toString());
            StartUpDebugTracer.trace(strWriter.toString());
            strWriter.getBuffer().setLength(0);
        }
    }

    static void trace(Exception exception) {
        StartUpDebugTracer.trace((Throwable)exception);
    }

    private static String toTimeString(GregorianCalendar gregorianCalendar) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        n = gregorianCalendar.get(10);
        if (gregorianCalendar.get(9) == 1) {
            n += 12;
        }
        n2 = gregorianCalendar.get(12);
        n3 = gregorianCalendar.get(13);
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        stringBuffer.append("#");
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        stringBuffer.append("#");
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        return stringBuffer.toString();
    }

    private static String createTimeString(GregorianCalendar gregorianCalendar) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append("-");
        stringBuffer.append(gregorianCalendar.get(2) + 1);
        stringBuffer.append("-");
        stringBuffer.append(gregorianCalendar.get(5));
        stringBuffer.append("_");
        stringBuffer.append(StartUpDebugTracer.toTimeString(gregorianCalendar));
        return stringBuffer.toString();
    }

    static synchronized void cleanup() {
        if (osWriter != null) {
            osWriter.flush();
            osWriter.close();
        }
    }
}

