/*
 * Decompiled with CFR 0.152.
 */
package com.oem.iview.startup;

import com.oem.iview.startup.StartUpDebugTracer;
import com.oem.iview.startup.UnicodeInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

class ResUtil {
    private static ResUtil instance = null;
    private static String LOCALE_PROPERTIES = "locale.properties";
    private String language = "en";
    private String country = "US";
    private static final String DEFAULT_STYLE_DIR = "style/defaultstyle/";
    private static final String LOCALE_DIR = "style/defaultstyle/locale/";
    private String resourceDir = "style/defaultstyle/locale/en_US/";
    private static final Locale DEFAULT_LOCALE = new Locale("en", "US");
    private static String fileEncoding = "";
    private Locale currentLocale = null;

    private ResUtil() {
        this.readLocaleConfiguration();
    }

    static synchronized ResUtil getInstance() {
        if (null == instance) {
            instance = new ResUtil();
        }
        return instance;
    }

    static File getAbsoluteFile(String string) {
        File file = new File(string);
        return file.getAbsoluteFile();
    }

    static String getAbsolutePath(String string) {
        File file = new File(string);
        return file.getAbsolutePath();
    }

    private static String[] manageLanguageMacro(String string) {
        String[] stringArray = new String[]{"", ""};
        String string2 = "@{INSLANGUAGE}";
        if (null == string || string2.equals(string)) {
            return stringArray;
        }
        if (string.contains("_") && string.split("_").length == 2) {
            stringArray = string.split("_");
            stringArray[0] = stringArray[0].toLowerCase();
            stringArray[1] = stringArray[1].toUpperCase();
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    private void readLocaleConfiguration() {
        var1_1 = new String[]{"manual_configure_locale_allowed", "language"};
        var2_2 = System.getProperty("user.region");
        if (var2_2 == null) {
            var2_2 = System.getProperty("user.country");
        }
        var3_3 = new String[]{"false", System.getProperty("user.language"), var2_2};
        var4_4 = ResUtil.getProperty(ResUtil.LOCALE_PROPERTIES, var1_1, var3_3);
        for (var5_5 = 0; var5_5 < var4_4.length; ++var5_5) {
            if (var4_4[var5_5] == null) continue;
            var4_4[var5_5] = var4_4[var5_5].trim();
        }
        var5_5 = var4_4[0].equalsIgnoreCase("true") != false ? 1 : 0;
        var6_6 = ResUtil.DEFAULT_LOCALE.getLanguage();
        var7_7 = ResUtil.DEFAULT_LOCALE.getCountry();
        var8_8 = ResUtil.manageLanguageMacro(var4_4[1]);
        if (var5_5 == 0) ** GOTO lbl-1000
        if (ResUtil.isValidLocale(new Locale(var8_8[0], var8_8[1]))) {
            var6_6 = var8_8[0];
            var7_7 = var8_8[1];
        } else if (System.getProperty("locale.language") != null && System.getProperty("locale.region") != null) {
            var6_6 = System.getProperty("locale.language");
            var7_7 = System.getProperty("locale.region");
        } else if (System.getProperty("user.language") != null && var2_2 != null) {
            var6_6 = System.getProperty("user.language");
            var7_7 = var2_2;
        }
        var9_9 = new Locale(var6_6, var7_7);
        this.currentLocale = ResUtil.isValidLocale(var9_9) != false ? var9_9 : ResUtil.DEFAULT_LOCALE;
        this.language = this.currentLocale.getLanguage();
        this.country = this.currentLocale.getCountry();
        Locale.setDefault(this.currentLocale);
        this.resourceDir = "style/defaultstyle/locale/" + this.language + '_' + this.country + '/';
    }

    private static boolean isValidLocale(Locale locale) {
        String string = locale.getCountry();
        String string2 = locale.getLanguage();
        boolean bl = false;
        Locale[] localeArray = Locale.getAvailableLocales();
        if (null == localeArray) {
            return bl;
        }
        for (Locale locale2 : localeArray) {
            String string3 = locale2.getCountry();
            String string4 = locale2.getLanguage();
            if (!string.equals(string3) || !string2.equals(string4)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static String[] getProperty(String string, String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        String[] stringArray3 = new String[n];
        Properties properties = ResUtil.getProperties(string);
        if (properties == null) {
            return stringArray3;
        }
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = properties.getProperty(stringArray[i], stringArray2[i]);
        }
        return stringArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getProperties(String string) {
        InputStream inputStream = null;
        Properties properties = null;
        InputStreamReader inputStreamReader = null;
        properties = new Properties();
        try {
            URL uRL = ResUtil.getURLFromJar(string);
            inputStream = null != uRL ? uRL.openStream() : new FileInputStream(ResUtil.getAbsolutePath(string));
            UnicodeInputStream unicodeInputStream = new UnicodeInputStream(inputStream, null);
            String string2 = unicodeInputStream.getEncoding();
            if (null == string2) {
                fileEncoding = System.getProperty("file.encoding");
                inputStreamReader = new InputStreamReader((InputStream)unicodeInputStream, fileEncoding);
            } else {
                inputStreamReader = new InputStreamReader((InputStream)unicodeInputStream, string2);
            }
            properties.load(inputStreamReader);
        }
        catch (Exception exception) {
            StartUpDebugTracer.trace("Get property failed.");
            StartUpDebugTracer.trace(exception);
            properties = null;
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                StartUpDebugTracer.trace("stream can not be closed.");
                StartUpDebugTracer.trace(exception);
            }
        }
        return properties;
    }

    static URL getURLFromJar(String string) {
        URL uRL = null;
        ClassLoader classLoader = ResUtil.class.getClassLoader();
        if (null != classLoader) {
            uRL = classLoader.getResource(string);
        }
        return uRL;
    }

    ResourceBundle getResourceBundleFromPropertyFile(String string) {
        Properties properties = null;
        String string2 = this.resourceDir + string + ".properties";
        File file = ResUtil.getAbsoluteFile(string2);
        if (file.exists() || null != ResUtil.getURLFromJar(string2)) {
            properties = ResUtil.getProperties(string2);
        } else {
            StartUpDebugTracer.trace("Resource file not found:" + string2);
        }
        if (properties != null) {
            PropertyResourceBundleEx propertyResourceBundleEx = new PropertyResourceBundleEx(properties);
            return propertyResourceBundleEx;
        }
        return null;
    }

    class ResourceBundleEnumerationEx
    implements Enumeration {
        Set set;
        Iterator iterator;
        Enumeration enumeration;
        Object next = null;

        public ResourceBundleEnumerationEx(Set set, Enumeration enumeration) {
            this.set = set;
            this.iterator = set.iterator();
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next == null) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                } else if (this.enumeration != null) {
                    while (this.next == null && this.enumeration.hasMoreElements()) {
                        this.next = this.enumeration.nextElement();
                        if (!this.set.contains(this.next)) continue;
                        this.next = null;
                    }
                }
            }
            return this.next != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                Object object = this.next;
                this.next = null;
                return object;
            }
            throw new NoSuchElementException();
        }
    }

    class PropertyResourceBundleEx
    extends ResourceBundle {
        private Map lookup;

        public PropertyResourceBundleEx(Properties properties) {
            this.lookup = new HashMap<Object, Object>(properties);
        }

        @Override
        public Object handleGetObject(String string) {
            if (string == null) {
                throw new IllegalArgumentException("key == null.");
            }
            String string2 = null;
            try {
                if (fileEncoding.equals("")) {
                    fileEncoding = System.getProperty("file.encoding");
                }
                string2 = new String(((String)this.lookup.get(string)).getBytes(fileEncoding));
            }
            catch (Exception exception) {
                StartUpDebugTracer.trace("PropertyResourceBundleEx-handleGetObject,failed to get value of key:" + string);
                StartUpDebugTracer.trace(exception);
                string2 = (String)this.lookup.get(string);
            }
            if (string2 == null) {
                return string;
            }
            return string2;
        }

        public Enumeration getKeys() {
            ResourceBundle resourceBundle = this.parent;
            return new ResourceBundleEnumerationEx(this.lookup.keySet(), resourceBundle != null ? resourceBundle.getKeys() : null);
        }
    }
}

