/*
 * Decompiled with CFR 0.152.
 */
package com.oem.iview.startup;

import com.oem.iview.startup.StartUpDebugTracer;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

final class PatchInfo
implements Comparable {
    private static final String PATCH_TIME = "Patch-Time";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int NEGATIVE = -1;
    private static final int POSITIVE = 1;
    private Date patchTime = null;
    private File file;
    private SimpleDateFormat dateFormat = null;
    private SimpleDateFormat timeFormat = null;

    private PatchInfo(String string, File file) {
        this.parsePatchTime(string);
        this.file = file;
    }

    public int compareTo(Object object) {
        if (null == object) {
            return 1;
        }
        PatchInfo patchInfo = (PatchInfo)object;
        if (null != this.patchTime && null != patchInfo.patchTime) {
            return this.patchTime.compareTo(patchInfo.patchTime);
        }
        if (null == patchInfo.patchTime) {
            return 1;
        }
        return -1;
    }

    private void parsePatchTime(String string) {
        if (string.indexOf(58) != -1) {
            if (null == this.timeFormat) {
                this.timeFormat = new SimpleDateFormat(TIME_FORMAT, Locale.getDefault());
            }
            try {
                this.patchTime = this.timeFormat.parse(string);
            }
            catch (Exception exception) {
                StartUpDebugTracer.trace(exception);
            }
        } else {
            if (this.dateFormat == null) {
                this.dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
            }
            try {
                this.patchTime = this.dateFormat.parse(string);
            }
            catch (Exception exception) {
                StartUpDebugTracer.trace(exception);
            }
        }
    }

    URL getURL() {
        URL uRL = null;
        try {
            uRL = this.file.toURL();
        }
        catch (Exception exception) {
            StartUpDebugTracer.trace(exception);
        }
        return uRL;
    }

    static PatchInfo createPatchInfo(JarFile jarFile, File file) {
        String string;
        Attributes attributes;
        Manifest manifest = null;
        try {
            manifest = jarFile.getManifest();
        }
        catch (Exception exception) {
            StartUpDebugTracer.trace(exception);
        }
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null && null != (string = attributes.getValue(PATCH_TIME)) && string.trim().length() > 0) {
            PatchInfo patchInfo = new PatchInfo(string, file);
            return patchInfo;
        }
        return null;
    }
}

