/*
 * Decompiled with CFR 0.152.
 */
package com.oem.iview.startup;

import com.oem.iview.startup.PatchInfo;
import com.oem.iview.startup.ResUtil;
import com.oem.iview.startup.StartUpDebugTracer;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class Bootstrap {
    private static final String TRACEFILENAME = "startuplog.txt";
    private static final String CONFIG_PROPERTIES = "config.properties";
    private static final String PATCH_DIR = "boot_patch_dir";
    private static final String CLASS_PATH = "boot_classpath";
    private static final String MAIN_CLASS = "boot_mainclass";
    private static final String HELP_CLASSPATH = "boot_helpclasspath";
    private static final String JAR_FLG = "*.jar";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static final String FILE_SEPERATOR = System.getProperty("file.separator");
    private static final int INITIAL_ARRAY_CAPACITY = 10;
    private static Bootstrap instance = null;
    private ClassLoader clientLoader = null;
    private String bootPatchDir = "";
    private String bootClassPath = "";
    private String bootMainClass = "";
    private String bootHelpClassPath = "";
    private ResourceBundle res = null;
    private JFrame parentFrame = null;
    private FileFilter jarFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().toLowerCase().endsWith(Bootstrap.JAR_FILE_SUFFIX);
        }
    };

    private Bootstrap() {
    }

    public static final synchronized Bootstrap getInstance() {
        if (null == instance) {
            instance = new Bootstrap();
        }
        return instance;
    }

    public void setMainFrame(JFrame jFrame) {
        this.parentFrame = jFrame;
    }

    public ClassLoader getClientClassLoader() {
        return this.clientLoader;
    }

    public String getHelpClassPath() {
        return this.bootHelpClassPath;
    }

    private void init(String[] stringArray) {
        Object object;
        StartUpDebugTracer.setOutputFileName(TRACEFILENAME);
        boolean bl = this.initResource();
        if (!bl) {
            StartUpDebugTracer.trace("Bootstrap", "init()", "Resouce init failed.");
            object = "Failed to obtain the resource file. The system will exit. Please ensure that the resource file is correct and try again.";
            JOptionPane.showMessageDialog(null, object, "Error", 0);
            StartUpDebugTracer.cleanup();
            System.exit(-1);
        }
        this.readConfigInfo(CONFIG_PROPERTIES);
        this.clientLoader = this.createClientLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.clientLoader);
            object = this.clientLoader.loadClass(this.bootMainClass);
            Method method = ((Class)object).getDeclaredMethod("main", String[].class);
            StartUpDebugTracer.trace("Bootstrap", "init", "Invokde main class's method");
            method.invoke(object, new Object[]{stringArray});
        }
        catch (Exception exception) {
            StartUpDebugTracer.trace("Bootstrap", "init", "bootMainClass =" + this.bootMainClass);
            StartUpDebugTracer.trace(exception);
            JOptionPane.showMessageDialog(this.parentFrame, this.res.getString("Bootstrap_Startup_Failed"), this.res.getString("Error"), 0);
            StartUpDebugTracer.cleanup();
            System.exit(-1);
        }
        StartUpDebugTracer.cleanup();
    }

    private boolean initResource() {
        this.res = ResUtil.getInstance().getResourceBundleFromPropertyFile("mainfrm/startup/Res");
        return null != this.res;
    }

    private void readConfigInfo(String string) {
        Properties properties = ResUtil.getProperties(string);
        if (null != properties) {
            this.bootPatchDir = properties.getProperty(PATCH_DIR);
            this.bootClassPath = properties.getProperty(CLASS_PATH);
            this.bootMainClass = properties.getProperty(MAIN_CLASS);
            this.bootHelpClassPath = properties.getProperty(HELP_CLASSPATH);
        }
    }

    private ClassLoader createClientLoader() {
        URL[] uRLArray = this.searchPatchLib(this.bootPatchDir);
        URL[] uRLArray2 = this.searchClassLib(this.bootClassPath);
        URL[] uRLArray3 = new URL[uRLArray.length + uRLArray2.length];
        System.arraycopy(uRLArray, 0, uRLArray3, 0, uRLArray.length);
        System.arraycopy(uRLArray2, 0, uRLArray3, uRLArray.length, uRLArray2.length);
        for (int i = 0; i < uRLArray3.length; ++i) {
            StartUpDebugTracer.trace("Bootstrap", "createClientLoader", "Include URL :" + uRLArray3[i].toString());
        }
        URLClassLoader uRLClassLoader = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        uRLClassLoader = null == classLoader ? new URLClassLoader(uRLArray3) : new URLClassLoader(uRLArray3, classLoader);
        return uRLClassLoader;
    }

    private URL[] searchClassLib(String string) {
        String[] stringArray = this.getFileNames(string);
        ArrayList<URL> arrayList = new ArrayList<URL>(10);
        URL uRL = null;
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                file = ResUtil.getAbsoluteFile(stringArray[i]);
                if (file.exists()) {
                    uRL = file.toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                StartUpDebugTracer.trace(malformedURLException);
            }
            if (uRL != null) {
                if (!arrayList.contains(uRL)) {
                    arrayList.add(uRL);
                }
            } else {
                StartUpDebugTracer.trace("Bootstrap", "searchClassLib", "Failed to get URL ,filename =" + stringArray[i]);
            }
            uRL = null;
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private URL[] searchPatchLib(String string) {
        String[] stringArray = this.getFileNames(string);
        ArrayList<File> arrayList = new ArrayList<File>(10);
        ArrayList<PatchInfo> arrayList2 = new ArrayList<PatchInfo>(10);
        ArrayList<URL> arrayList3 = new ArrayList<URL>(10);
        File file = null;
        JarFile jarFile = null;
        PatchInfo patchInfo = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().endsWith(JAR_FILE_SUFFIX) || !(file = ResUtil.getAbsoluteFile(stringArray[i])).isFile()) continue;
            try {
                jarFile = new JarFile(file);
            }
            catch (Exception exception) {
                StartUpDebugTracer.trace("Bootstrap", "searchPatchLib", "Failed to create JarFile. filename=" + file.getName());
                StartUpDebugTracer.trace(exception);
                jarFile = null;
                continue;
            }
            patchInfo = PatchInfo.createPatchInfo(jarFile, file);
            if (null != jarFile) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    StartUpDebugTracer.trace(iOException);
                }
            }
            if (null != patchInfo) {
                arrayList2.add(patchInfo);
                continue;
            }
            arrayList.add(file);
        }
        Collections.sort(arrayList2);
        PatchInfo[] patchInfoArray = arrayList2.toArray(new PatchInfo[arrayList2.size()]);
        URL uRL = null;
        for (int i = patchInfoArray.length - 1; i >= 0; --i) {
            uRL = patchInfoArray[i].getURL();
            if (null == uRL || arrayList3.contains(uRL)) continue;
            arrayList3.add(uRL);
        }
        File[] fileArray = arrayList.toArray(new File[arrayList.size()]);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                uRL = fileArray[i].toURL();
            }
            catch (Exception exception) {
                StartUpDebugTracer.trace(exception);
            }
            if (null == uRL || arrayList3.contains(uRL)) continue;
            arrayList3.add(uRL);
        }
        return arrayList3.toArray(new URL[arrayList3.size()]);
    }

    private String[] getFileNames(String string) {
        ArrayList arrayList = new ArrayList(10);
        if (null == string || string.trim().equals("")) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            if (string2.indexOf("**") >= 0) {
                this.getAllFileNames(string2, arrayList);
            }
            this.addToClasspathList(string2, arrayList);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void addToClasspathList(String string, ArrayList arrayList) {
        if (string.toLowerCase().endsWith(JAR_FLG)) {
            String string2 = string.substring(0, string.length() - JAR_FLG.length());
            File file = ResUtil.getAbsoluteFile(string2);
            File[] fileArray = file.listFiles(this.jarFileFilter);
            if (null == fileArray) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(fileArray[i].getPath());
            }
        } else {
            arrayList.add(string);
        }
    }

    private void getAllFileNames(String string, ArrayList arrayList) {
        String string2 = string.substring(0, string.indexOf("**"));
        boolean bl = string.endsWith(JAR_FLG);
        ArrayList arrayList2 = new ArrayList(10);
        this.getAllSubFolders(string2, arrayList2);
        String string3 = null;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            string3 = (String)arrayList2.get(i);
            this.addToClasspathList(string3, arrayList);
            if (!bl) continue;
            this.addToClasspathList(string3 + JAR_FLG, arrayList);
        }
    }

    private void getAllSubFolders(String string, ArrayList arrayList) {
        arrayList.add(string);
        File file = new File(string);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(string + fileArray[i].getName());
            this.getAllSubFolders(string + fileArray[i].getName() + FILE_SEPERATOR, arrayList);
        }
    }

    public static void main(String[] stringArray) {
        Bootstrap.getInstance().init(stringArray);
    }
}

