/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.util;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.external.sm.client.mgr.common.SubRes;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.cache.AccBit;
import com.swimap.imap.security.checkright.cache.Right;
import com.swimap.imap.security.checkright.cache.SetRight;
import com.swimap.imap.security.checkright.cache.StaticRight;
import com.swimap.imap.security.checkright.cache.StaticRightRelation;
import com.swimap.imap.security.checkright.cache.SubnetIDnDNStruct;
import com.swimap.imap.security.checkright.cache.TypeRight;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RpcInvoker {
    private static IviewLogger log = TraceProxy.getLogger(RpcInvoker.class);
    private static RpcInvoker instance = new RpcInvoker();
    private long timeStamp;
    private RpcRequest rpcRequest;
    public static final int USERGROUP_AND_SUBRES_RELATION_HANDLER = 16;
    private static String ALL_OBJECT_SET_KEY = "allObjectSet_id";
    private static String ALL_DOMAIN_SET_KEY = "allDomainDevSet_id";
    private static String ALL_OBJECT_OPR_SET_KEY = "allObjectOprSet_id";
    private static String ALL_APP_OPR_SET_KEY = "allAppOprSet_id";

    public static RpcInvoker getInstance() {
        return instance;
    }

    public void setRpcRequest(RpcRequest _rpcRequest) {
        this.rpcRequest = _rpcRequest;
    }

    private RpcRequest getRpcRequest(String reqestCommand) throws Exception {
        if (this.rpcRequest == null) {
            return RpcNaming.createRequest((String)reqestCommand);
        }
        return this.rpcRequest;
    }

    public Map<String, StaticRight> getStaticRight() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getStaticRight |start");
        RpcRequest req = this.getRpcRequest("sm.ds.base.checkrightm.getStaticRight");
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        HashMap<String, StaticRight> staticRightMap = new HashMap<String, StaticRight>();
        DataTable staticRightTable = msg.getTable("staticRight");
        log.info((Object)("RpcInvoker | getStaticRight |mid " + (System.currentTimeMillis() - t)));
        for (DataRecord record : staticRightTable) {
            StaticRight staticRight = new StaticRight(record.getInt("type"), record.get("classname"), record.get("operationid"), "", "", record.getInt("accbit"));
            staticRightMap.put(staticRight.type + staticRight.className + staticRight.operationID, staticRight);
        }
        log.info((Object)("RpcInvoker | getStaticRight |end " + (System.currentTimeMillis() - t)));
        return staticRightMap;
    }

    public List<Map<String, Right>> getAllMOAndAppRightByUserID(int userID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getAllMOAndAppRightByUserID |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getAllMOAndAppRightByUserID");
        req.addArgument("userid", (Object)userID);
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        ArrayList<Map<String, Right>> userAllAppAccessMap = new ArrayList<Map<String, Right>>();
        HashMap<String, Right> userAppAccessMap = new HashMap<String, Right>();
        DataTable userAppAccessTable = msg.getTable("userMOAndAppRight");
        for (DataRecord record : userAppAccessTable) {
            if (record.getInt("type") == -1) {
                userAllAppAccessMap.add(userAppAccessMap);
                userAppAccessMap = new HashMap();
                continue;
            }
            DataTable accTable = record.getTable("accessbit");
            List<AccBit> list = AccBit.readTable(accTable);
            Right rightInfo = new Right(record.getInt("type"), record.get("classname"), record.get("oid"));
            rightInfo.accBitList = list;
            userAppAccessMap.put(rightInfo.so.getKey(), rightInfo);
        }
        log.info((Object)("RpcInvoker | getAllMOAndAppRightByUserID |end " + (System.currentTimeMillis() - t)));
        return userAllAppAccessMap;
    }

    public Map<String, Map<String, String>> getAllSOIDAndSubResOIDByUserID(int userID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getAllSOIDAndSubResOIDByUserID |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getAllSOIDAndSubResOIDByUserID");
        req.addArgument("userid", (Object)userID);
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        HashMap<String, Map<String, String>> soidAndSubResOIDListMap = new HashMap<String, Map<String, String>>();
        String[] soidArray = msg.getStringArray("soidArray");
        String[] phySubResOIDArray = msg.getStringArray("phySubResOIDArray");
        HashMap<String, String> soidMap = new HashMap<String, String>();
        for (String soid : soidArray) {
            soidMap.put(soid, soid);
        }
        soidAndSubResOIDListMap.put("soidMap", soidMap);
        HashMap<String, String> phySubResOIDMap = new HashMap<String, String>();
        for (String subResOID : phySubResOIDArray) {
            if (subResOID.indexOf("-1") >= 0) {
                phySubResOIDMap.put(subResOID.substring(3), "-1");
                continue;
            }
            phySubResOIDMap.put(subResOID, subResOID);
        }
        soidAndSubResOIDListMap.put("phySubResOIDMap", phySubResOIDMap);
        log.info((Object)("RpcInvoker | getAllSOIDAndSubResOIDByUserID |end " + (System.currentTimeMillis() - t)));
        return soidAndSubResOIDListMap;
    }

    public int getUserPriGroupID(String userName) {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sm.ds.usermgr.getUserID");
            req.addArgument("username", (Object)userName);
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            int userID = msg.getInt("userid");
            req = RpcNaming.createRequest((String)"sm.ds.usermgr.getPrivateGroupID");
            req.addArgument("userID", (Object)userID);
            rsp = req.invoke();
            msg = rsp.getMessage();
            return msg.getInt("privategroupid");
        }
        catch (Exception e) {
            log.trace((Object)("The user of " + userName + " is not exist!"));
            return -1;
        }
    }

    public String getUserNameByID(int userID) {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sm.ds.usermgr.getUserInfo");
            req.addArgument("userId", (Object)userID);
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            DataTable table = msg.getTable("UserInfo");
            UserInfo userInfo = new UserInfo();
            table.get(0).copyTo((Object)userInfo);
            return userInfo.getName();
        }
        catch (Exception e) {
            log.trace((Object)("The user of " + userID + " is not exist!"));
            return null;
        }
    }

    public String getCmdName(int cmdCode) {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sm.ds.msgadp.utilservice.getCmdName");
            req.addArgument("cmdcode", (Object)cmdCode);
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            return msg.getString("cmdName");
        }
        catch (Exception e) {
            log.trace((Object)("The cmdCode of " + cmdCode + " is not exist!"));
            return null;
        }
    }

    public String getCmdNameEx(int iMainType, int iSubType, int cmdCode) {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sm.ds.msgadp.utilservice.getCmdNameEx");
            req.addArgument("maintype", (Object)iMainType);
            req.addArgument("subtype", (Object)iSubType);
            req.addArgument("cmdcode", (Object)cmdCode);
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            return msg.getString("cmdName");
        }
        catch (Exception e) {
            log.trace((Object)("The cmdCode of " + cmdCode + " is not exist!"));
            return null;
        }
    }

    public Object[] getAllRightOperatorTable() {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sm.ds.msgadp.utilservice.getAllOperatorTable");
            req.addArgument("timeStamp", (Object)this.timeStamp);
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            long ts = msg.getLong("timeStamp");
            if (ts == -1L) {
                return null;
            }
            this.timeStamp = ts;
            HashMap<Integer, ArrayList<int[]>> operatorTable = new HashMap<Integer, ArrayList<int[]>>();
            HashMap<Integer, ArrayList<int[]>> unRightCheckOperatorTable = new HashMap<Integer, ArrayList<int[]>>();
            HashSet<Integer> adminRightCheckOperatorTable = new HashSet<Integer>();
            Object[] result = new Object[]{operatorTable, unRightCheckOperatorTable, adminRightCheckOperatorTable};
            this.fillMap(msg.getTable("noNeedCheckRights"), unRightCheckOperatorTable);
            this.fillMap(msg.getTable("commonRights"), operatorTable);
            this.fillSet(msg.getTable("adminRights"), adminRightCheckOperatorTable);
            return result;
        }
        catch (Exception e) {
            log.trace((Object)("get operator table failure!\n" + e));
            return null;
        }
    }

    private void fillMap(DataTable table, Map<Integer, ArrayList<int[]>> map) {
        if (table == null) {
            return;
        }
        for (DataRecord rec : table) {
            ArrayList<Object> tmpList = map.get(rec.getInt("CmdID"));
            if (tmpList == null) {
                tmpList = new ArrayList();
                map.put(rec.getInt("CmdID"), tmpList);
            }
            tmpList.add(new int[]{rec.getInt("ObjectTID"), rec.getInt("ObjectSubTID")});
        }
    }

    private void fillSet(DataTable table, Set<Integer> set) {
        if (table == null) {
            return;
        }
        for (DataRecord rec : table) {
            set.add(rec.getInt("CmdID"));
        }
    }

    public boolean hasAllResRight() {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sm.ds.msgadp.rightservice.hasAllResRight");
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            return msg.getBoolean("hasAllResRight");
        }
        catch (Exception e) {
            log.trace((Object)("hasAllResRight failure!\n" + e));
            return false;
        }
    }

    public int getSystemMode() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getSystemMode |start");
        RpcRequest req = this.getRpcRequest("sm.ds.base.sessionmgr.getSystemMode");
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        int result = msg.getInt("SystemMode");
        log.info((Object)("RpcInvoker | getSystemMode |end " + (System.currentTimeMillis() - t)));
        return result;
    }

    public LinkedList<UserInfo> getAllUserInfo() throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sm.ds.usermgr.getAllUserInfo");
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        DataTable userInfoTable = msg.getTable("UserInfo");
        LinkedList<UserInfo> userInfoList = new LinkedList<UserInfo>();
        GregorianCalendar startLoginDurationDate = null;
        GregorianCalendar endLoginDurationDate = null;
        GregorianCalendar startLoginDurationTime = null;
        GregorianCalendar endLoginDurationTime = null;
        for (DataRecord record : userInfoTable) {
            startLoginDurationDate = new GregorianCalendar(0, 0, 0, 0, 0, 0);
            endLoginDurationDate = new GregorianCalendar(2037, 11, 31, 0, 0, 0);
            startLoginDurationTime = new GregorianCalendar(0, 0, 0, 0, 0, 0);
            endLoginDurationTime = new GregorianCalendar(2037, 11, 31, 0, 0, 0);
            startLoginDurationDate.setTimeInMillis(record.getDate("startloginDurationDate").getTime());
            endLoginDurationDate.setTimeInMillis(record.getDate("endloginDurationDate").getTime());
            startLoginDurationTime.setTimeInMillis(record.getDate("startloginDurationTime").getTime());
            endLoginDurationTime.setTimeInMillis(record.getDate("endloginDurationTime").getTime());
            userInfoList.add(new UserInfo(record.getInt("id"), record.get("username"), record.get("desc"), record.getInt("userType"), record.getByteArray("password"), (Calendar)startLoginDurationDate, (Calendar)endLoginDurationDate, (Calendar)startLoginDurationTime, (Calendar)endLoginDurationTime, record.getIntArray("durationWeekDays"), record.getBoolean("accountValidFlag"), record.getBoolean("ignoreDurationFlag"), record.getBoolean("lockFlag"), record.getInt("pwdValidDays"), record.getBoolean("online"), record.getLong("loginTime"), record.getLong("logoutTime"), record.get("terminal"), record.getLong("pwdChangeDate"), (short)record.getInt("pwdStatus")));
        }
        return userInfoList;
    }

    public String[] getSubResGrantRecord(int groupId, String deviceOID) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sm.ds.msgadp.rightservice.getSubResGrantRecord");
        req.addArgument("groupid", (Object)groupId);
        req.addArgument("oid", (Object)deviceOID);
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        String[] subResGrantRecordArray = msg.getStringArray("subResGrantRecordArray");
        return subResGrantRecordArray;
    }

    public boolean copySubResGrantRecord(int id, int[] groupIds, boolean isCopyUserSubRes) throws Exception {
        log.info((Object)("Copy lower-level resource from groups: " + Arrays.toString(groupIds)));
        RpcRequest req = RpcNaming.createRequest((String)"sm.ds.sorelationservice.copySubResGrantRecord");
        req.addArgument("id", (Object)id);
        req.addArgument("groupIds", (Object)groupIds);
        req.addArgument("isCopyUserSubRes", (Object)isCopyUserSubRes);
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        boolean isSuccess = msg.getBoolean("isSuccess");
        return isSuccess;
    }

    public void allocateSubRes(int ID, String objectID, List<String> addSubResList, List<String> delSubResList, boolean isAllocateUserSubRes) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sm.ds.sorelationservice.setRelation");
        DataTable addTable = new DataTable("so", SubRes.class);
        for (String subResOID : addSubResList) {
            SubRes subRes = new SubRes(subResOID, "managed");
            subRes.subResType = 0;
            addTable.addObject((Object)subRes);
        }
        addTable.addParameter("ID", (Object)ID);
        addTable.addParameter("oid", (Object)objectID);
        addTable.addParameter("isAllocateUserSubRes", (Object)isAllocateUserSubRes);
        DataTable delTable = new DataTable("sos", SubRes.class);
        for (String subResOID : delSubResList) {
            SubRes subRes = new SubRes(subResOID, "managed");
            subRes.subResType = 0;
            delTable.addObject((Object)subRes);
        }
        req.addTable(addTable);
        req.addTable(delTable);
        req.addArgument("key", (Object)16);
        req.invoke();
    }

    public String getConfParamValue(String path) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sm.ds.msgadp.utilservice.getConfParamValue");
        req.addArgument("path", (Object)path);
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        return msg.getString(path);
    }

    public boolean hasAllAppOperationSetByUserID(int userID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | hasAllAppOperationSetByUserID |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.hasAllAppOperationSetByUserID");
        req.addArgument("userid", (Object)userID);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | hasAllAppOperationSetByUserID |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        return msg.getBoolean("hasAllOperationSetRight");
    }

    public SubnetIDnDNStruct getAllParentRecursionFrom(String oid) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getAllParentRecursionFrom |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getAllParentRecursionFrom");
        req.addArgument("oid", (Object)oid);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getAllParentRecursionFrom |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        int[] dnDeviceSetIDArray = msg.getIntArray("dnDeviceSetIDList");
        ArrayList<Integer> subDeviceSetList = new ArrayList<Integer>();
        for (int i = 0; i < dnDeviceSetIDArray.length; ++i) {
            subDeviceSetList.add(dnDeviceSetIDArray[i]);
        }
        SubnetIDnDNStruct struct = new SubnetIDnDNStruct();
        struct.oid = oid;
        struct.subnetDeviceSetIds = subDeviceSetList;
        struct.subnetDNs = msg.getStringArray("parentRecursionList");
        return struct;
    }

    public int getPrivateGroupID(int userID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getPrivateGroupID |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getPrivateGroupID");
        req.addArgument("userid", (Object)userID);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getPrivateGroupID |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        return msg.getInt("privategroupid");
    }

    public int[] getGroupIDs(int userID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getGroupIDs |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getGroupIDs");
        req.addArgument("userid", (Object)userID);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getGroupIDs |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        return msg.getIntArray("groupids");
    }

    private static Map<String, Right> convertToRightMap(DataTable rightsTable) {
        HashMap<String, Right> rightMap = new HashMap<String, Right>();
        DataTable rightTable = null;
        for (DataRecord record : rightsTable) {
            rightTable = record.getTable("right");
            if (null == rightTable) continue;
            Right right = RpcInvoker.convertToRight(rightTable);
            rightMap.put(right.so.getKey(), right);
        }
        return rightMap;
    }

    private static Right convertToRight(DataTable rightTable) {
        Right right = new Right(rightTable.getInt("type"), rightTable.getString("className"), rightTable.getString("oid"));
        right.accBitList = AccBit.readTable(rightTable);
        return right;
    }

    public Map<Integer, Map<String, Right>> getGroupRights(int[] groupIDs) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getGroupRights |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getGroupRights");
        req.addArgument("groupids", (Object)groupIDs);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getGroupRights |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        DataTable rightsTable = msg.getTable("GroupRight");
        return RpcInvoker.convertToGroupRightMap(rightsTable);
    }

    private static Map<Integer, Map<String, Right>> convertToGroupRightMap(DataTable rightsTable) {
        HashMap<Integer, Map<String, Right>> rightMap = new HashMap<Integer, Map<String, Right>>();
        for (DataRecord record : rightsTable) {
            Integer groupID = record.getInt("groupID");
            DataTable table = record.getTable("right");
            if (table == null) {
                rightMap.put(groupID, new HashMap());
                continue;
            }
            Right right = RpcInvoker.convertToRight(table);
            HashMap<String, Right> map = (HashMap<String, Right>)rightMap.get(groupID);
            if (map == null) {
                map = new HashMap<String, Right>();
                rightMap.put(groupID, map);
            }
            map.put(right.so.getKey(), right);
        }
        return rightMap;
    }

    public Map<String, Right> getAppRight(int groupID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getAppRight |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getAppRight");
        req.addArgument("groupid", (Object)groupID);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getAppRight |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        DataTable rightsTable = msg.getTable("AppRight");
        return RpcInvoker.convertToRightMap(rightsTable);
    }

    public StaticRightRelation[] getStaticRightRelation() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getStaticRightRelation |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getStaticRightRelation");
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getStaticRightRelation |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        DataTable staticRightRelationTable = msg.getTable("StaticRightRelation");
        StaticRightRelation[] staticRightRelationArray = new StaticRightRelation[staticRightRelationTable.size()];
        for (int i = 0; i < staticRightRelationArray.length; ++i) {
            DataRecord record = staticRightRelationTable.get(i);
            staticRightRelationArray[i] = new StaticRightRelation(record.getInt("srcid"), record.getInt("tarid"));
        }
        return staticRightRelationArray;
    }

    public Map<Integer, SetRight> getGroupSetRights(int[] groupIDs) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getGroupSetRights |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getGroupSetRights");
        req.addArgument("groupids", (Object)groupIDs);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getGroupSetRight |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        DataTable devSetOpeSetTable = msg.getTable("DevSetOpeSetIDMap");
        HashMap<Integer, SetRight> reuslt = new HashMap<Integer, SetRight>();
        int groupID = -1;
        int[] devSetIDs = null;
        int[] opeSetIDs = null;
        for (DataRecord record : devSetOpeSetTable) {
            groupID = record.getInt("GroupID");
            devSetIDs = record.getIntArray("devSetIDs");
            opeSetIDs = record.getIntArray("opeSetIDs");
            reuslt.put(groupID, new SetRight(devSetIDs, opeSetIDs));
        }
        return reuslt;
    }

    public List<String> getDevOIDsByDevSetID(int devSetID) throws Exception {
        ArrayList<String> oidList = new ArrayList<String>();
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getDevOIDsByDevSetID |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getDevOIDsByDevSetID");
        req.addArgument("devsetid", (Object)devSetID);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getDevOIDsByDevSetID |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        String[] oidArray = msg.getStringArray("oidArray");
        for (int i = 0; i < oidArray.length; ++i) {
            oidList.add(oidArray[i]);
        }
        return oidList;
    }

    public int[] getSubOpeSet(int opeSetID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getSubOpeSet |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getSubOpeSet");
        req.addArgument("opesetid", (Object)opeSetID);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getSubOpeSet |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        return msg.getIntArray("subOpgID");
    }

    public int[] getSubDevSet(int devSetID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getSubDevSet |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getSubDevSet");
        req.addArgument("devsetid", (Object)devSetID);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getSubDevSet |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        return msg.getIntArray("subSogID");
    }

    private Map<String, TypeRight> parseRightsFromTable(DataTable rightOfOprSetTable) {
        ConcurrentHashMap<String, TypeRight> rightMap = new ConcurrentHashMap<String, TypeRight>();
        if (rightOfOprSetTable != null && rightOfOprSetTable.size() > 0) {
            for (DataRecord record : rightOfOprSetTable) {
                int classType = record.getInt("type");
                String className = record.get("classname");
                int accBitSite = record.getInt("accbit");
                TypeRight typeRight = (TypeRight)rightMap.get(className);
                if (typeRight == null) {
                    typeRight = new TypeRight(classType, className);
                    rightMap.put(className, typeRight);
                }
                typeRight.addRight(accBitSite);
            }
        }
        return rightMap;
    }

    public Map<Integer, Map<String, List<String>>> getTypeAccByGroups(int[] groupIDs) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getTypeAccByGroups |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getTypeAccByGroups");
        req.addArgument("groupids", (Object)groupIDs);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getTypeAccByGroups |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        HashMap<Integer, Map<String, List<String>>> allData = new HashMap<Integer, Map<String, List<String>>>();
        DataTable allDataTable = msg.getTable("alldata");
        HashSet<Integer> noRightGroupIds = new HashSet<Integer>();
        for (int id : groupIDs) {
            noRightGroupIds.add(id);
        }
        for (DataRecord rec : allDataTable) {
            int groupId = rec.getInt("groupid");
            DataTable typeAccTable = rec.getTable("typeaccTable");
            HashMap typeAccMap = new HashMap();
            if (typeAccTable != null) {
                for (DataRecord reocrd : typeAccTable) {
                    String[] accArray = reocrd.getStringArray("AccessNames");
                    ArrayList<String> accList = new ArrayList<String>();
                    if (accArray != null) {
                        for (int i = 0; i < accArray.length; ++i) {
                            accList.add(accArray[i]);
                        }
                    } else {
                        log.info((Object)"com.swimap.external.dsf.base.rpc.DataRecord.getStringArray(...) return null ");
                    }
                    typeAccMap.put(reocrd.get("SOClassName"), accList);
                }
            } else {
                log.info((Object)"com.swimap.external.dsf.base.rpc.DataRecord.getTable(...) return null ");
            }
            allData.put(groupId, typeAccMap);
            noRightGroupIds.remove(groupId);
        }
        if (noRightGroupIds.size() > 0) {
            Iterator i$ = noRightGroupIds.iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                allData.put(id, new HashMap());
            }
        }
        return allData;
    }

    public Map<Integer, List<String>> getSubnetDNListByGroups(int[] groupIDs) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getSubnetDNListByGroups |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getSubnetDNListByGroups");
        req.addArgument("groupids", (Object)groupIDs);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getSubnetDNListByGroups |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        HashMap<Integer, List<String>> groupSubnetDNsMap = new HashMap<Integer, List<String>>();
        DataTable typeAccTable = msg.getTable("groupSubnetDNMap");
        for (DataRecord reocrd : typeAccTable) {
            String[] accArray = reocrd.getStringArray("SubnetDNs");
            ArrayList<String> accList = new ArrayList<String>();
            if (accArray != null) {
                for (int i = 0; i < accArray.length; ++i) {
                    accList.add(accArray[i]);
                }
            } else {
                log.info((Object)"The com.swimap.external.dsf.base.rpc.DataRecord.getStringArray(...)  return null  ");
            }
            groupSubnetDNsMap.put(reocrd.getInt("GroupID"), accList);
        }
        return groupSubnetDNsMap;
    }

    public boolean hasManagedByDeviceType(int userID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | hasManagedByDeviceType |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.hasManagedByDeviceType");
        req.addArgument("userid", (Object)userID);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | hasManagedByDeviceType |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        return msg.getBoolean("hasRight");
    }

    public boolean isManagedByDeviceType(int userID, String oid) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | isManagedByDeviceType |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.isManagedByDeviceType");
        req.addArgument("userid", (Object)userID);
        req.addArgument("oid", (Object)oid);
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | isManagedByDeviceType |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        return msg.getBoolean("hasRight");
    }

    public int getSuperGroupID() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getSuperGroupID |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getSuperGroupID");
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getSuperGroupID |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        return msg.getInt("supergroupid");
    }

    public Map<Integer, String> getAllUserNameAndIDOfNotAdminGroup() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getAllUserNameAndIDOfNotAdminGroup |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getAllUserNameAndIDOfNotAdminGroup");
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getAllUserNameAndIDOfNotAdminGroup |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        int[] useridArray = msg.getIntArray("useridArray");
        String[] usernameArray = msg.getStringArray("usernameArray");
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < useridArray.length; ++i) {
            map.put(useridArray[i], usernameArray[i]);
        }
        return map;
    }

    public int[] getDefaultGroupIDs() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getDefaultGroupIDs |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getDefaultGroupIDs");
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getDefaultGroupIDs |end " + (System.currentTimeMillis() - t)));
        RpcMessage msg = rsp.getMessage();
        return msg.getIntArray("defaultgroupids");
    }

    public int[] getOperationCommand() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getOperationCommand |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getOperationCommand");
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | getOperationCommand |end " + (System.currentTimeMillis() - t)));
        return rsp.getMessage().getIntArray("operationCommandArray");
    }

    public boolean isU2000Mode() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | isU2000Mode |start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.utilservice.isU2000Mode");
        RpcResponse rsp = req.invoke();
        log.info((Object)("RpcInvoker | isU2000Mode |end " + (System.currentTimeMillis() - t)));
        return rsp.getMessage().getBoolean("isU2000Mode");
    }

    public int[] getObjectType(int neType) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getObjectType");
        req.addArgument("neType", (Object)neType);
        RpcResponse rsp = req.invoke();
        log.info((Object)("end " + (System.currentTimeMillis() - t)));
        return rsp.getMessage().getIntArray("objecttype");
    }

    public int getAllDomainDevSetId() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"start");
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.utilservice.getAllDomainDevSetId");
        RpcResponse rsp = req.invoke();
        log.info((Object)("end " + (System.currentTimeMillis() - t)));
        return rsp.getMessage().getInt("id");
    }

    public int[] getDefaultDevSetOprSets() throws Exception {
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getDefaultDevSetOprSets");
        RpcResponse rsp = req.invoke();
        int[] result = new int[4];
        RpcMessage rpcMsg = rsp.getMessage();
        result[0] = rpcMsg.getInt(ALL_OBJECT_SET_KEY);
        result[1] = rpcMsg.getInt(ALL_DOMAIN_SET_KEY);
        result[2] = rpcMsg.getInt(ALL_OBJECT_OPR_SET_KEY);
        result[3] = rpcMsg.getInt(ALL_APP_OPR_SET_KEY);
        return result;
    }

    public void loadDeviceSetsByUser(int userid, Map<Integer, Set<Integer>> devset_subset_rel, Map<Integer, Set<String>> devset_memb) throws Exception {
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.loadDeviceSetsByUser");
        req.addArgument("userid", (Object)userid);
        log.info((Object)"loadDeviceSetsByUser start...");
        long t0 = System.currentTimeMillis();
        RpcResponse rsp = req.invoke();
        DataTable membTable = rsp.getMessage().getTable("members");
        for (DataRecord rec : membTable) {
            String[] members = rec.getStringArray("members");
            HashSet<String> membSet = new HashSet<String>();
            if (members != null) {
                for (String m : members) {
                    membSet.add(m);
                }
            } else {
                log.info((Object)"com.swimap.external.dsf.base.rpc.DataRecord.getStringArray(...) return null ");
            }
            devset_memb.put(rec.getInt("id"), membSet);
        }
        DataTable relTable = rsp.getMessage().getTable("rel");
        for (DataRecord rec : relTable) {
            int[] intArray = rec.getIntArray("subids");
            HashSet<Integer> subIds = new HashSet<Integer>();
            for (int id : intArray) {
                subIds.add(id);
            }
            devset_subset_rel.put(rec.getInt("id"), subIds);
        }
        log.info((Object)("loadDeviceSetsByUser end. cost:" + (System.currentTimeMillis() - t0)));
    }

    public void getOprSetMembersByUser(int userid, Map<Integer, Set<Integer>> oprset_subset_rel, Map<Integer, Map<String, TypeRight>> oprset_memb) throws Exception {
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.rightservice.getOprSetMembersByUser");
        req.addArgument("userid", (Object)userid);
        log.info((Object)"getOprSetMembersByUser start....");
        long t0 = System.currentTimeMillis();
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        DataTable relTable = msg.getTable("relations");
        if (relTable != null) {
            for (DataRecord rec : relTable) {
                int subid;
                int id = rec.getInt("id");
                Set<Integer> subIds = oprset_subset_rel.get(id);
                if (subIds == null) {
                    subIds = new HashSet<Integer>();
                    oprset_subset_rel.put(id, subIds);
                }
                if ((subid = rec.getInt("subid")) == 0) continue;
                subIds.add(subid);
            }
        }
        DataTable rightOfOprSetTable = null;
        Set<Map.Entry<Integer, Set<Integer>>> entrySet = oprset_subset_rel.entrySet();
        for (Map.Entry<Integer, Set<Integer>> en : entrySet) {
            int oprSetId = en.getKey();
            rightOfOprSetTable = msg.getTable(String.valueOf(oprSetId));
            oprset_memb.put(oprSetId, this.parseRightsFromTable(rightOfOprSetTable));
            for (int subid : en.getValue()) {
                rightOfOprSetTable = msg.getTable(String.valueOf(subid));
                oprset_memb.put(subid, this.parseRightsFromTable(rightOfOprSetTable));
            }
        }
        log.info((Object)("getOprSetMembersByUser end. cost:" + (System.currentTimeMillis() - t0)));
    }

    public String[] getLogTypeInfo(int iMainType, int iSubType, int cmdCode) {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sm.ds.msgadp.utilservice.getLogTypeInfo");
            req.addArgument("maintype", (Object)iMainType);
            req.addArgument("subtype", (Object)iSubType);
            req.addArgument("cmdcode", (Object)cmdCode);
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            return msg.getStringArray("logTypeInfo");
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Set<Integer> getUserListByCmd(int cmdID) throws Exception {
        RpcRequest req = this.getRpcRequest("sm.ds.msgadp.utilservice.getUserListByCmd");
        req.addArgument("cmdID", (Object)cmdID);
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        DataTable table = msg.getTable("userIds");
        if (table == null || table.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Integer> result = new HashSet<Integer>();
        for (DataRecord rec : table) {
            result.add(rec.getInt("id"));
        }
        return result;
    }
}

