/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.util;

import com.swimap.external.sm.dialog.EmfOperationShowDlg;
import com.swimap.external.sm.util.EmfLogResourceManager;
import com.swimap.external.sm.util.EmfSecLogCommonUtil;
import com.swimap.external.sm.util.EmfSecurityRes;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.main.EmfUserManager;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class EmfSecurityConstant {
    private static IviewLogger logger = TraceProxy.getLogger(EmfSecurityConstant.class);
    private static EmfOperationShowDlg operationDlg = null;
    private static volatile boolean isShowing = false;
    public static final long MAX_INT = Math.round(Math.pow(2.0, 32.0));
    public static final String MESSAGE_TITLE = EmfSecurityRes.getString("Constant_MESSAGE_TITLE");
    public static final String ERROR_TITLE = EmfLogResourceManager.getString("OPERATE_RESULT");
    public static final Color DISABLE_COLOR = UIManager.getColor("Label.background");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Locale SYSTEM_LOCALE = ResourceMng.getInstance().getLocale();
    public static final int N2000_TYPE = 201;
    public static final int SECURITY_SUBTYPE = 2;
    public static final int N2000_OBJECT_ID = 1;

    public static void dealWithError(Component oParent, int iCmdCode, int iErrorCode) {
        Component parent = oParent;
        if (oParent != null) {
            Component component = parent = oParent instanceof Window ? oParent : SwingUtilities.getWindowAncestor(oParent);
            if (parent == null) {
                parent = oParent;
            }
        }
        if (iErrorCode != 0) {
            StringBuffer strLog = new StringBuffer();
            strLog.append("dealWithError(Component parent,int iCmdCode,int iErrorCode) ");
            strLog.append("[parent = ");
            if (null != parent) {
                strLog.append(parent.getClass().toString());
            }
            strLog.append(" CmdCode = ");
            strLog.append(iCmdCode);
            strLog.append(" ErrorCode = ");
            strLog.append(iErrorCode);
            strLog.append("]");
            logger.trace((Object)strLog.toString());
        }
        String strCmdName = null;
        strCmdName = iCmdCode == -1 ? "" : EmfSecLogCommonUtil.getCmdNameFromCmdCode(iCmdCode);
        String[] operationInfo = EmfSecurityConstant.getOperationInfos(strCmdName, iErrorCode);
        if (operationInfo == null) {
            return;
        }
        EmfSecurityConstant.showOperationDlg(parent, operationInfo[0], operationInfo[1]);
    }

    private static void showOperationDlg(Component component, String simpleInfo, String detailInfo) {
        if (SwingUtilities.isEventDispatchThread()) {
            EmfSecurityConstant.showOperationDlgInEventQueueThread(component, simpleInfo, detailInfo);
        } else {
            EmfSecurityConstant.showOperationDlgNotInEventQueueThread(component, simpleInfo, detailInfo);
        }
    }

    private static void showOperationDlgInEventQueueThread(Component component, String simpleInfo, String detailInfo) {
        if (isShowing) {
            if (null != operationDlg) {
                operationDlg.setDisplayInfo(simpleInfo, detailInfo);
                operationDlg.setVisible(true);
            }
        } else {
            isShowing = true;
            try {
                EmfSecurityConstant.showDlg(component, simpleInfo, detailInfo);
            }
            catch (Exception e) {
                isShowing = false;
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    private static void showOperationDlgNotInEventQueueThread(final Component component, final String simpleInfo, final String detailInfo) {
        if (isShowing) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (null != operationDlg) {
                            operationDlg.setDisplayInfo(simpleInfo, detailInfo);
                            operationDlg.setVisible(true);
                        }
                    }
                });
            }
            catch (Exception e) {
                isShowing = false;
                logger.error((Object)"", (Throwable)e);
            }
        } else {
            isShowing = true;
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EmfSecurityConstant.showDlg(component, simpleInfo, detailInfo);
                    }
                });
            }
            catch (Exception e) {
                isShowing = false;
                logger.error((Object)e);
            }
        }
    }

    public static void showDlg(Component component, String simpleInfo, String detailInfo) {
        operationDlg = null == component || !component.isVisible() ? new EmfOperationShowDlg((Frame)EmfUserManager.getMainFrame(), true) : (component instanceof Frame ? new EmfOperationShowDlg((Frame)component, true) : (component instanceof Dialog ? new EmfOperationShowDlg((Dialog)component, true) : new EmfOperationShowDlg((Frame)EmfUserManager.getMainFrame(), true)));
        operationDlg.setDisplayInfo(simpleInfo, detailInfo);
        ScreenToolKit.centerLocateToScreen((Component)operationDlg);
        operationDlg.setVisible(true);
        operationDlg = null;
        isShowing = false;
    }

    private static String[] getOperationInfos(String cmdName, int iErrorCode) {
        String strCmdName = cmdName;
        String strEmptyCmdName = "";
        StringBuffer detailInfoBuffer = new StringBuffer();
        if (strCmdName == null || strCmdName.length() == 0) {
            strCmdName = "";
            strEmptyCmdName = "_Empty_CmdName";
        } else {
            String strSplit = "";
            Locale locale = Locale.getDefault();
            if (!locale.getLanguage().toUpperCase().equals("ZH")) {
                strSplit = " ";
            }
            strCmdName = strCmdName + strSplit;
        }
        String strResult = iErrorCode == 0 ? EmfSecurityRes.getString("Tree_OperateOK" + strEmptyCmdName) : EmfSecurityRes.getString("Operate_Fail" + strEmptyCmdName);
        String errorinfo = strCmdName + strResult;
        if (iErrorCode == 0) {
            EmfUserManager.getInstance().refreshStatus("NotificationMessageItem", errorinfo);
            return null;
        }
        if (iErrorCode != 0) {
            String strErrorInfo = EmfSecurityRes.getErrorinfoFromErrorCode(iErrorCode);
            errorinfo = errorinfo + SYMBOL.SYMBOL_FULLSTOP;
            detailInfoBuffer.append(EmfLogResourceManager.getString("LOG_ERRORDESCRIPT"));
            detailInfoBuffer.append(SYMBOL.SYMBOL_COLON);
            detailInfoBuffer.append(strErrorInfo);
        }
        EmfUserManager.getInstance().refreshStatus("NotificationMessageItem", "");
        String[] operationInfo = new String[]{errorinfo, detailInfoBuffer.toString()};
        return operationInfo;
    }

    public static void dealWithErrorInEventQueue(Component parent, int iCmdCode, int iErrorCode) {
        EmfSecurityConstant.dealWithError(parent, iCmdCode, iErrorCode);
    }

    public static void dealWithErrorEx(Component oParent, int iMainType, int iSubType, int iCmdCode, int iErrorCode) {
        Component parent = oParent;
        if (oParent != null) {
            Component component = parent = oParent instanceof Window ? oParent : SwingUtilities.getWindowAncestor(oParent);
            if (parent == null) {
                parent = oParent;
            }
        }
        if (iErrorCode != 0) {
            StringBuffer strLog = new StringBuffer();
            strLog.append("dealWithErrorEx ");
            strLog.append("[parent = ");
            if (null != parent) {
                strLog.append(parent.getClass().toString());
            }
            strLog.append(" MainType = ");
            strLog.append(iMainType);
            strLog.append(" SubType = ");
            strLog.append(iSubType);
            strLog.append(" CmdCode = ");
            strLog.append(iCmdCode);
            strLog.append(" ErrorCode = ");
            strLog.append(iErrorCode);
            strLog.append("]");
            logger.info((Object)strLog.toString());
        }
        String strCmdName = null;
        strCmdName = iCmdCode == -1 ? "" : EmfSecLogCommonUtil.getCmdNameFromCmdCode(iMainType, iSubType, iCmdCode);
        String[] operationInfo = EmfSecurityConstant.getOperationInfos(strCmdName, iErrorCode);
        if (operationInfo == null) {
            return;
        }
        EmfSecurityConstant.showOperationDlg(parent, operationInfo[0], operationInfo[1]);
    }

    public static void dealWithError(int iCmdCode, int iErrorCode) {
        StringBuffer strLog = new StringBuffer();
        strLog.append("dealWithError(int iCmdCode,int iErrorCode) ");
        strLog.append(" CmdCode = ");
        strLog.append(iCmdCode);
        strLog.append(" ErrorCode = ");
        strLog.append(iErrorCode);
        logger.info((Object)strLog.toString());
        String strResult = iErrorCode == 0 ? EmfSecurityRes.getString("Tree_OperateOK") : EmfSecurityRes.getString("Operate_Fail");
        String strCmdName = EmfSecLogCommonUtil.getCmdNameFromCmdCode(iCmdCode);
        String strSplit = "";
        Locale locale = Locale.getDefault();
        if (!locale.getLanguage().toUpperCase().equals("ZH")) {
            strSplit = " ";
        }
        strCmdName = strCmdName + strSplit;
        if (iCmdCode == -1) {
            strCmdName = "";
        }
        if (strCmdName.length() == 0) {
            return;
        }
        long lvalue = iErrorCode;
        if (lvalue < 0L && lvalue != -1L) {
            lvalue += MAX_INT;
        }
        String strErrorInfo = EmfSecurityRes.getErrorinfoFromErrorCode(String.valueOf(lvalue));
        StringBuffer buffer = new StringBuffer(EmfSecurityRes.getString("Constant_OPERATE_NAME") + " : ");
        buffer.append(strCmdName + ".\n");
        buffer.append(EmfLogResourceManager.getString("OPERATE_RESULT_1") + " : ");
        buffer.append(strResult + ".\n");
        if (iErrorCode != 0) {
            buffer.append(EmfLogResourceManager.getString("LOG_ERRORDESCRIPT") + " : ");
            buffer.append(strErrorInfo + "\n");
        }
        String errorinfo = strCmdName + strResult;
        if (iErrorCode != 0) {
            StringBuffer temp = new StringBuffer(".\n" + EmfLogResourceManager.getString("LOG_ERRORDESCRIPT") + " : ");
            temp.append(strErrorInfo + "\n");
            errorinfo = errorinfo + temp.toString();
        }
        EmfUserManager.getInstance().printMessage(errorinfo);
    }

    public static String getSSLCertPath() {
        String certPath = null;
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/security/SecurityConfig");
            AreaDescContainer area = commStyleInfo.getAreaDescContainer("SSL");
            DescContainer desc = area.getDescContainer("SSL");
            certPath = desc.getParasItemValue("CERTPATH");
        }
        catch (Exception e) {
            logger.trace((Object)"Get SSLCertPath fail!");
            logger.trace((Object)e);
        }
        return certPath;
    }

    public static Hashtable<String, String> getOvertimeParam() {
        Hashtable<String, String> htParamter = new Hashtable<String, String>();
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/security/SecurityConfig");
        if (commStyleInfo == null) {
            return htParamter;
        }
        AreaDescContainer areaMain = commStyleInfo.getAreaDescContainer("SECURITY_TIME");
        if (areaMain == null) {
            return htParamter;
        }
        int count = areaMain.getDescCount();
        for (int i = 0; i < count; ++i) {
            DescContainer descObject = areaMain.getDescContainer(i);
            String strKey = descObject.getDescName();
            String strParamter = descObject.getParasItemValue("overtime");
            htParamter.put(strKey, strParamter);
        }
        return htParamter;
    }

    public static LinkedList<String> getErrorCodeFileName(String strPath, String filter) {
        LinkedList<String> listFile = new LinkedList<String>();
        String[] fileList = CommStyleManager.getInstance().getAllFilesFromAllDirectory(strPath);
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].indexOf(filter) <= 0) continue;
            int index = fileList[i].lastIndexOf(".");
            if (!fileList[i].substring(fileList[i].length() - 3).equals("xml")) continue;
            String strFileName = fileList[i].substring(0, index);
            listFile.add(strFileName);
        }
        return listFile;
    }

    public static final class LoginTime {
        public static final int VALID_START_YEAR = 2001;
        public static final int VALID_END_YEAR = 2037;
    }

    public static class SYMBOL {
        public static final String SYMBOL_COLON = EmfSecurityRes.getString("SYMBOL_COLON");
        public static final String SYMBOL_COMMA = EmfSecurityRes.getString("SYMBOL_COMMA");
        public static final String SYMBOL_FULLSTOP = EmfSecurityRes.getString("SYMBOL_FULLSTOP");
    }
}

