/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.main;

import com.swimap.external.general.adapter.message.EmfProductResourceIDConvert;
import com.swimap.external.lm.client.interfaces.LicItemInfoWrap;
import com.swimap.external.sm.adapter.message.EmfSecurityInterface;
import com.swimap.external.sm.adapter.message.IUserChangeListener;
import com.swimap.external.sm.adapter.message.LicenseInfo;
import com.swimap.external.sm.adapter.message.LicenseInterface;
import com.swimap.external.sm.adapter.message.LoginMode;
import com.swimap.external.sm.adapter.message.UpdateLicenseInterface;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.external.sm.client.mgr.datasource.entity.info.common.UserGroupInfo;
import com.swimap.external.sm.client.mgr.interfaces.ICopySubRes;
import com.swimap.external.sm.util.EmfSecLogCommonUtil;
import com.swimap.external.sm.util.EmfSecurityRes;
import com.swimap.external.sm.util.EmfSecurityUtil;
import com.swimap.external.sm.util.ExternalMethodInvoker;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.external.topo.adapter.message.EmfResUpdateInterface;
import com.swimap.external.topo.adapter.message.EmfTopoResInterface;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.checkright.cache.RightTimer;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.imap.security.data.AdpCheckRight;
import com.swimap.imap.security.data.EmfSecurityLicenseManager;
import com.swimap.imap.security.data.UserChangedListenerImpl;
import com.swimap.imap.security.data.res.CopySubResManager;
import com.swimap.imap.security.event.SMEventHandlerRegister;
import com.swimap.imap.security.event.handers.UserAddOrDelHandler;
import com.swimap.imap.security.main.EmfFDNCheckTool;
import com.swimap.imap.security.main.EmfUpdateLicenseManager;
import com.swimap.imap.security.util.EmfSecurityConstant;
import com.swimap.imap.security.util.ExternalMethodImpl;
import com.swimap.imap.security.util.GlobalUtil;
import com.swimap.imap.security.util.RpcInvoker;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.communicate.CommManager;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.pluginmanagement.PluginResourceManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.lm.client.LicenseManager;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.SessionService;
import com.swimap.sm.client.base.adapt.IUserChangedListener;
import com.swimap.sm.client.base.adapt.UserChangedListenerHandler;
import com.swimap.sm.client.base.product.interfaces.ICheckCommandAreaDesc;
import com.swimap.sm.client.mgr.SecurityManagerProxy;
import com.swimap.sm.client.mgr.SecurityModule;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JFrame;

public class EmfUserManager
extends BaseModule
implements EmfSecurityInterface,
EmfResUpdateInterface,
ICheckCommandAreaDesc {
    private static IviewLogger logger = TraceProxy.getLogger(EmfUserManager.class);
    public static final ResourceBundle RES = PluginResourceManager.getResourceBundleFromPropertyFile((String)"com.swimap.adapter.message.sm", (String)"Res");
    public static final String OMC_OBJECT_ID = "NE=1";
    public static final String OMC_OBJECT_ID_OLD = "1";
    public static final int USERGROUP_AND_USER_RELATION_HANDLER = 3;
    private static final String AUTHENTICATIONMODULENAME = "authentication";
    private String m_szServerIP = null;
    private int m_iServerPort;
    public CommManager commManager = null;
    private static EmfUserManager _instance = null;
    private static EmfTopoResInterface topoResInterface = null;
    private static EmfSecurityLicenseManager m_licenseManager = new EmfSecurityLicenseManager();
    private static Map<Integer, ArrayList<int[]>> operatorTable = new HashMap<Integer, ArrayList<int[]>>();
    private static Map<Integer, ArrayList<int[]>> unRightCheckOperatorTable = new HashMap<Integer, ArrayList<int[]>>();
    private static Set<Integer> adminRightCheckOperatorTable = new HashSet<Integer>();
    private Hashtable<String, String> htOvertimeParam = new Hashtable();
    private RightTimer rightTimer = null;
    private UserChangedListenerImpl productUserChandedListenerMgr = null;

    public EmfUserManager(ModuleManager moduleMgr) throws ModuleManagementException {
        super(moduleMgr);
        _instance = this;
        ExternalMethodInvoker.setIExternalMathed(new ExternalMethodImpl());
    }

    public static EmfUserManager getInstance() {
        return _instance;
    }

    public EmfSecurityLicenseManager getLicenseManager() {
        return m_licenseManager;
    }

    public static EmfTopoResInterface getResourceInterface() {
        if (topoResInterface == null) {
            try {
                logger.trace((Object)"Registration information resources change notification interface registerResUpdateHandler");
                topoResInterface = (EmfTopoResInterface)_instance.getLocalReference("com.swimap.adapter.message.resource");
                topoResInterface.registerResUpdateHandler((EmfResUpdateInterface)_instance);
            }
            catch (Exception e) {
                logger.trace((Object)"topoResInterface init failure!");
            }
        }
        return topoResInterface;
    }

    public void stop() {
        AdpCheckRight.getInstance().clearRightCache();
        topoResInterface = null;
        if (this.productUserChandedListenerMgr != null) {
            UserChangedListenerHandler.getInstance().removeUserChangedListener();
            this.productUserChandedListenerMgr.removeAllListener();
        }
        if (this.rightTimer != null) {
            this.rightTimer.removeRightTimerListener();
            this.rightTimer.stop();
            this.rightTimer = null;
        }
    }

    public void processResUpdateEvent(int iEventType, Object oMsg) {
    }

    public static JFrame getMainFrame() {
        return FrameworkUtilities.getMainFrame();
    }

    public String getModuleName() {
        return "com.swimap.adapter.message.sm";
    }

    public void initialize() {
        try {
            this.getMDPServerIPPort();
        }
        catch (Exception e) {
            logger.trace((Object)"initialize CommManager is failure!");
        }
        this.htOvertimeParam = EmfSecurityConstant.getOvertimeParam();
        AdpCheckRight.getInstance().getUserRightInfo();
        SMEventHandlerRegister.register();
        if (!AdpCheckRight.getInstance().isAdminOrAdminGroupUser()) {
            Object[] tables = RpcInvoker.getInstance().getAllRightOperatorTable();
            if (tables == null) {
                logger.info((Object)"the operator table is null");
            } else {
                operatorTable = (Map)tables[0];
                unRightCheckOperatorTable = (Map)tables[1];
                adminRightCheckOperatorTable = (Set)tables[2];
            }
        }
        SecurityBaseModule securityBase = (SecurityBaseModule)this.getLocalModule(AUTHENTICATIONMODULENAME);
        securityBase.registerMsgAdpCheckCommandAreaDesc((ICheckCommandAreaDesc)this);
        SecurityModule securityManager = (SecurityModule)this.getLocalModule("securitymanager");
        securityManager.dataSource().getIntfMgr().setCopySubResIntf((ICopySubRes)CopySubResManager.getInstance());
        this.rightTimer = new RightTimer();
        this.rightTimer.addRightTimerListener(SetRightCache.getInstance());
        this.rightTimer.addRightTimerListener(RightCache.getInstance());
        this.rightTimer.startTimer();
    }

    public boolean isU2000Mode() {
        try {
            return RpcInvoker.getInstance().isU2000Mode();
        }
        catch (Exception e) {
            logger.error((Object)"get U2000Mode error.", (Throwable)e);
            return false;
        }
    }

    public boolean checkCommandAreaDesc(DescContainer objDesc) {
        String operationID = objDesc.getParasItemValue("operationID");
        if (operationID != null) {
            if (AdpCheckRight.getInstance().isAdminOrAdminGroupUser()) {
                return true;
            }
            int cmdID = Integer.valueOf(operationID);
            if (cmdID == 0) {
                return true;
            }
            return this.checkUserOperation(cmdID);
        }
        return false;
    }

    public boolean[] checkCommandAreaDesc(DescContainer[] objDescs) {
        int len = objDescs.length;
        HashMap<Integer, Integer> cmdIdNResultMap = new HashMap<Integer, Integer>();
        if (len == 0) {
            return null;
        }
        boolean[] result = new boolean[len];
        if (AdpCheckRight.getInstance().isAdminOrAdminGroupUser()) {
            for (int i = 0; i < len; ++i) {
                result[i] = true;
            }
            return result;
        }
        int[] cmdIDs = new int[len];
        boolean isNeedContinue = false;
        for (int i = 0; i < len; ++i) {
            String operationID = objDescs[i].getParasItemValue("operationID");
            if (operationID == null) continue;
            int cmdID = Integer.valueOf(operationID);
            cmdIdNResultMap.put(cmdID, -1);
            cmdIDs[i] = cmdID;
            if (cmdID == 0) {
                cmdIdNResultMap.put(cmdID, 1);
                continue;
            }
            if (AdpCheckRight.getInstance().isExist(cmdID)) {
                boolean hasRigth = AdpCheckRight.getInstance().getCheckResult(cmdID);
                cmdIdNResultMap.put(cmdID, hasRigth ? 1 : 0);
                continue;
            }
            isNeedContinue = true;
        }
        if (isNeedContinue) {
            this.batchCheckUserOperation(cmdIdNResultMap);
        }
        AdpCheckRight.getInstance().addCheckResult(cmdIdNResultMap);
        Integer res = null;
        for (int i = 0; i < cmdIDs.length; ++i) {
            res = (Integer)cmdIdNResultMap.get(cmdIDs[i]);
            result[i] = res != null && res == 1;
        }
        return result;
    }

    public boolean checkUserManagable(String strResID) {
        if (strResID == null) {
            return false;
        }
        if (EmfFDNCheckTool.isSubRes(strResID)) {
            return AdpCheckRight.getInstance().checkUserSubResManaged(strResID);
        }
        return AdpCheckRight.getInstance().checkUserSOManaged(strResID);
    }

    public boolean checkUserSOManagedForTopo(String strResID) {
        if (strResID == null) {
            return false;
        }
        if (EmfFDNCheckTool.isSubRes(strResID)) {
            return AdpCheckRight.getInstance().checkUserSubResManaged(strResID);
        }
        return AdpCheckRight.getInstance().checkUserSOManagedForTopo(strResID);
    }

    public int[] checkUserManagable(String[] strResIDArray) {
        int[] retArray = new int[strResIDArray.length];
        AdpCheckRight adpCheckRight = AdpCheckRight.getInstance();
        for (int i = 0; i < strResIDArray.length; ++i) {
            retArray[i] = EmfFDNCheckTool.isSubRes(strResIDArray[i]) ? (adpCheckRight.checkUserSubResManaged(strResIDArray[i]) ? 1 : 0) : (adpCheckRight.checkUserSOManaged(strResIDArray[i]) ? 1 : 0);
        }
        return retArray;
    }

    public int checkRTUserManagable(String strResID) {
        return this.checkUserManagable(strResID) ? 1 : 0;
    }

    public int[] checkRTUserManagable(String[] strResIDList) {
        return this.checkUserManagable(strResIDList);
    }

    public boolean checkSecurityRight(int iCmdID) {
        return this.checkUserOperation(201, 2, String.valueOf(1), iCmdID);
    }

    public boolean checkUserOperation(int objectTypeID, int objectSubtypeID, String objectID, int cmdID) {
        return this.checkUserOperation(objectTypeID, objectSubtypeID, objectID, cmdID, this.getUserID());
    }

    private boolean checkUserOperation(int objectTypeID, int objectSubtypeID, String objectID, int cmdID, int userId) {
        logger.info((Object)("in checkUserOperation(" + objectTypeID + ", " + objectSubtypeID + ", " + objectID + ", " + cmdID + ", " + userId));
        if (AdpCheckRight.getInstance().isAdminOrAdminGroupUser()) {
            return true;
        }
        long t = System.currentTimeMillis();
        ArrayList<RightInfo> needToCheck = new ArrayList<RightInfo>();
        int rightResult = this.checkOperstionRightSpecail(objectTypeID, objectSubtypeID, objectID, cmdID, needToCheck);
        if (rightResult == 1) {
            return true;
        }
        if (rightResult == 0) {
            return false;
        }
        try {
            boolean result = AdpCheckRight.getInstance().checkRight(needToCheck.toArray(new RightInfo[0]), userId)[0] == 1;
            logger.error((Object)("out checkUserOperation(" + objectTypeID + ", " + objectSubtypeID + ", " + objectID + ", " + cmdID + ", " + userId + ") cost time:" + (System.currentTimeMillis() - t) + " result:" + result));
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("RIGHT CHECK FAIL FOR " + cmdID), (Throwable)e);
            return false;
        }
    }

    private int checkOperstionRightSpecail(int objectTypeID, int objectSubtypeID, String objectID, int cmdID, List<RightInfo> needToCheck) {
        String dn;
        String objectClassName;
        String objectClassType;
        if (objectTypeID == -1) {
            int[] tmp = new int[2];
            try {
                tmp = RpcInvoker.getInstance().getObjectType(objectSubtypeID);
                objectTypeID = tmp[0];
                objectSubtypeID = tmp[1];
            }
            catch (Exception e) {
                return 0;
            }
        }
        if (objectID == null) {
            return 0;
        }
        if (this.isContain(unRightCheckOperatorTable, objectTypeID, objectSubtypeID, cmdID)) {
            return 1;
        }
        if (adminRightCheckOperatorTable.contains(cmdID)) {
            return 0;
        }
        if (this.isContain(operatorTable, objectTypeID, objectSubtypeID, cmdID)) {
            objectClassType = "";
            objectClassName = null;
            dn = null;
            if (objectTypeID != 201) {
                objectClassType = "MANAGED_OBJECT";
                objectClassName = objectTypeID + "_" + objectSubtypeID;
                String string = objectID = "".equals(objectID) ? OMC_OBJECT_ID_OLD : objectID;
                if (!(OMC_OBJECT_ID.equals(objectID) || OMC_OBJECT_ID_OLD.equals(objectID) || "".equals(objectID) || this.checkUserManagable(objectID))) {
                    return 0;
                }
                if (EmfFDNCheckTool.isSubRes(objectID)) {
                    objectID = GlobalUtil.dealSplitToGlobal(objectID, EmfSecurityUtil.getFdnDivideSymbolEx())[0];
                }
                dn = EmfProductResourceIDConvert.getInstance().resourceId2Fdn(objectID);
            } else {
                objectClassType = "APPLICATION";
                switch (objectSubtypeID) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return 0;
                    }
                }
                dn = objectClassName = objectTypeID + "_" + objectSubtypeID;
            }
        } else {
            return 1;
        }
        String operation = Integer.toString(cmdID);
        needToCheck.add(new RightInfo(objectClassType, objectClassName, dn, operation));
        return -1;
    }

    private boolean isContain(Map<Integer, ArrayList<int[]>> table, int objectTypeID, int objectSubtypeID, int cmdID) {
        ArrayList<int[]> tmp = table.get(cmdID);
        if (tmp != null) {
            for (int[] ms : tmp) {
                if (ms[0] != objectTypeID || ms[1] != objectSubtypeID) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean checkUserOperation(int cmdID) {
        logger.info((Object)("checkUserOperation(" + cmdID + ")"));
        if (AdpCheckRight.getInstance().isExist(cmdID)) {
            boolean result = AdpCheckRight.getInstance().getCheckResult(cmdID);
            logger.info((Object)("hasRight:" + cmdID + " result:" + result));
            return result;
        }
        boolean result = this.checkUserOperation(cmdID, this.getUserID());
        logger.info((Object)("nonhasRight:" + cmdID + " result:" + result));
        AdpCheckRight.getInstance().addCheckResult(cmdID, result);
        return result;
    }

    private boolean checkUserOperation(int cmdID, int userId) {
        if (AdpCheckRight.getInstance().isAdminOrAdminGroupUser()) {
            return true;
        }
        if (cmdID == 0) {
            logger.info((Object)("the cmd:" + cmdID + " is not check, has right"));
            return true;
        }
        ArrayList<int[]> list = operatorTable.get(cmdID);
        boolean isHasRight = false;
        if (list != null) {
            logger.info((Object)("the cmd:" + cmdID + " in the check right table"));
            for (int[] type : list) {
                if (!(isHasRight = isHasRight || this.checkUserOperation(type[0], type[1], "", cmdID))) continue;
                break;
            }
            logger.info((Object)("userId:" + userId + " has " + (isHasRight ? "" : "not") + " right of the cmd:" + cmdID));
            return isHasRight;
        }
        if (unRightCheckOperatorTable.containsKey(cmdID)) {
            logger.info((Object)("the cmd:" + cmdID + " in the uncheck right table, so has right"));
            return true;
        }
        if (adminRightCheckOperatorTable.contains(cmdID)) {
            logger.info((Object)"adminRightCheckOperatorTable is ok");
            try {
                if (AdpCheckRight.getInstance().isAdmin(userId)) {
                    logger.info((Object)("the userId:" + userId + " is admin, so has right"));
                    return true;
                }
                logger.info((Object)("the userId:" + userId + " is not admin, so has not right"));
                return false;
            }
            catch (Exception e) {
                logger.info((Object)"adminRightCheckOperatorTable is fail", (Throwable)e);
            }
        }
        logger.info((Object)("the cmd:" + cmdID + " is not defined in the tbl_CmdInfo, so the userId:" + userId + " has right"));
        return true;
    }

    private synchronized void batchCheckUserOperation(Map<Integer, Integer> cmdIdNResultMap) {
        int userId = this.getUserID();
        Set<Integer> cmdIDs = cmdIdNResultMap.keySet();
        ArrayList<RightInfo> needToCheck = new ArrayList<RightInfo>();
        block2: for (int cmd : cmdIDs) {
            ArrayList<int[]> list;
            int result = cmdIdNResultMap.get(cmd);
            if (result != -1 || (list = operatorTable.get(cmd)) == null) continue;
            int objectTypeID = -100;
            int objectSubtypeID = -100;
            for (int[] type : list) {
                objectTypeID = type[0];
                int res = this.checkOperstionRightSpecail(objectTypeID, objectSubtypeID = type[1], "", cmd, needToCheck);
                if (res == -1) continue;
                cmdIdNResultMap.put(cmd, res);
                continue block2;
            }
        }
        try {
            RightInfo[] rightInfos = needToCheck.toArray(new RightInfo[0]);
            int[] result = AdpCheckRight.getInstance().checkRight(rightInfos, userId);
            Integer cmdID = null;
            Integer res = null;
            for (int i = 0; i < rightInfos.length; ++i) {
                cmdID = Integer.valueOf(rightInfos[i].getOperation());
                res = cmdIdNResultMap.get(cmdID);
                if (res == null) {
                    cmdIdNResultMap.put(cmdID, result[i]);
                    continue;
                }
                if (res == 1) continue;
                cmdIdNResultMap.put(cmdID, result[i]);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public boolean isSubmapManagable(String strSubmapID) {
        return AdpCheckRight.getInstance().checkUserSOManaged(strSubmapID);
    }

    public void displayOperateResult(Component parent, int iCmdCode, int iErrorCode) {
        EmfSecurityConstant.dealWithError(parent, iCmdCode, iErrorCode);
    }

    public void displayOperateResult(int iCmdCode, int iErrorCode) {
        EmfSecurityConstant.dealWithError(iCmdCode, iErrorCode);
    }

    public void displayOperateResultEx(Component parent, int iMainType, int iSubType, int iCmdCode, int iErrorCode) {
        EmfSecurityConstant.dealWithErrorEx(parent, iMainType, iSubType, iCmdCode, iErrorCode);
    }

    public String getCmdInfo(int iMainType, int iSubType, int iCmdCode) {
        return EmfSecLogCommonUtil.getCmdNameFromCmdCode(iMainType, iSubType, iCmdCode);
    }

    public String getErrorInfo(String strErrorCode) {
        return EmfSecurityRes.getErrorinfoFromErrorCode(strErrorCode);
    }

    private void getMDPServerIPPort() {
        try {
            this.m_szServerIP = System.getProperty("imap.mrb.ip");
            this.m_iServerPort = Integer.valueOf(System.getProperty("imap.mrb.port"));
        }
        catch (Exception e) {
            logger.trace((Object)"getMDPServerIPPort is failure!");
        }
    }

    public Object[] getSecurityInfo() {
        try {
            Object[] securityInfo = new Object[]{this.m_szServerIP, this.m_iServerPort};
            logger.trace((Object)("securityInfo[1]:" + securityInfo[1]));
            return securityInfo;
        }
        catch (Exception e) {
            logger.trace((Object)"getSecurityInfo is failure!");
            logger.trace((Object)"========in EmfUserManager getSecurityInfo");
            return null;
        }
    }

    public String getServerIP() {
        return this.m_szServerIP;
    }

    public int getProxyPort() {
        try {
            return Integer.valueOf(RpcInvoker.getInstance().getConfParamValue("/imap/common/porttrunking/port"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getUserNameById(int userID) {
        return UserAddOrDelHandler.getInstance().getUserNameByID(userID);
    }

    public String getUsername() {
        return SessionService.getInstance().getCurUserName();
    }

    public int getUserID() {
        return SessionService.getInstance().getCurUser().id;
    }

    public int getSessionID() {
        return SessionService.getInstance().getCurSessionID();
    }

    public LoginMode getloginMode() {
        SecurityBaseModule secuModule = (SecurityBaseModule)this.moduleManager.getLocalModule(AUTHENTICATIONMODULENAME);
        LoginMode loginMode = new LoginMode();
        loginMode.mode = secuModule.getSessionManager().getCurServerMode() ? 1 : 0;
        loginMode.port = this.m_iServerPort;
        return loginMode;
    }

    public boolean isUserInGroup(int iGroupID) {
        List list = SecurityManagerProxy.getInstance().getUserBindUserGroups(this.getUserID());
        for (UserGroupInfo info : list) {
            if (iGroupID != info.getID()) continue;
            return true;
        }
        return false;
    }

    public void setUserDefinedSetAction(int iSpecGroupID, ActionListener actionListener) {
    }

    public UpdateLicenseInterface getUpdateLicenseInterface() {
        return EmfUpdateLicenseManager.getInstance();
    }

    public boolean registerLicense(LicenseInterface licenseIntance) {
        return this.getLicenseManager().registerLicense(this.getModuleManager(), licenseIntance);
    }

    public boolean unRegisterLicense(LicenseInterface licenseIntance) {
        return this.getLicenseManager().unRegisterLicense(this.getModuleManager(), licenseIntance);
    }

    public void refreshStatus(String name, String value) {
        FrameworkUtilities.getStatusBarManager().refreshItem(name, value);
    }

    public synchronized void printMessage(String s) {
        this.addMessage(s + "\r");
    }

    public LicenseInfo getLicenseInfo(String feature, String item) {
        LicItemInfoWrap wrap = LicenseManager.getLicenseMgr().getLicenseInfo(feature, item);
        if (wrap == null) {
            return null;
        }
        LicenseInfo info = new LicenseInfo(wrap.licItemInfo.item.nItemType, wrap.licItemInfo.name);
        info.setLicenseMaxNum(wrap.licItemInfo.maxValue);
        info.setLicenseProductName(wrap.licItemInfo.productName);
        info.setLicenseUsedNum(wrap.licItemInfo.usedValue);
        info.setSupportDetailInfoDisplay(wrap.licItemInfo.hasDetail == 1);
        return info;
    }

    public boolean isSingleUserMode() {
        try {
            return RpcInvoker.getInstance().getSystemMode() == 0;
        }
        catch (Exception e) {
            logger.trace((Object)"isSingleUserMode is failure!");
            return false;
        }
    }

    public Map<String, BigInteger> getAllUserInfo(boolean bNeedCheckRight) {
        try {
            HashMap<String, BigInteger> mapUserInfo = new HashMap<String, BigInteger>();
            Map<String, Integer> userInfoMap = UserAddOrDelHandler.getInstance().getAllUserInfo(bNeedCheckRight);
            Set<String> keySet = userInfoMap.keySet();
            for (String userName : keySet) {
                mapUserInfo.put(userName.trim(), BigInteger.valueOf(userInfoMap.get(userName).intValue()));
            }
            return mapUserInfo;
        }
        catch (Exception e) {
            logger.trace((Object)"getAllUserInfo is failure!");
            return new HashMap<String, BigInteger>();
        }
    }

    public int isCurUserHasAllMngRight() {
        if (AdpCheckRight.getInstance().hasAllDevMgrRight()) {
            return 1;
        }
        return 0;
    }

    public boolean isHaveResoureMangerRight(int nUserID, String strResID) {
        return this.checkUserManagable(strResID);
    }

    public void startUserManagerFrm() {
        SecurityModule.getSecuityModuleRef().showSecurityFrame();
    }

    public boolean isAdmin(int userID) {
        try {
            return SessionService.getInstance().isAdminUser(userID);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getCertificatePath() {
        return EmfSecurityConstant.getSSLCertPath();
    }

    public int getOvertimeParam(String strLevel) {
        int iOvertime = 60000;
        if (this.htOvertimeParam == null) {
            logger.debug((Object)"Accessed overtime parameters is null.htOvertimeParam == null");
            return iOvertime;
        }
        String strParam = this.htOvertimeParam.get(strLevel);
        if (strParam == null) {
            logger.debug((Object)"Accessed overtime parameters is null.strParam == null");
            return iOvertime;
        }
        try {
            iOvertime = Integer.parseInt(strParam);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return iOvertime;
    }

    public boolean isAdminUserGroup() {
        return SessionService.getInstance().isAdminUserGroup();
    }

    public int checkLogicResManagable(String strLogResID) {
        return 1;
    }

    public int checkResGroupManagable(String strResGroup) {
        return 1;
    }

    public boolean check(DescContainer desc) {
        return this.checkCommandAreaDesc(desc);
    }

    public void addUserChangeListener(IUserChangeListener l) {
        if (this.productUserChandedListenerMgr == null) {
            this.productUserChandedListenerMgr = new UserChangedListenerImpl();
            UserChangedListenerHandler.getInstance().addUserChangedListener((IUserChangedListener)this.productUserChandedListenerMgr);
        }
        this.productUserChandedListenerMgr.addUserChangedListener(l);
    }

    public BigInteger[] getUserIdByName(String userName) {
        if (userName == null || userName.trim().equals("")) {
            return null;
        }
        BigInteger[] errorCodeAndUserId = new BigInteger[2];
        int userId = UserAddOrDelHandler.getInstance().getUserIDByName(userName);
        errorCodeAndUserId[0] = BigInteger.valueOf(userId);
        errorCodeAndUserId[1] = userId == -1 ? BigInteger.valueOf(-1L) : BigInteger.valueOf(0L);
        return errorCodeAndUserId;
    }

    public void removeUserChangeListener(IUserChangeListener l) {
        if (this.productUserChandedListenerMgr != null) {
            this.productUserChandedListenerMgr.removeUserChangedListener(l);
        }
    }

    public void exitTerminal(String strMessage) {
        OptionPane.showMessageDialog((Component)EmfUserManager.getMainFrame(), (Object)strMessage, (String)"", (int)1);
        Main.instance().exitTerminal();
    }

    public int[] getDefaultGroupIDs() {
        try {
            return RpcInvoker.getInstance().getDefaultGroupIDs();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new int[0];
        }
    }

    public int getSuperGroupID() {
        try {
            return RpcInvoker.getInstance().getSuperGroupID();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    public com.swimap.external.sm.adapter.message.UserGroupInfo getUserGroupInfo(int userGroupID, int flag, boolean needCheckRight) {
        HashMap<Integer, String> userNameMap;
        int currUserID = this.getUserID();
        if (needCheckRight) {
            List userGroupInfoList = SecurityManagerProxy.getInstance().getManagedGroupsOfUser(currUserID);
            boolean isManaged = false;
            for (UserGroupInfo info : userGroupInfoList) {
                if (userGroupID != info.getID()) continue;
                isManaged = true;
                break;
            }
            if (!isManaged) {
                logger.debug((Object)("the user " + currUserID + " not manage the group " + userGroupID));
                return null;
            }
        }
        com.swimap.external.sm.adapter.message.UserGroupInfo userGroupInfo = new com.swimap.external.sm.adapter.message.UserGroupInfo(userGroupID);
        if ((flag & 1) == 1) {
            userGroupInfo.setGroupName(SecurityManagerProxy.getInstance().getGroupName(userGroupID, false));
        }
        if ((flag & 2) == 2) {
            List userInfoList = SecurityManagerProxy.getInstance().getMembersofGroup(userGroupID, false);
            userNameMap = new HashMap<Integer, String>();
            for (UserInfo user : userInfoList) {
                userNameMap.put(user.getId(), user.getUserName());
            }
            userGroupInfo.setUserInfoMap(userNameMap);
        }
        if ((flag & 4) == 4) {
            List userInfoList = SecurityManagerProxy.getInstance().getManagedOwnerUser(userGroupID);
            userNameMap = new HashMap();
            for (UserInfo user : userInfoList) {
                userNameMap.put(user.getId(), user.getUserName());
            }
            userGroupInfo.setGroupManagerUserInfoMap(userNameMap);
        }
        return userGroupInfo;
    }

    public List<BigInteger> getUserListByCmd(int cmdID) {
        ArrayList<BigInteger> result = new ArrayList<BigInteger>();
        try {
            Set<Integer> userIds = RpcInvoker.getInstance().getUserListByCmd(cmdID);
            for (Integer id : userIds) {
                result.add(BigInteger.valueOf(id.longValue()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return result;
    }
}

