/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.main;

import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.sm.client.base.SessionService;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.common.commoninterface.security.EmfLogInterface;
import com.swimap.imap.common.commoninterface.security.LogInfo;
import com.swimap.imap.security.util.RpcInvoker;
import com.swimap.iview.util.log.IviewLogger;

public class EmfLogManager
implements EmfLogInterface {
    IviewLogger logger = TraceProxy.getLogger(EmfLogManager.class);
    private static EmfLogManager instance = null;

    public static EmfLogManager getInstance() {
        if (null == instance) {
            instance = new EmfLogManager();
        }
        return instance;
    }

    private EmfLogManager() {
        instance = this;
    }

    public int[] batchWriteLog(LogInfo[] logInfoList) {
        int[] errorCode = new int[logInfoList.length];
        for (int count = 0; count < logInfoList.length; ++count) {
            try {
                DataTable auditEntry = new DataTable("auditEntry");
                auditEntry.setColumns(new String[]{"addInfo", "user", "logLevel", "oper", "result", "target", "terminal", "userType"});
                String[] logTypeInfo = RpcInvoker.getInstance().getLogTypeInfo(logInfoList[count].getOTID(), logInfoList[count].getOTSID(), logInfoList[count].getCmdID());
                if (null == logTypeInfo) {
                    this.logger.warn((Object)("Write log failed. OTID:" + logInfoList[count].getOTID() + ", OTSID:" + logInfoList[count].getOTSID() + ", CmdID:" + logInfoList[count].getCmdID()));
                    continue;
                }
                String oper = logTypeInfo[0];
                String target = logInfoList[count].getOperteObject();
                if (null == oper || oper.equals("")) {
                    errorCode[count] = -1;
                    continue;
                }
                if (null == target || target.equals("") || target.length() > 255 || target.contains(" ")) {
                    errorCode[count] = -1;
                    continue;
                }
                if (logInfoList[count].getOperDesc().length() > 4096) {
                    errorCode[count] = -1;
                    continue;
                }
                int result = logInfoList[count].getResult();
                if (result != 0) {
                    result = result != 1 ? 1 : 2;
                }
                String terminal = SessionService.getInstance().getCurTerminalID();
                terminal = terminal.substring(0, terminal.indexOf(":"));
                int level = 3 - Integer.parseInt(logTypeInfo[1]);
                auditEntry.add(new Object[]{logInfoList[count].getOperDesc(), SessionService.getInstance().getCurUserName(), level, oper, result, target, terminal, SessionService.getInstance().getCurUser().userType});
                int logType = 42;
                if (logInfoList[count].getOTID() == 201 && logInfoList[count].getOTSID() == 2) {
                    logType = 43;
                }
                RpcRequest req = RpcNaming.createRequest((String)"log.ds.base.writeAudit");
                req.addArgument("category", (Object)logTypeInfo[2]);
                req.addTable(auditEntry);
                req.addArgument("logType", (Object)logType);
                req.invoke();
                errorCode[count] = 0;
                continue;
            }
            catch (Exception ex) {
                this.logger.trace((Object)("Write log " + count + "failed!"));
                errorCode[count] = -1;
            }
        }
        return errorCode;
    }

    public void clear() {
        instance = null;
    }
}

