/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.data;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.general.adapter.message.EmfProductResourceIDConvert;
import com.swimap.external.sm.client.base.SessionService;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.external.sm.util.EmfSecurityUtil;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.CheckRightCenter;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.imap.security.util.GlobalUtil;
import com.swimap.imap.security.util.RpcInvoker;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.event.EventRegisterFactory;
import com.swimap.sm.client.base.event.IEventHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdpCheckRight
implements IEventHandler {
    private IviewLogger log = TraceProxy.getLogger(AdpCheckRight.class);
    private boolean isRefershDomain = true;
    private Map<String, Map<String, String>> soidAndSubResOIDListMap = new HashMap<String, Map<String, String>>();
    private Map<Integer, Boolean> cmdidResultMap = new HashMap<Integer, Boolean>();
    private UserInfo curUser = null;
    private boolean isAdmin;
    private boolean isAdminGroupUser;
    private boolean isSecurityMgrGroupUser;
    private boolean hasAllResRight;
    private boolean hasLoadedAllResRightFlag;
    private static final Object loadAllResRightLock = new Object();
    private Object lock = new Object();
    private CheckRightCenter checkRigthCenter = new CheckRightCenter();
    private static AdpCheckRight instance = new AdpCheckRight();

    public static AdpCheckRight getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRightCache() {
        Object object = this.lock;
        synchronized (object) {
            this.isRefershDomain = true;
            this.hasAllResRight = false;
            this.hasLoadedAllResRightFlag = false;
            this.soidAndSubResOIDListMap.clear();
            this.cmdidResultMap.clear();
        }
        RightCache.getInstance().clear();
        RightCache.getInstance().handleStaticRightUpdate();
    }

    public boolean isExist(int cmdid) {
        return this.cmdidResultMap.containsKey(cmdid);
    }

    public boolean getCheckResult(int cmdid) {
        return this.cmdidResultMap.get(cmdid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckResult(int cmdid, boolean result) {
        Object object = this.lock;
        synchronized (object) {
            this.cmdidResultMap.put(cmdid, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckResult(Map<Integer, Integer> cmdIdNResultMap) {
        Object object = this.lock;
        synchronized (object) {
            Set<Integer> cmdIDs = cmdIdNResultMap.keySet();
            for (int cmd : cmdIDs) {
                this.cmdidResultMap.put(cmd, cmdIdNResultMap.get(cmd) == 1);
            }
        }
    }

    public boolean hasAllDevMgrRight() {
        return this.isAdmin || this.isAdminGroupUser || this.isSecurityMgrGroupUser || this.getHasAllResRight();
    }

    public boolean isAdminOrAdminGroupUser() {
        return this.isAdmin || this.isAdminGroupUser;
    }

    public boolean isAdmin(int userId) throws Exception {
        return SessionService.getInstance().isAdminUser(userId) || SessionService.getInstance().isAdminUserGroup();
    }

    public void getUserRightInfo() {
        this.curUser = SessionService.getInstance().getCurUser();
        this.isAdmin = SessionService.getInstance().isAdminUser();
        this.isAdminGroupUser = SessionService.getInstance().isAdminUserGroup();
        this.isSecurityMgrGroupUser = SessionService.getInstance().isSecurityMgrGroupUser();
        if (this.isAdmin || this.isAdminGroupUser || this.isSecurityMgrGroupUser) {
            return;
        }
        try {
            this.hasLoadedAllResRightFlag = false;
            this.hasAllResRight = this.getHasAllResRight();
            if (!this.hasAllResRight) {
                this.getSoidAndSubResOIDListMap();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"get right info failure.");
        }
    }

    public void registerEvent() {
        if (!this.isAdmin) {
            if (!this.isAdminGroupUser && !this.isSecurityMgrGroupUser) {
                EventRegisterFactory.create().register("3:23", (IEventHandler)this);
                EventRegisterFactory.create().register("1:2", (IEventHandler)this);
                EventRegisterFactory.create().register("1:3", (IEventHandler)this);
                EventRegisterFactory.create().register("3:11", (IEventHandler)this);
                EventRegisterFactory.create().register("3:24", (IEventHandler)this);
                EventRegisterFactory.create().register("3:15", (IEventHandler)this);
                EventRegisterFactory.create().register("3:25", (IEventHandler)this);
                EventRegisterFactory.create().register("3:6", (IEventHandler)this);
                EventRegisterFactory.create().register("3:2", (IEventHandler)this);
                EventRegisterFactory.create().register("5:2", (IEventHandler)this);
            }
            EventRegisterFactory.create().register("3:8", (IEventHandler)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(RpcEvent event) {
        int mainType = event.getMessage().getInt("MainType");
        int subType = event.getMessage().getInt("SubType");
        String eventType = mainType + ":" + subType;
        boolean isSecObjCreDelEvt = false;
        Object object = this.lock;
        synchronized (object) {
            if (eventType.equals("3:8") && !this.isCurrentUserInvolved(event)) {
                return true;
            }
            if (eventType.equals("1:2") || eventType.equals("1:3")) {
                this.log.info((Object)"SECURITY_OBJECT_CREATED");
                isSecObjCreDelEvt = true;
                RightCache.getInstance().clearGroupRightCache();
                DataTable userdt = event.getMessage().getTable("userTable");
                DataTable addSOdt = event.getMessage().getTable("addSO");
                DataTable delSOdt = event.getMessage().getTable("delSO");
                if (null != userdt && (null != addSOdt || null != delSOdt)) {
                    try {
                        for (DataRecord dr : userdt) {
                            this.log.info((Object)("userID:" + dr.getInt("userID") + " curUser.id:" + this.curUser.id));
                            if (dr.getInt("userID") != this.curUser.id) continue;
                            Map<String, String> soidMap = this.soidAndSubResOIDListMap.get("soidMap");
                            if (null != addSOdt) {
                                for (DataRecord sodr : addSOdt) {
                                    this.log.info((Object)("add sodr.get(SOID):" + sodr.get("SOID")));
                                    soidMap.put(sodr.get("SOID"), sodr.get("SOID"));
                                }
                            }
                            if (null == delSOdt) break;
                            for (DataRecord sodr : delSOdt) {
                                this.log.info((Object)("del sodr.get(SOID):" + sodr.get("SOID")));
                                soidMap.remove(sodr.get("SOID"));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)"get table info failure for userTable or addSO or delSO, so clear domian.");
                        this.isRefershDomain = true;
                        this.soidAndSubResOIDListMap.clear();
                        this.cmdidResultMap.clear();
                    }
                } else {
                    this.log.error((Object)"no additional data for security object created and deleted event, so clear domian.");
                    this.isRefershDomain = true;
                    this.soidAndSubResOIDListMap.clear();
                    this.cmdidResultMap.clear();
                }
            }
            if (eventType.equals("3:11") || eventType.equals("3:24") || eventType.equals("3:8") || eventType.equals("3:6") || eventType.equals("5:2") || eventType.equals("3:2")) {
                this.isRefershDomain = true;
                this.soidAndSubResOIDListMap.clear();
                this.cmdidResultMap.clear();
            }
        }
        if (this.isNeedClearRights(event, eventType) && !isSecObjCreDelEvt) {
            this.log.info((Object)("isSecObjCreDelEvt:" + isSecObjCreDelEvt));
            RightCache.getInstance().clear();
            SetRightCache.getInstance().clear();
        }
        if (eventType.equals("3:8")) {
            this.isAdminGroupUser = SessionService.getInstance().isAdminGroupUser(this.curUser.name);
            this.isSecurityMgrGroupUser = SessionService.getInstance().isSecurityMgrGroup(this.curUser.id);
        }
        if (eventType.equals("3:8") || event.getType().equals("3:6") || eventType.equals("3:2")) {
            this.hasLoadedAllResRightFlag = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getHasAllResRight() {
        if (!this.hasLoadedAllResRightFlag) {
            Object object = loadAllResRightLock;
            synchronized (object) {
                if (!this.hasLoadedAllResRightFlag) {
                    this.hasAllResRight = RpcInvoker.getInstance().hasAllResRight();
                    this.hasLoadedAllResRightFlag = true;
                }
            }
        }
        return this.hasAllResRight;
    }

    private boolean isCurrentUserInvolved(RpcEvent event) {
        RpcMessage message = event.getMessage();
        String desc = message.getString("Description");
        if (desc.equals("user changed")) {
            DataTable userInfoTable = message.getTable("ADDITIONAL");
            for (DataRecord userInfo : userInfoTable) {
                if (userInfo.getInt("userid") != this.curUser.id) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNeedClearRights(RpcEvent event, String eventType) {
        String oprType = event.getMessage().getString("Domain");
        return !(eventType.equals("3:6") ? "moveSubnet".equals(oprType) || "moveNE".equals(oprType) : eventType.equals("3:2") && ("moveSubnet".equals(oprType) || "moveNE".equals(oprType)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> getSoidAndSubResOIDListMap() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRefershDomain) {
                try {
                    this.soidAndSubResOIDListMap = RpcInvoker.getInstance().getAllSOIDAndSubResOIDByUserID(this.curUser.id);
                    if (this.soidAndSubResOIDListMap.isEmpty()) {
                        this.soidAndSubResOIDListMap.put("soidMap", null);
                    }
                    this.isRefershDomain = false;
                }
                catch (Exception e) {
                    this.log.error((Object)"", (Throwable)e);
                }
            }
        }
        return this.soidAndSubResOIDListMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUserSOManaged(String soid) {
        if (this.hasAllDevMgrRight()) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            Map<String, String> soidMap = this.getSoidAndSubResOIDListMap().get("soidMap");
            if (soidMap != null) {
                String fdn = EmfProductResourceIDConvert.getInstance().resourceId2Fdn(soid);
                if (soidMap.get("*") != null || soidMap.get(fdn) != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkUserSOManagedForTopo(String soid) {
        if (this.checkUserSOManaged(soid)) {
            return true;
        }
        this.isRefershDomain = true;
        this.soidAndSubResOIDListMap.clear();
        return this.checkUserSOManaged(soid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] checkUserSOManaged(String[] soidArray) {
        boolean[] retArray = new boolean[soidArray.length];
        for (int i = 0; i < soidArray.length; ++i) {
            retArray[i] = true;
        }
        if (this.hasAllDevMgrRight()) {
            return retArray;
        }
        Object object = this.lock;
        synchronized (object) {
            Map<String, String> soidMap = this.getSoidAndSubResOIDListMap().get("soidMap");
            if (soidMap == null) {
                for (int i = 0; i < soidArray.length; ++i) {
                    retArray[i] = false;
                }
                return retArray;
            }
            for (int i = 0; i < soidArray.length; ++i) {
                retArray[i] = soidMap.get(soidArray[i]) != null;
            }
        }
        return retArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUserSubResManaged(String phyResOID) {
        if (this.hasAllDevMgrRight()) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            Map<String, String> phySubResOIDMap = this.getSoidAndSubResOIDListMap().get("phySubResOIDMap");
            if (phySubResOIDMap == null) {
                return false;
            }
            String deviceID = GlobalUtil.dealSplitToGlobal(phyResOID, EmfSecurityUtil.getFdnDivideSymbolEx())[0];
            if (this.checkUserSOManaged(deviceID)) {
                if (phySubResOIDMap.containsKey(deviceID)) {
                    return false;
                }
                boolean hasRes = false;
                Set<String> keySet = phySubResOIDMap.keySet();
                for (String key : keySet) {
                    int index = key.indexOf(deviceID);
                    if (index != 0 && index != 3) continue;
                    hasRes = true;
                    break;
                }
                if (!hasRes) {
                    return true;
                }
                if (phySubResOIDMap.get(phyResOID) != null) {
                    return true;
                }
                keySet = phySubResOIDMap.keySet();
                for (String oid : keySet) {
                    String ch;
                    int find2;
                    int find1 = oid.indexOf(phyResOID);
                    if (find1 == 0 || find1 == 3) {
                        return true;
                    }
                    if (!phySubResOIDMap.get(oid).equals("-1") || (find2 = phyResOID.indexOf(oid)) != 0 || (ch = this.getChar(phyResOID, oid.length())) == null || !ch.equals(EmfSecurityUtil.getFdnDivideSymbol())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String getChar(String str, int p) {
        try {
            return String.valueOf(str.charAt(p));
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] checkUserSubResManaged(String[] phyResOIDArray) {
        boolean[] retArray = new boolean[phyResOIDArray.length];
        for (int i = 0; i < phyResOIDArray.length; ++i) {
            retArray[i] = true;
        }
        if (this.hasAllDevMgrRight()) {
            return retArray;
        }
        Object object = this.lock;
        synchronized (object) {
            Map<String, String> phySubResOIDMap = this.getSoidAndSubResOIDListMap().get("phySubResOIDMap");
            if (phySubResOIDMap == null) {
                for (int i = 0; i < phyResOIDArray.length; ++i) {
                    retArray[i] = false;
                }
                return retArray;
            }
            Set<String> keySet = phySubResOIDMap.keySet();
            for (int i = 0; i < phyResOIDArray.length; ++i) {
                if (phySubResOIDMap.get(phyResOIDArray[i]) != null) {
                    retArray[i] = true;
                    continue;
                }
                for (String oid : keySet) {
                    if (oid.indexOf(phyResOIDArray[i]) != 0 && phyResOIDArray[i].indexOf(oid) != 0) continue;
                    retArray[i] = true;
                }
                retArray[i] = false;
            }
        }
        return retArray;
    }

    public boolean isSubmapManagable(String strSubmapID) {
        try {
            List<String> subnetDNByUser = RightCache.getInstance().getSubnetDeviceSetRight(this.curUser.getId());
            for (int i = 0; i < subnetDNByUser.size(); ++i) {
                if (!subnetDNByUser.get(i).equalsIgnoreCase(strSubmapID)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"RightCache getSubnetDeviceSetRight is failure!");
        }
        return false;
    }

    public int[] checkRight(RightInfo[] rightInfos, int userId) throws Exception {
        int[] result = new int[rightInfos.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 0;
        }
        SetRightCache.getInstance().checkloadGroupSetRights(userId);
        result = this.checkRigthCenter.checkRight(userId, rightInfos);
        return result;
    }

    public int[] checkRight(RightInfo[] rightInfos) throws Exception {
        return this.checkRight(rightInfos, this.curUser.id);
    }

    public boolean specalHandle(RpcEvent event) {
        return this.handle(event);
    }
}

