/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.iview.util.log.IviewLogger;

public class TypePolicy
implements ICheckRightPolicy {
    private IviewLogger log = TraceProxy.getLogger(TypePolicy.class);
    private static final int PRIORITY = 7;
    private RightCache tool = RightCache.getInstance();

    public void setSetRightExtendTool(RightCache _tool) {
        this.tool = _tool;
    }

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            for (int i = 0; i < rightInfos.length; ++i) {
                if (checkResult[i] != -1) continue;
                checkResult[i] = this.check(rightInfos[i], userID);
            }
        }
        catch (Exception e) {
            this.log.info((Object)("TypePolicy | check | check right fail. , userID =" + userID));
            this.log.error((Object)e);
            return this.getCheckResult(0, rightInfos, checkResult);
        }
        return checkResult;
    }

    private int check(RightInfo info, int userID) throws Exception {
        if (this.tool.isContain(userID, info.objectClassName, info.getOperation())) {
            return 1;
        }
        return -1;
    }

    private int[] getCheckResult(int result, RightInfo[] rightInfos, int[] checkResult) {
        for (int i = 0; i < rightInfos.length; ++i) {
            checkResult[i] = result;
        }
        return checkResult;
    }

    @Override
    public int getPriority() {
        return 7;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 7 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 7;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 7 == ((TypePolicy)obj).getPriority();
    }
}

