/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.checkright.cache.SetRight;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.imap.security.checkright.cache.SubnetIDnDNStruct;
import com.swimap.imap.security.checkright.cache.SubnetTempCache;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.List;

public class SubnetDevSetPolicy
implements ICheckRightPolicy {
    private IviewLogger log = TraceProxy.getLogger(SubnetDevSetPolicy.class);
    private static final int PRIORITY = 9;
    private SetRightCache toolSetRight = SetRightCache.getInstance();
    private RightCache toolRight = RightCache.getInstance();

    public void setSetRightExtendTool(RightCache _tool) {
        this.toolRight = _tool;
    }

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            int[] groupIDs = this.toolRight.getUserGroupIDs(userID);
            SetRightCache.getInstance().checkloadGroupSetRights(userID);
            block2: for (int i = 0; i < rightInfos.length; ++i) {
                boolean iPass = false;
                ArrayList<Integer> subDeviceSetList = new ArrayList<Integer>();
                if (checkResult[i] != -1 || !this.isMORight(rightInfos[i]) || !this.check(userID, rightInfos[i].objectID, subDeviceSetList)) continue;
                for (int j = 0; j < groupIDs.length; ++j) {
                    SetRight setRight = this.toolSetRight.getGroupSetRight(groupIDs[j]);
                    int[] devIDs = setRight.devSetIDs;
                    int[] opeIDs = setRight.opeSetIDs;
                    for (int l = 0; l < opeIDs.length; ++l) {
                        if (!subDeviceSetList.contains(devIDs[l]) && !"NE=1".equals(rightInfos[i].objectID) && !"1".equals(rightInfos[i].objectID) && !"".equals(rightInfos[i].objectID) || !SetRightCache.getInstance().isInThisOprSet(rightInfos[i], opeIDs[l])) continue;
                        checkResult[i] = 1;
                        iPass = true;
                        break;
                    }
                    if (iPass) continue block2;
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)("SubnetDevSetPolicy | check | check right fail. , userID =" + userID));
            this.log.error((Object)"", (Throwable)e);
            return this.getCheckResult(0, rightInfos, checkResult);
        }
        return checkResult;
    }

    @Override
    public int getPriority() {
        return 9;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 9 < o.getPriority() ? -1 : 1;
    }

    private boolean isMORight(RightInfo right) {
        return "MANAGED_OBJECT".equals(right.getObjectClassType());
    }

    public boolean check(int userID, String oid, List<Integer> subDeviceSetList) throws Exception {
        if (oid == null || "".equals(oid.trim()) || oid.equals("/")) {
            this.log.info((Object)("Invalid oid. oid=" + oid));
            return false;
        }
        if ("NE=1".equals(oid) || "1".equals(oid) || "".equals(oid)) {
            return true;
        }
        List<String> subnetDNByUser = this.toolRight.getSubnetDeviceSetRight(userID);
        if (subnetDNByUser == null || subnetDNByUser.size() == 0) {
            return false;
        }
        if (subnetDNByUser.contains("/")) {
            return true;
        }
        SubnetIDnDNStruct struct = SubnetTempCache.getInstance().getSubnetDeviceSetStruct(oid);
        String[] allParentRecursion = struct.subnetDNs;
        subDeviceSetList.clear();
        subDeviceSetList.addAll(struct.subnetDeviceSetIds);
        for (int i = 0; i < allParentRecursion.length; ++i) {
            if (!subnetDNByUser.contains(allParentRecursion[i])) continue;
            return true;
        }
        return false;
    }

    private int[] getCheckResult(int result, RightInfo[] rightInfos, int[] checkResult) {
        for (int i = 0; i < rightInfos.length; ++i) {
            checkResult[i] = result;
        }
        return checkResult;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 9;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 9 == ((SubnetDevSetPolicy)obj).getPriority();
    }
}

