/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.client.base.SessionService;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.iview.util.log.IviewLogger;

public class SMGroupPolicy
implements ICheckRightPolicy {
    private static final int PRIORITY = 3;
    private IviewLogger log = TraceProxy.getLogger(SMGroupPolicy.class);

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            if (SessionService.getInstance().isSecurityMgrGroup(userID)) {
                return this.getCheckResult(1, rightInfos, checkResult);
            }
            return checkResult;
        }
        catch (Exception e) {
            this.log.info((Object)("SMGroupPolicy | check | check right fail. , userID =" + userID));
            this.log.error((Object)e);
            return this.getCheckResult(0, rightInfos, checkResult);
        }
    }

    private int[] getCheckResult(int result, RightInfo[] rightInfos, int[] checkResult) {
        for (int i = 0; i < rightInfos.length; ++i) {
            if (checkResult[i] != -1 || !this.isSecurityAppRight(rightInfos[i]) && !this.isVisibleRight(rightInfos[i])) continue;
            checkResult[i] = result;
        }
        return checkResult;
    }

    private boolean isSecurityAppRight(RightInfo right) {
        return right.objectClassType.equals("APPLICATION") && right.objectClassName.equals("SecurityApplication");
    }

    private boolean isVisibleRight(RightInfo right) {
        return right.objectClassType.equals("MANAGED_OBJECT") && "MANAGED_RIGHT".equals(right.operation);
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 3 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 3;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 3 == ((SMGroupPolicy)obj).getPriority();
    }
}

