/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Set;

public class OperationCommandPolicy
implements ICheckRightPolicy {
    private static final int PRIORITY = 10;
    private IviewLogger log = TraceProxy.getLogger(OperationCommandPolicy.class);

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            return this.check(checkResult, this.covert2RightKey(rightInfos), RightCache.getInstance().getOperationCommand());
        }
        catch (Exception e) {
            this.log.info((Object)("OperationCommandPolicy | check | check right fail., userID =" + userID));
            this.log.error((Object)e);
            return this.getCheckResult(0, checkResult);
        }
    }

    private int[] check(int[] checkResult, int[] right, Set<Integer> operationCommandSet) {
        for (int i = 0; i < right.length; ++i) {
            if (checkResult[i] != -1) continue;
            checkResult[i] = operationCommandSet.contains(right[i]) ? 1 : 0;
        }
        return checkResult;
    }

    private int[] covert2RightKey(RightInfo[] rightInfos) throws Exception {
        int[] rightArray = new int[rightInfos.length];
        for (int i = 0; i < rightArray.length; ++i) {
            rightArray[i] = Integer.valueOf(rightInfos[i].operation);
        }
        return rightArray;
    }

    private int[] getCheckResult(int result, int[] checkResult) {
        for (int i = 0; i < checkResult.length; ++i) {
            checkResult[i] = result;
        }
        return checkResult;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 10 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 10;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 10 == ((OperationCommandPolicy)obj).getPriority();
    }
}

