/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.checkright.cache.SetRight;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.iview.util.log.IviewLogger;

public class DevSetOprSetPolicy
implements ICheckRightPolicy {
    private static final String MANAGED_RIGHT = "MANAGED_RIGHT";
    private IviewLogger log = TraceProxy.getLogger(DevSetOprSetPolicy.class);
    private static final int PRIORITY = 11;

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            for (int i = 0; i < rightInfos.length; ++i) {
                if (checkResult[i] != -1) continue;
                checkResult[i] = this.check(rightInfos[i], userID);
            }
        }
        catch (Exception e) {
            this.log.info((Object)("check right fail., userID =" + userID));
            this.log.error((Object)e);
            return this.getCheckResult(0, checkResult);
        }
        return checkResult;
    }

    private int check(RightInfo rightInfo, int userID) throws Exception {
        SetRightCache.getInstance().loadDevSetsByUser(userID);
        int[] groupIds = RightCache.getInstance().getUserGroupIDs(userID);
        boolean isApp = this.isAppRight(rightInfo);
        SetRight setRight = null;
        int[] devSetIds = null;
        int[] oprSetIds = null;
        for (int gId : groupIds) {
            setRight = SetRightCache.getInstance().getGroupSetRight(gId);
            devSetIds = setRight.devSetIDs;
            oprSetIds = setRight.opeSetIDs;
            for (int i = 0; i < devSetIds.length; ++i) {
                if (isApp) {
                    if (devSetIds[i] != 0 || !SetRightCache.getInstance().isInThisOprSet(rightInfo, oprSetIds[i])) continue;
                    return 1;
                }
                if (devSetIds[i] == 0) continue;
                String oid = rightInfo.objectID;
                boolean isInDevSet = SetRightCache.getInstance().devSetContainsID(devSetIds[i], oid);
                if (!(this.isVisibleRight(rightInfo) ? isInDevSet : (isInDevSet || this.isSpecialOid(oid)) && oprSetIds[i] != 0 && SetRightCache.getInstance().isInThisOprSet(rightInfo, oprSetIds[i]))) continue;
                return 1;
            }
        }
        return -1;
    }

    private boolean isSpecialOid(String oid) {
        return "NE=1".equals(oid) || "1".equals(oid) || "".equals(oid);
    }

    private boolean isVisibleRight(RightInfo rightInfo) {
        return MANAGED_RIGHT.equals(rightInfo.operation);
    }

    private boolean isAppRight(RightInfo right) {
        return "APPLICATION".equals(right.getObjectClassType());
    }

    private int[] getCheckResult(int result, int[] checkResult) {
        for (int i = 0; i < checkResult.length; ++i) {
            if (checkResult[i] != -1) continue;
            checkResult[i] = result;
        }
        return checkResult;
    }

    @Override
    public int getPriority() {
        return 11;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 11 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 11;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 11 == ((DevSetOprSetPolicy)obj).getPriority();
    }
}

