/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.AccBit;
import com.swimap.imap.security.checkright.cache.Right;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommonGroupPolicy
implements ICheckRightPolicy {
    private static final int PRIORITY = 12;
    private IviewLogger log = TraceProxy.getLogger(CommonGroupPolicy.class);
    private RightCache cache = RightCache.getInstance();

    public void setRightCache(RightCache _cache) {
        this.cache = _cache;
    }

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            return this.check(checkResult, this.covert2RightKey(rightInfos, checkResult), this.cache.getUserRight(userID));
        }
        catch (Exception e) {
            this.log.info((Object)("CommonGroupPolicy | check | check right fail., userID =" + userID));
            this.log.error((Object)"", (Throwable)e);
            return this.getCheckResult(0, checkResult);
        }
    }

    private int[] check(int[] checkResult, RightKey[] right, List<Map<String, Right>> userRightList) {
        for (int i = 0; i < right.length; ++i) {
            if (checkResult[i] != -1) continue;
            checkResult[i] = this.check(right[i], userRightList);
        }
        return checkResult;
    }

    public int check(RightKey right, List<Map<String, Right>> userRightList) {
        for (Map<String, Right> map : userRightList) {
            if (!AccBit.isPass(right.bitSite, this.getRightAccessBit(map, right.key))) continue;
            return 1;
        }
        return -1;
    }

    private List<AccBit> getRightAccessBit(Map<String, Right> map, String key) {
        Right tmp;
        List<AccBit> accBit = new ArrayList<AccBit>();
        if (map != null && !map.isEmpty() && (tmp = map.get(key)) != null) {
            accBit = tmp.accBitList;
        }
        return accBit;
    }

    private RightKey[] covert2RightKey(RightInfo[] rightInfos, int[] checkResult) throws Exception {
        RightKey[] rightArray = new RightKey[rightInfos.length];
        for (int i = 0; i < rightArray.length; ++i) {
            if (checkResult[i] != -1) continue;
            int type = RightInfo.getObjectClassTypeID(rightInfos[i].objectClassType);
            String className = rightInfos[i].objectClassName;
            Right _right = new Right(type, className, rightInfos[i].objectID);
            rightArray[i] = new RightKey();
            rightArray[i].key = _right.so.getKey();
            rightArray[i].bitSite = this.cache.getBitSite(type, className, rightInfos[i].operation);
        }
        return rightArray;
    }

    public RightKey covert2RightKey(RightInfo rightInfo) throws Exception {
        RightKey rightKey = new RightKey();
        int type = RightInfo.getObjectClassTypeID(rightInfo.objectClassType);
        String className = rightInfo.objectClassName;
        Right _right = new Right(type, className, rightInfo.objectID);
        rightKey = new RightKey();
        rightKey.key = _right.so.getKey();
        rightKey.bitSite = this.cache.getBitSite(type, className, rightInfo.operation);
        return rightKey;
    }

    private int[] getCheckResult(int result, int[] checkResult) {
        for (int i = 0; i < checkResult.length; ++i) {
            if (checkResult[i] != -1) continue;
            checkResult[i] = result;
        }
        return checkResult;
    }

    @Override
    public int getPriority() {
        return 12;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 12 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 12;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 12 == ((CommonGroupPolicy)obj).getPriority();
    }

    protected class RightKey {
        public String key;
        public int bitSite;

        protected RightKey() {
        }
    }
}

