/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.imap.security.checkright.cache.UserGroupManageSOMgr;
import com.swimap.iview.util.log.IviewLogger;

public class AllDomainDevSetPolicy
implements ICheckRightPolicy {
    private IviewLogger log = TraceProxy.getLogger(AllDomainDevSetPolicy.class);
    private static final int PRIORITY = 4;
    private RightCache toolRight = RightCache.getInstance();

    public void setSetRightExtendTool(RightCache _tool) {
        this.toolRight = _tool;
    }

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            int[] groupIds = RightCache.getInstance().getUserGroupIDs(userID);
            RightCache.getInstance().initTypeCache(userID);
            block2: for (int i = 0; i < rightInfos.length; ++i) {
                if (checkResult[i] != -1 || this.isAppRight(rightInfos[i])) continue;
                if (this.isVisibleRight(rightInfos[i])) {
                    checkResult[i] = 1;
                    continue;
                }
                for (int gId : groupIds) {
                    if (!UserGroupManageSOMgr.getInstance().hasManagedRight(gId, rightInfos[i].getObjectID(), rightInfos[i].getObjectClassName()) || !SetRightCache.getInstance().hasAllDomainSetBindTheRight(gId, rightInfos[i])) continue;
                    checkResult[i] = 1;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)("SubnetDevSetPolicy | check | check right fail. , userID =" + userID));
            this.log.error((Object)"", (Throwable)e);
            return this.getCheckResult(0, rightInfos, checkResult);
        }
        return checkResult;
    }

    private boolean isAppRight(RightInfo right) {
        return "APPLICATION".equals(right.getObjectClassType());
    }

    private boolean isVisibleRight(RightInfo right) throws Exception {
        int accBitSite = this.toolRight.getBitSite(RightInfo.getObjectClassTypeID(right.objectClassType), right.objectClassName, right.operation);
        return accBitSite == 1;
    }

    private int[] getCheckResult(int result, RightInfo[] rightInfos, int[] checkResult) {
        for (int i = 0; i < rightInfos.length; ++i) {
            checkResult[i] = result;
        }
        return checkResult;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 4;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 4 == ((AllDomainDevSetPolicy)obj).getPriority();
    }

    @Override
    public int getPriority() {
        return 4;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 4 < o.getPriority() ? -1 : 1;
    }
}

