/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.checkright.cache.SetRight;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.iview.util.log.IviewLogger;

public class AllDeviceSetPolicy
implements ICheckRightPolicy {
    private IviewLogger log = TraceProxy.getLogger(AllDeviceSetPolicy.class);
    private static final int PRIORITY = 6;
    private RightCache cache = RightCache.getInstance();
    private SetRightCache tool = SetRightCache.getInstance();

    public void setSetRightExtendTool(SetRightCache _tool) {
        this.tool = _tool;
    }

    public void setRightCache(RightCache _cache) {
        this.cache = _cache;
    }

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            int[] groupIDs = this.cache.getUserGroupIDs(userID);
            SetRightCache.getInstance().checkloadGroupSetRights(userID);
            for (int i = 0; i < rightInfos.length; ++i) {
                if (checkResult[i] != -1 || !this.isDeviceRight(rightInfos[i])) continue;
                checkResult[i] = this.check(rightInfos[i], groupIDs);
            }
        }
        catch (Exception e) {
            this.log.info((Object)("AllDeviceSetPolicy | check | check right fail. , userID = " + userID));
            this.log.error((Object)"", (Throwable)e);
            return this.getCheckResult(0, rightInfos, checkResult);
        }
        return checkResult;
    }

    private int check(RightInfo rightInfo, int[] groupIDs) throws Exception {
        boolean isVisibleRight = this.isVisibleRight(rightInfo);
        for (int groupID : groupIDs) {
            SetRight setRight = this.tool.getGroupSetRight(groupID);
            if (isVisibleRight && this.tool.hasAllObjectSet(setRight.devSetIDs)) {
                return 1;
            }
            if (!this.tool.hasAllObjectSetBindTheRight(groupID, rightInfo)) continue;
            return 1;
        }
        return -1;
    }

    private int[] getCheckResult(int result, RightInfo[] rightInfos, int[] checkResult) {
        for (int i = 0; i < rightInfos.length; ++i) {
            checkResult[i] = result;
        }
        return checkResult;
    }

    private boolean isVisibleRight(RightInfo right) throws Exception {
        int accBitSite = this.cache.getBitSite(RightInfo.getObjectClassTypeID(right.objectClassType), right.objectClassName, right.operation);
        return accBitSite == 1;
    }

    private boolean isDeviceRight(RightInfo right) {
        return "MANAGED_OBJECT".equals(right.getObjectClassType());
    }

    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 6 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 6;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 6 == ((AllDeviceSetPolicy)obj).getPriority();
    }
}

