/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.iview.util.log.IviewLogger;
import java.util.List;

public class AllDevOperationSetPolicy
implements ICheckRightPolicy {
    private IviewLogger log = TraceProxy.getLogger(AllDevOperationSetPolicy.class);
    private static final int PRIORITY = 8;
    private SetRightCache tool = SetRightCache.getInstance();

    public void setSetRightExtendTool(SetRightCache _tool) {
        this.tool = _tool;
    }

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            List<Integer> devsetIds = this.tool.getContainAllMOOperationSetDevSetIDs(userID);
            if (devsetIds == null || devsetIds.size() == 0) {
                return checkResult;
            }
            for (int i = 0; i < rightInfos.length; ++i) {
                if (checkResult[i] != -1 || !this.isDeviceRight(rightInfos[i])) continue;
                checkResult[i] = this.check(rightInfos[i], devsetIds);
            }
        }
        catch (Exception e) {
            this.log.info((Object)("AllDevOperationSetPolicy | check | check right fail. , userID =" + userID));
            this.log.error((Object)"", (Throwable)e);
            return this.getCheckResult(0, rightInfos, checkResult);
        }
        return checkResult;
    }

    private int check(RightInfo info, List<Integer> devsetIds) {
        int result;
        block3: {
            result = -1;
            try {
                if (devsetIds == null || devsetIds.size() <= 0) break block3;
                for (Integer id : devsetIds) {
                    if (!this.tool.devSetContainsID(id, info.objectID)) continue;
                    result = 1;
                    break;
                }
            }
            catch (Exception e) {
                this.log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    private boolean isDeviceRight(RightInfo right) {
        return "MANAGED_OBJECT".equals(right.getObjectClassType());
    }

    private int[] getCheckResult(int result, RightInfo[] rightInfos, int[] checkResult) {
        for (int i = 0; i < rightInfos.length; ++i) {
            checkResult[i] = result;
        }
        return checkResult;
    }

    @Override
    public int getPriority() {
        return 8;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 8 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 8;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 8 == ((AllDevOperationSetPolicy)obj).getPriority();
    }
}

