/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.iview.util.log.IviewLogger;

public class AllAppOperationSetPolicy
implements ICheckRightPolicy {
    private IviewLogger log = TraceProxy.getLogger(AllAppOperationSetPolicy.class);
    private static final int PRIORITY = 5;
    private SetRightCache tool = SetRightCache.getInstance();
    private RightCache cache = RightCache.getInstance();

    public void setSetRightExtendTool(SetRightCache _tool) {
        this.tool = _tool;
    }

    public void setRightCache(RightCache _cache) {
        this.cache = _cache;
    }

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            int[] groupIDs = this.cache.getUserGroupIDs(userID);
            SetRightCache.getInstance().checkloadGroupSetRights(userID);
            block2: for (int i = 0; i < rightInfos.length; ++i) {
                if (checkResult[i] != -1 || !this.isAppRight(rightInfos[i]) || this.isSecurityAppRight(rightInfos[i])) continue;
                for (int groupID : groupIDs) {
                    if (!this.tool.hasAllAppOprSetRight(groupID)) continue;
                    checkResult[i] = 1;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)("AllAppOperationSetPolicy | check | check right fail. , userID =" + userID));
            this.log.error((Object)"", (Throwable)e);
            return this.getCheckResult(0, rightInfos, checkResult);
        }
        return checkResult;
    }

    private boolean isAppRight(RightInfo right) {
        return "APPLICATION".equals(right.getObjectClassType());
    }

    private int[] getCheckResult(int result, RightInfo[] rightInfos, int[] checkResult) {
        for (int i = 0; i < rightInfos.length; ++i) {
            checkResult[i] = result;
        }
        return checkResult;
    }

    private boolean isSecurityAppRight(RightInfo right) {
        return "SecurityApplication".equals(right.objectClassName);
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 5 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 5;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 5 == ((AllAppOperationSetPolicy)obj).getPriority();
    }
}

