/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.main.EmfUserManager;
import com.swimap.iview.util.log.IviewLogger;

public class AdminPolicy
implements ICheckRightPolicy {
    private static final int PRIORITY = 1;
    private IviewLogger log = TraceProxy.getLogger(AdminPolicy.class);

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            if (EmfUserManager.getInstance().isAdmin(userID)) {
                return this.getCheckResult(1, checkResult);
            }
            return checkResult;
        }
        catch (Exception e) {
            this.log.info((Object)("AdminPolicy | check | check right fail., userID =" + userID));
            this.log.error((Object)e);
            return this.getCheckResult(0, checkResult);
        }
    }

    private int[] getCheckResult(int result, int[] checkResult) {
        for (int i = 0; i < checkResult.length; ++i) {
            checkResult[i] = result;
        }
        return checkResult;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 1 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 1;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 1 == ((AdminPolicy)obj).getPriority();
    }
}

