/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.policy;

import com.swimap.external.sm.client.base.SessionService;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.ICheckRightPolicy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.main.EmfUserManager;
import com.swimap.iview.util.log.IviewLogger;

public class AdminGroupPolicy
implements ICheckRightPolicy {
    private static final int PRIORITY = 2;
    private IviewLogger log = TraceProxy.getLogger(AdminGroupPolicy.class);

    @Override
    public int[] check(int userID, RightInfo[] rightInfos, int[] checkResult) {
        try {
            if (SessionService.getInstance().isAdminGroupUser(EmfUserManager.getInstance().getUsername())) {
                return this.getCheckResult(1, rightInfos, checkResult);
            }
            return checkResult;
        }
        catch (Exception e) {
            this.log.info((Object)("AdminGroupPolicy | check | check right fail. , userID = " + userID));
            this.log.error((Object)"", (Throwable)e);
            return this.getCheckResult(0, rightInfos, checkResult);
        }
    }

    private int[] getCheckResult(int result, RightInfo[] rightInfos, int[] checkResult) {
        for (int i = 0; i < rightInfos.length; ++i) {
            if (checkResult[i] != -1 || this.isSecurityAppRight(rightInfos[i]) || !this.isExistRight(rightInfos[i])) continue;
            checkResult[i] = result;
        }
        return checkResult;
    }

    private boolean isExistRight(RightInfo info) {
        try {
            return RightCache.getInstance().isExistStaticRight(info);
        }
        catch (Exception e) {
            this.log.info((Object)("AdminGroupPolicy | isExistRight | it is not exist right. type = " + info.objectClassType + " classname = " + info.objectClassName + " oid = " + info.objectID + " operation = " + info.operation));
            return false;
        }
    }

    private boolean isSecurityAppRight(RightInfo right) {
        return right.objectClassType.equals("APPLICATION") && right.objectClassName.equals("SecurityApplication");
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public int compareTo(ICheckRightPolicy o) {
        return 2 < o.getPriority() ? -1 : 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 2;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return 2 == ((AdminGroupPolicy)obj).getPriority();
    }
}

