/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.cache;

import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.checkright.cache.SetRight;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.imap.security.checkright.cache.SubnetIDnDNStruct;
import com.swimap.imap.security.checkright.cache.SubnetTempCache;
import java.util.Set;

public class UserGroupManageSOMgr {
    private static final String MANAGED_RIGHT = "MANAGED_RIGHT";
    private static final String SPLIT = ":";
    private static final int TYPE = 1;
    private static UserGroupManageSOMgr instance = new UserGroupManageSOMgr();

    public static UserGroupManageSOMgr getInstance() {
        return instance;
    }

    public boolean hasManagedRight(int groupId, String oid, String className) throws Exception {
        if ("NE=1".equals(oid) || "1".equals(oid) || "".equals(oid)) {
            return true;
        }
        return this.hasDeviceSetRight(groupId, className, oid) || this.hasDeviceTypeRight(groupId, className) || this.hasSubnetDeviceSetRight(groupId, oid) || this.hasDeviceRight(groupId, oid, className);
    }

    private boolean hasDeviceSetRight(int groupId, String className, String oid) throws Exception {
        SetRight setRight = SetRightCache.getInstance().getGroupSetRight(groupId);
        if (setRight != null) {
            int[] devSetIDs;
            for (int id : devSetIDs = setRight.devSetIDs) {
                if (id == 0 || !SetRightCache.getInstance().devSetContainsID(id, oid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasDeviceTypeRight(int gourpId, String className) throws Exception {
        return RightCache.getInstance().isGroupContainsTypeRight(gourpId, className, MANAGED_RIGHT);
    }

    private boolean hasSubnetDeviceSetRight(int groupId, String oid) throws Exception {
        SubnetIDnDNStruct struct = SubnetTempCache.getInstance().getSubnetDeviceSetStruct(oid);
        String[] allParentRecursion = struct.subnetDNs;
        Set<String> subnetDevSetOids = RightCache.getInstance().getGroupSubnetDeviceSetDNs(groupId);
        for (int i = 0; i < allParentRecursion.length; ++i) {
            if (!subnetDevSetOids.contains(allParentRecursion[i])) continue;
            return true;
        }
        return false;
    }

    private boolean hasDeviceRight(int groupId, String oid, String className) throws Exception {
        return RightCache.getInstance().isGroupHasManagedRight(groupId, this.getKey(className, oid));
    }

    private String getKey(String className, String oid) {
        StringBuilder sb = new StringBuilder();
        sb.append(1);
        sb.append(SPLIT);
        sb.append(className);
        sb.append(SPLIT);
        sb.append(oid);
        return sb.toString();
    }
}

