/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.cache;

import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.AccBit;
import com.swimap.imap.security.checkright.cache.RightCache;
import java.util.ArrayList;
import java.util.List;

public class TypeRight {
    private String className;
    private List<AccBit> accBits = new ArrayList<AccBit>();
    private int soClassType;

    public TypeRight(int type, String className) {
        this.soClassType = type;
        this.className = className;
    }

    public boolean containsOprId(RightInfo info) throws Exception {
        int type = RightInfo.getObjectClassTypeID(info.getObjectClassType());
        int bitSite = RightCache.getInstance().getBitSite(type, info.getObjectClassName(), info.getOperation());
        return AccBit.isPass(bitSite, this.accBits);
    }

    public int getClassType() {
        return this.soClassType;
    }

    public String getClassName() {
        return this.className;
    }

    public String getKey() {
        return this.soClassType + ":" + this.className;
    }

    public List<AccBit> getAccBits() {
        return this.accBits;
    }

    public void merge(TypeRight other) {
        if (other == null) {
            return;
        }
        AccBit.mergeAccBitsList(this.accBits, other.getAccBits());
    }

    public void addRight(int accBitSite) {
        this.addBitSiteToList(this.accBits, accBitSite);
    }

    private void addBitSiteToList(List<AccBit> accBit, int bitSite) {
        boolean found = false;
        for (AccBit bit : accBit) {
            found = bit.addBit(bitSite);
        }
        if (!found) {
            AccBit tmp = new AccBit(new int[4], AccBit.segment(bitSite));
            tmp.addBit(bitSite);
            accBit.add(tmp);
        }
    }
}

