/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.cache;

import com.swimap.external.sm.client.base.SessionService;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.AccBit;
import com.swimap.imap.security.checkright.cache.IRightChangedEventListener;
import com.swimap.imap.security.checkright.cache.IRightTimerListener;
import com.swimap.imap.security.checkright.cache.Right;
import com.swimap.imap.security.checkright.cache.RightCache;
import com.swimap.imap.security.checkright.cache.RightProxy;
import com.swimap.imap.security.checkright.cache.SetRight;
import com.swimap.imap.security.checkright.cache.TypeRight;
import com.swimap.imap.security.main.EmfUserManager;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SetRightCache
implements IRightTimerListener,
IRightChangedEventListener {
    private static IviewLogger log = TraceProxy.getLogger(SetRightCache.class);
    private RightProxy proxy = RightProxy.getInstance();
    private static SetRightCache instance = new SetRightCache();
    private final Map<Integer, SetRight> group_setright_cache = new ConcurrentHashMap<Integer, SetRight>();
    private final Map<Integer, Map<String, TypeRight>> opeset_operations_cache = new ConcurrentHashMap<Integer, Map<String, TypeRight>>();
    private Map<Integer, Set<Integer>> opeset_subset_cache = new ConcurrentHashMap<Integer, Set<Integer>>();
    private Map<Integer, Set<Integer>> devSet_subset_cache = new ConcurrentHashMap<Integer, Set<Integer>>();
    private Map<Integer, Set<String>> devSet_members_cache = new ConcurrentHashMap<Integer, Set<String>>();
    private int allObjectSetId = -1;
    private int allDomainSetId = -1;
    private int allObjectOprSetId = -1;
    private int allAppOprSetId = -1;
    private boolean hasLoadDefaultDevsetOprsets = this.loadDefaultDevSetOprSets();
    public static final int ALL_DEVICE_SET_TYPE = 1;
    public static final int ALL_APP_OPERATION_SET_TYPE = 4;
    public static final int ALL_MO_OPERATION_SET_TYPE = 3;

    public static SetRightCache getInstance() {
        return instance;
    }

    public void setRightProxy(RightProxy _proxy) {
        this.proxy = _proxy;
    }

    private SetRightCache() {
    }

    private boolean loadDefaultDevSetOprSets() {
        try {
            int[] defaultDevSetOprSets = this.proxy.getDefaultDevSetOprSets();
            if (defaultDevSetOprSets != null && defaultDevSetOprSets.length == 4) {
                this.allObjectSetId = defaultDevSetOprSets[0];
                this.allDomainSetId = defaultDevSetOprSets[1];
                this.allObjectOprSetId = defaultDevSetOprSets[2];
                this.allAppOprSetId = defaultDevSetOprSets[3];
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return false;
    }

    private int getAllObjectSetId() {
        if (!this.hasLoadDefaultDevsetOprsets) {
            this.hasLoadDefaultDevsetOprsets = this.loadDefaultDevSetOprSets();
        }
        return this.allObjectSetId;
    }

    private int getAllDomainDeviceSetId() {
        if (!this.hasLoadDefaultDevsetOprsets) {
            this.hasLoadDefaultDevsetOprsets = this.loadDefaultDevSetOprSets();
        }
        return this.allDomainSetId;
    }

    private int getAllAppOperationSetId() {
        if (!this.hasLoadDefaultDevsetOprsets) {
            this.hasLoadDefaultDevsetOprsets = this.loadDefaultDevSetOprSets();
        }
        return this.allAppOprSetId;
    }

    private int getAllOjbectOperationSetId() {
        if (!this.hasLoadDefaultDevsetOprsets) {
            this.hasLoadDefaultDevsetOprsets = this.loadDefaultDevSetOprSets();
        }
        return this.allObjectOprSetId;
    }

    public boolean isAllObjectSet(int devSetId) {
        if (!this.hasLoadDefaultDevsetOprsets) {
            this.hasLoadDefaultDevsetOprsets = this.loadDefaultDevSetOprSets();
        }
        return this.allObjectSetId == devSetId;
    }

    public boolean isAllDomainSet(int devSetId) {
        if (!this.hasLoadDefaultDevsetOprsets) {
            this.hasLoadDefaultDevsetOprsets = this.loadDefaultDevSetOprSets();
        }
        return this.allDomainSetId == devSetId;
    }

    public boolean isAllObjectOprSet(int devSetId) {
        if (!this.hasLoadDefaultDevsetOprsets) {
            this.hasLoadDefaultDevsetOprsets = this.loadDefaultDevSetOprSets();
        }
        return this.allObjectOprSetId == devSetId;
    }

    public boolean isAllAppOprSet(int devSetId) {
        if (!this.hasLoadDefaultDevsetOprsets) {
            this.hasLoadDefaultDevsetOprsets = this.loadDefaultDevSetOprSets();
        }
        return this.allAppOprSetId == devSetId;
    }

    private Set<Integer> getOprSetsBoundTheObjectSet(SetRight setRight, int objectSetId) {
        int[] devSetIDs = setRight.devSetIDs;
        int[] opeSetIDs = setRight.opeSetIDs;
        HashSet<Integer> oprSetIds = new HashSet<Integer>();
        for (int i = 0; i < devSetIDs.length; ++i) {
            if (devSetIDs[i] != objectSetId) continue;
            oprSetIds.add(opeSetIDs[i]);
        }
        return oprSetIds;
    }

    public void unite(Map<String, Right> map1, Map<String, Right> map2) {
        Collection<Right> rightList = map2.values();
        for (Right right : rightList) {
            String key = right.so.getKey();
            Right oRight = map1.get(key);
            if (oRight == null) {
                map1.put(key, right);
                continue;
            }
            this.unite(oRight.accBitList, right.accBitList);
        }
    }

    private void unite(List<AccBit> oAccBit, List<AccBit> accBit) {
        for (AccBit oBit : oAccBit) {
            for (AccBit bit : accBit) {
                oBit.unite(bit);
            }
        }
    }

    private void loadGroupSetRight(int groupID) throws Exception {
        if (!this.group_setright_cache.containsKey(groupID)) {
            this.loadGroupSetRights();
        }
    }

    public void checkloadGroupSetRights(int userId) throws Exception {
        long t0 = System.currentTimeMillis();
        this.loadGroupSetRights();
        this.loadDevSetsByUser(userId);
        log.info((Object)("checkloadGroupSetRights cost time: " + (System.currentTimeMillis() - t0)));
    }

    private void loadGroupSetRights() throws Exception {
        if (this.group_setright_cache.isEmpty() && this.group_setright_cache.isEmpty()) {
            Map<Integer, SetRight> result = this.proxy.getGroupSetRights(RightCache.getInstance().getUserGroupIDs(EmfUserManager.getInstance().getUserID()));
            Set<Map.Entry<Integer, SetRight>> entrySet = result.entrySet();
            for (Map.Entry<Integer, SetRight> en : entrySet) {
                this.group_setright_cache.put(en.getKey(), en.getValue());
            }
            if (this.group_setright_cache.isEmpty()) {
                this.group_setright_cache.put(-1, new SetRight(new int[0], new int[0]));
            }
        }
    }

    public SetRight getGroupSetRight(int groupID) throws Exception {
        this.loadGroupSetRight(groupID);
        SetRight setRight = this.group_setright_cache.get(groupID);
        return setRight == null ? new SetRight(new int[0], new int[0]) : setRight;
    }

    public void loadOpeSetOperations() throws Exception {
        if (this.opeset_operations_cache.isEmpty() && this.opeset_operations_cache.isEmpty()) {
            int userid = SessionService.getInstance().getCurUser().getId();
            this.proxy.getOprSetMembersByUser(userid, this.opeset_subset_cache, this.opeset_operations_cache);
            if (this.opeset_operations_cache.isEmpty()) {
                this.opeset_operations_cache.put(-1, new ConcurrentHashMap());
            }
        }
    }

    public List<AccBit> getAccBit(List<AccBit> accBit, int bitSite) {
        boolean flg = false;
        for (AccBit bit : accBit) {
            flg = bit.addBit(bitSite);
        }
        if (!flg) {
            AccBit tmp = new AccBit(new int[4], AccBit.segment(bitSite));
            tmp.addBit(bitSite);
            accBit.add(tmp);
        }
        return accBit;
    }

    public boolean hasAllDeviceSetRight(int groupID) throws Exception {
        int[] ids;
        SetRight setRight = this.getGroupSetRight(groupID);
        for (int id : ids = setRight.devSetIDs) {
            if (!this.isAllObjectSet(id)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllObjectOpSetRight(int groupID) throws Exception {
        int[] ids;
        SetRight setRight = this.getGroupSetRight(groupID);
        for (int id : ids = setRight.opeSetIDs) {
            if (!this.isAllObjectOprSet(id)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllAppOprSetRight(int groupID) throws Exception {
        int[] ids;
        SetRight setRight = this.getGroupSetRight(groupID);
        for (int id : ids = setRight.opeSetIDs) {
            if (!this.isAllAppOprSet(id)) continue;
            return true;
        }
        return false;
    }

    public Integer[] getTypeIDs(int groupID) throws Exception {
        SetRight setRight = this.getGroupSetRight(groupID);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int[] opeids = setRight.opeSetIDs;
        int[] devids = setRight.devSetIDs;
        for (int i = 0; i < devids.length; ++i) {
            if (devids[i] != 0) continue;
            ids.add(opeids[i]);
        }
        return ids.toArray(new Integer[0]);
    }

    public boolean hasAllDomainSetBindTheRight(int groupID, RightInfo rightInfo) throws Exception {
        SetRight setRight = this.getGroupSetRight(groupID);
        Set<Integer> oprSets = this.getOprSetsBoundTheObjectSet(setRight, this.getAllDomainDeviceSetId());
        return this.isRightInOprSets(rightInfo, oprSets);
    }

    public boolean hasAllObjectSetBindTheRight(int groupID, RightInfo rightInfo) throws Exception {
        SetRight setRight = this.getGroupSetRight(groupID);
        Set<Integer> oprSets = this.getOprSetsBoundTheObjectSet(setRight, this.getAllObjectSetId());
        return this.isRightInOprSets(rightInfo, oprSets);
    }

    private boolean isRightInOprSets(RightInfo rightInfo, Set<Integer> oprSets) throws Exception {
        int size = oprSets.size();
        if (size > 0) {
            int index = 0;
            int[] oprids = new int[size];
            Iterator<Integer> i$ = oprSets.iterator();
            while (i$.hasNext()) {
                int oprsetId;
                oprids[index] = oprsetId = i$.next().intValue();
                ++index;
            }
            if (rightInfo.getObjectClassType().equals("APPLICATION") ? this.hasAllAppOprSet(oprids) : this.hasAllObjectOprSet(oprids)) {
                return true;
            }
            this.loadOpeSetOperations();
            for (int id : oprids) {
                if (this.isInThisOprSet(rightInfo, id)) {
                    return true;
                }
                Set<Integer> suboprsets = this.opeset_subset_cache.get(id);
                if (suboprsets == null) continue;
                for (int subid : suboprsets) {
                    if (!this.isInThisOprSet(rightInfo, subid)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isInThisOprSet(RightInfo rightInfo, int oprset) throws Exception {
        if ("APPLICATION".equals(rightInfo.getObjectClassType()) ? oprset == this.getAllAppOperationSetId() : oprset == this.getAllOjbectOperationSetId()) {
            return true;
        }
        this.loadOpeSetOperations();
        if (this.isRightInOprSet(rightInfo, oprset)) {
            return true;
        }
        Set<Integer> subSet = this.opeset_subset_cache.get(oprset);
        if (subSet != null) {
            for (int setId : subSet) {
                if (!this.isRightInOprSet(rightInfo, setId)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRightInOprSet(RightInfo rightInfo, int oprset) throws Exception {
        Map<String, TypeRight> map = this.opeset_operations_cache.get(oprset);
        if (map != null && map.size() > 0 && map.containsKey(rightInfo.objectClassName)) {
            TypeRight typeRight = map.get(rightInfo.objectClassName);
            return typeRight.containsOprId(rightInfo);
        }
        return false;
    }

    private boolean hasAllObjectOprSet(int[] oprSetIds) {
        return this.containsTheSetId(oprSetIds, this.getAllOjbectOperationSetId());
    }

    private boolean hasAllAppOprSet(int[] oprSetIds) {
        return this.containsTheSetId(oprSetIds, this.getAllAppOperationSetId());
    }

    public boolean hasAllObjectSet(int[] devSetIds) {
        return this.containsTheSetId(devSetIds, this.getAllObjectSetId());
    }

    private boolean containsTheSetId(int[] setIds, int theId) {
        if (setIds == null || setIds.length == 0) {
            return false;
        }
        for (int id : setIds) {
            if (theId != id) continue;
            return true;
        }
        return false;
    }

    public List<Integer> getContainAllMOOperationSetDevSetIDs(int userid) throws Exception {
        int[] groupIDs;
        ArrayList<Integer> list = new ArrayList<Integer>();
        SetRightCache.getInstance().checkloadGroupSetRights(userid);
        for (int groupID : groupIDs = RightCache.getInstance().getUserGroupIDs(userid)) {
            SetRight setRight = this.getGroupSetRight(groupID);
            int[] devIDs = setRight.devSetIDs;
            int[] opeIDs = setRight.opeSetIDs;
            for (int i = 0; i < opeIDs.length; ++i) {
                if (!this.isAllObjectOprSet(opeIDs[i])) continue;
                list.add(devIDs[i]);
            }
        }
        return list;
    }

    public void loadDevSetsByUser(int userId) throws Exception {
        if (this.devSet_subset_cache.isEmpty() && this.devSet_subset_cache.isEmpty()) {
            this.proxy.loadDeviceSetsByUser(userId, this.devSet_subset_cache, this.devSet_members_cache);
            if (this.devSet_subset_cache.isEmpty()) {
                this.devSet_subset_cache.put(-1, new HashSet(0));
            }
        }
    }

    public boolean devSetContainsID(int devSetId, String oid) {
        if (devSetId == this.getAllObjectSetId()) {
            return true;
        }
        Set<String> member = this.devSet_members_cache.get(devSetId);
        if (member != null && member.contains(oid)) {
            return true;
        }
        Set<String> subsetMem = null;
        Set<Integer> subsets = this.devSet_subset_cache.get(devSetId);
        for (Integer id : subsets) {
            subsetMem = this.devSet_members_cache.get(id);
            if (subsetMem == null || !subsetMem.contains(oid)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.group_setright_cache.clear();
        this.opeset_operations_cache.clear();
        this.opeset_subset_cache.clear();
        this.devSet_subset_cache.clear();
        this.devSet_members_cache.clear();
        this.hasLoadDefaultDevsetOprsets = false;
    }

    @Override
    public void timeTask() {
        this.clear();
    }

    @Override
    public void eventPerformed() {
        this.clear();
    }
}

