/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.cache;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.cache.IRightTimerListener;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class RightTimer {
    private static final int DEFAULT_INTERVAL_SECOND = 172800000;
    private int interval = 172800000;
    private IviewLogger log = TraceProxy.getLogger(RightTimer.class);
    private List<IRightTimerListener> listeners = new ArrayList<IRightTimerListener>(1);
    private Timer timer = new Timer();

    public void setInterval(int val) {
        this.interval = val;
    }

    public void addRightTimerListener(IRightTimerListener _listener) {
        this.listeners.add(_listener);
    }

    public void removeRightTimerListener() {
        this.listeners.clear();
    }

    private void fireRightTimerListener() {
        for (IRightTimerListener listener : this.listeners) {
            if (listener == null) continue;
            listener.timeTask();
        }
    }

    public void startTimer() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                RightTimer.this.log.info((Object)"Executing RightTimer task.");
                RightTimer.this.fireRightTimerListener();
            }
        };
        try {
            this.timer.scheduleAtFixedRate(timerTask, this.interval, (long)this.interval);
            this.log.info((Object)"RightTimer is started.");
        }
        catch (Exception e) {
            this.log.error((Object)"Error while starting RightTimer.", (Throwable)e);
        }
    }

    public void stop() {
        this.timer.cancel();
        this.log.info((Object)"RightTimer is stopped.");
    }
}

