/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.cache;

import com.swimap.external.sm.util.TraceProxy;
import com.swimap.imap.security.checkright.RightInfo;
import com.swimap.imap.security.checkright.cache.AccBit;
import com.swimap.imap.security.checkright.cache.IRightChangedEventListener;
import com.swimap.imap.security.checkright.cache.IRightTimerListener;
import com.swimap.imap.security.checkright.cache.IStaticRightUpdateEventListener;
import com.swimap.imap.security.checkright.cache.Right;
import com.swimap.imap.security.checkright.cache.RightProxy;
import com.swimap.imap.security.checkright.cache.SetRightCache;
import com.swimap.imap.security.checkright.cache.StaticRight;
import com.swimap.imap.security.checkright.cache.StaticRightRelation;
import com.swimap.imap.security.main.EmfUserManager;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RightCache
implements IRightTimerListener,
IRightChangedEventListener,
IStaticRightUpdateEventListener {
    public static final int DEVICE_VISIBLE_RIGHT_BIT_SITE = 1;
    public static final int STATIC_RIGHT_RELATION_SRC = 1;
    public static final int STATIC_RIGHT_RELATION_TAR = 2;
    private static final RightCache instance = new RightCache();
    private final Map<String, StaticRight> static_right_cache = new ConcurrentHashMap<String, StaticRight>();
    private final ArrayList<StaticRightRelation> static_right_relation_cache = new ArrayList();
    private final Map<Integer, Map<String, Right>> group_right_cache = new ConcurrentHashMap<Integer, Map<String, Right>>();
    private final Map<Integer, int[]> user_group_cache = new ConcurrentHashMap<Integer, int[]>();
    private final Map<Integer, List<String>> group_subnet_deviceset_cache = new ConcurrentHashMap<Integer, List<String>>();
    private final Map<Integer, Map<String, List<String>>> group_typeAcc_cache = new ConcurrentHashMap<Integer, Map<String, List<String>>>();
    private final Set<Integer> OperationCommandSet = new HashSet<Integer>();
    private RightProxy proxy = RightProxy.getInstance();
    private SetRightCache tool = SetRightCache.getInstance();
    private static IviewLogger log = TraceProxy.getLogger(RightCache.class);

    public static RightCache getInstance() {
        return instance;
    }

    public void setRightProxy(RightProxy _proxy) {
        this.proxy = _proxy;
    }

    public void setTool(SetRightCache _tool) {
        this.tool = _tool;
    }

    private synchronized void loadStaticRight() throws Exception {
        if (this.static_right_cache.isEmpty()) {
            StaticRight[] staticRightArray;
            for (StaticRight staticRight : staticRightArray = this.proxy.getStaticRight()) {
                this.static_right_cache.put(this.getStaticRightKey(staticRight), staticRight);
            }
        }
    }

    public Map<String, StaticRight> getStaticRight() throws Exception {
        this.loadStaticRight();
        return this.static_right_cache;
    }

    private synchronized void loadOperationCommand() throws Exception {
        if (this.OperationCommandSet.isEmpty()) {
            int[] operationCommandArray;
            for (int operationCommand : operationCommandArray = this.proxy.getOperationCommand()) {
                this.OperationCommandSet.add(operationCommand);
            }
        }
    }

    public Set<Integer> getOperationCommand() throws Exception {
        this.loadOperationCommand();
        return this.OperationCommandSet;
    }

    public boolean isExistStaticRight(RightInfo info) throws Exception {
        int bitSite = this.getBitSite(RightInfo.getObjectClassTypeID(info.objectClassType), info.objectClassName, info.operation);
        return bitSite != 0;
    }

    public int getBitSite(int type, String className, String operation) throws Exception {
        this.loadStaticRight();
        StaticRight right = this.static_right_cache.get(this.getStaticRightKey(type, className, operation));
        return right == null ? 0 : right.accBitSite;
    }

    public List<AccBit> getAccBit(int type, String className, String operation) throws Exception {
        LinkedList<AccBit> list = new LinkedList<AccBit>();
        return this.tool.getAccBit(list, this.getBitSite(type, className, operation));
    }

    private String getStaticRightKey(StaticRight staticRight) {
        return this.getStaticRightKey(staticRight.type, staticRight.className, staticRight.operationID);
    }

    private String getStaticRightKey(int type, String className, String operation) {
        return type + className + operation;
    }

    public int getAccessID(int type, String className, String operation) throws Exception {
        this.loadStaticRight();
        StaticRight right = this.static_right_cache.get(this.getStaticRightKey(type, className, operation));
        return right == null ? 0 : right.id;
    }

    private void loadRightByUser(int userID) throws Exception {
        if (!this.user_group_cache.containsKey(userID)) {
            this.user_group_cache.put(userID, this.proxy.getGroupIDs(userID));
        }
    }

    public int[] getUserGroupIDs(int userID) throws Exception {
        this.loadRightByUser(userID);
        return this.user_group_cache.get(userID);
    }

    public List<Map<String, Right>> getUserRight(int userID) throws Exception {
        this.loadRightByUser(userID);
        int[] groupIDArray = this.user_group_cache.get(userID);
        ArrayList<Map<String, Right>> list = new ArrayList<Map<String, Right>>();
        SetRightCache.getInstance().checkloadGroupSetRights(userID);
        this.loadRightByGroups(groupIDArray);
        for (int groupID : groupIDArray) {
            list.add(this.group_right_cache.get(groupID));
        }
        return list;
    }

    public boolean isGroupHasManagedRight(int groupId, String key) throws Exception {
        this.loadRightByGroups(new int[]{groupId});
        Map<String, Right> map = this.group_right_cache.get(groupId);
        if (map != null) {
            return map.containsKey(key);
        }
        return false;
    }

    private void loadRightByGroups(int[] groupIDs) throws Exception {
        if (groupIDs != null && groupIDs.length > 0) {
            ArrayList<Integer> notCachedGroupIDs = new ArrayList<Integer>();
            for (int i = 0; i < groupIDs.length; ++i) {
                if (this.group_right_cache.containsKey(groupIDs[i])) continue;
                notCachedGroupIDs.add(groupIDs[i]);
            }
            if (notCachedGroupIDs.size() > 0) {
                int[] needCachedGroupIDs = new int[notCachedGroupIDs.size()];
                for (int i = 0; i < needCachedGroupIDs.length; ++i) {
                    needCachedGroupIDs[i] = (Integer)notCachedGroupIDs.get(i);
                }
                Map<Integer, Map<String, Right>> rightMap = this.proxy.getGroupRights(needCachedGroupIDs);
                Set<Map.Entry<Integer, Map<String, Right>>> entrySet = rightMap.entrySet();
                for (Map.Entry<Integer, Map<String, Right>> en : entrySet) {
                    int groupid = en.getKey();
                    Map<String, Right> value = en.getValue();
                    this.group_right_cache.put(groupid, value);
                }
            }
        }
    }

    private synchronized void loadStaticRightRelation() throws Exception {
        if (this.static_right_relation_cache.isEmpty()) {
            StaticRightRelation[] staticRightRelationArray;
            for (StaticRightRelation staticRightRelation : staticRightRelationArray = this.proxy.getStaticRightRelation()) {
                this.static_right_relation_cache.add(staticRightRelation);
            }
        }
    }

    public List<Integer> getStaticRightRelationIDs(int[] ids, int flg) throws Exception {
        this.loadStaticRightRelation();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int id : ids) {
            this.packStaticRightRelationIDs(id, flg, result);
        }
        return result;
    }

    private void loadSubnetDeviceSetRightByGroups() throws Exception {
        if (this.group_subnet_deviceset_cache.isEmpty() && this.group_subnet_deviceset_cache.isEmpty()) {
            Map<Integer, List<String>> result = this.proxy.getSubnetDNListByGroups(RightCache.getInstance().getUserGroupIDs(EmfUserManager.getInstance().getUserID()));
            Set<Map.Entry<Integer, List<String>>> entrySet = result.entrySet();
            for (Map.Entry<Integer, List<String>> en : entrySet) {
                this.group_subnet_deviceset_cache.put(en.getKey(), en.getValue());
            }
            if (this.group_subnet_deviceset_cache.isEmpty()) {
                this.group_subnet_deviceset_cache.put(-1, new ArrayList());
            }
        }
    }

    public List<String> getSubnetDeviceSetRight(int userID) throws Exception {
        ArrayList<String> subnetDNList = new ArrayList<String>();
        this.loadRightByUser(userID);
        int[] groupIDArray = this.user_group_cache.get(userID);
        this.loadSubnetDeviceSetRightByGroups();
        for (int i = 0; i < groupIDArray.length; ++i) {
            List<String> set = this.group_subnet_deviceset_cache.get(groupIDArray[i]);
            if (set == null) continue;
            subnetDNList.addAll(set);
        }
        return subnetDNList;
    }

    public Set<String> getGroupSubnetDeviceSetDNs(int groupId) throws Exception {
        this.loadSubnetDeviceSetRightByGroups();
        List<String> list = this.group_subnet_deviceset_cache.get(groupId);
        if (list != null) {
            HashSet<String> dns = new HashSet<String>();
            for (String dn : list) {
                dns.add(dn);
            }
            return dns;
        }
        return Collections.emptySet();
    }

    public void clearSubnetDeviceSetCache() {
        this.group_subnet_deviceset_cache.clear();
    }

    private void packStaticRightRelationIDs(int id, int flg, List<Integer> outIDList) {
        int relatinCacheSize = this.static_right_relation_cache.size();
        for (int i = 0; i < relatinCacheSize; ++i) {
            StaticRightRelation rightRelation = this.static_right_relation_cache.get(i);
            if (rightRelation == null || id != this.getKey(flg, rightRelation)) continue;
            int value = this.getValue(flg, rightRelation);
            outIDList.add(value);
            this.packStaticRightRelationIDs(value, flg, outIDList);
        }
    }

    private int getKey(int value, StaticRightRelation rightRelation) {
        return value == 1 ? rightRelation.srcid : rightRelation.tarid;
    }

    private int getValue(int key, StaticRightRelation rightRelation) {
        return key == 1 ? rightRelation.tarid : rightRelation.srcid;
    }

    public boolean isContain(int userID, String className, String accessName) throws Exception {
        int[] groups;
        if (this.group_typeAcc_cache.size() <= 0) {
            this.initTypeCache(userID);
        }
        for (int groupId : groups = this.getUserGroupIDs(userID)) {
            List<String> list;
            Map<String, List<String>> map = this.group_typeAcc_cache.get(groupId);
            if (map == null || (list = map.get(className)) == null || !list.contains(accessName)) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupContainsTypeRight(int groupId, String className, String accessName) throws Exception {
        List<String> list;
        Map<String, List<String>> map = this.group_typeAcc_cache.get(groupId);
        return map != null && (list = map.get(className)) != null && list.contains(accessName);
    }

    public void initTypeCache(int userID) throws Exception {
        if (this.group_typeAcc_cache.size() == 0 && this.group_typeAcc_cache.size() == 0) {
            int[] groups = this.getUserGroupIDs(userID);
            if (groups != null && groups.length > 0) {
                Map<Integer, Map<String, List<String>>> allTypeAccMap = this.proxy.getTypeAccByGroups(groups);
                Set<Map.Entry<Integer, Map<String, List<String>>>> entrySet = allTypeAccMap.entrySet();
                for (Map.Entry<Integer, Map<String, List<String>>> en : entrySet) {
                    this.group_typeAcc_cache.put(en.getKey(), en.getValue());
                }
            }
            if (this.group_typeAcc_cache.size() == 0) {
                this.group_typeAcc_cache.put(-1, new HashMap());
            }
        }
    }

    public void clearGroupRightCache() {
        log.info((Object)"@@@@@ clear .....");
        this.group_right_cache.clear();
    }

    public void clear() {
        log.info((Object)"@@@@@ clear .....");
        this.group_right_cache.clear();
        this.user_group_cache.clear();
        this.group_typeAcc_cache.clear();
        this.group_subnet_deviceset_cache.clear();
        this.tool.clear();
    }

    @Override
    public void timeTask() {
        this.clear();
    }

    @Override
    public void eventPerformed() {
        this.clear();
    }

    @Override
    public void handleStaticRightUpdate() {
        this.static_right_cache.clear();
        this.static_right_relation_cache.clear();
    }
}

