/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.security.checkright.cache;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public final class AccBit {
    public int segment;
    public int[] bits = new int[4];

    public AccBit() {
    }

    public AccBit(int[] _bits, int _seg) {
        this.bits = _bits;
        this.segment = _seg;
    }

    public List<Integer> toBitSites() {
        return AccBit.toBitSites(this);
    }

    public boolean hasRight(int bitSite) {
        return AccBit.segment(bitSite) == this.segment && bitSite != 0 && AccBit.hasRight(this, bitSite);
    }

    public boolean addBit(int bitSite) {
        if (AccBit.segment(bitSite) != this.segment || bitSite == 0) {
            return false;
        }
        bitSite = AccBit.site(bitSite);
        int segment = bitSite - 1 >> 5;
        int site = bitSite - 1 & 0x1F;
        int n = segment;
        this.bits[n] = this.bits[n] | 1 << site;
        return true;
    }

    public boolean unite(AccBit _accBit) {
        if (this.segment != _accBit.segment) {
            return false;
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | _accBit.bits[i];
        }
        return true;
    }

    public String toString() {
        return "AccBit: segment = " + this.segment + " bits = " + Arrays.toString(this.bits);
    }

    public static int segment(int bitSite) {
        return bitSite - 1 >> 7;
    }

    public static int site(int bitSite) {
        return (bitSite & 0x7F) == 0 ? 128 : bitSite & 0x7F;
    }

    public static boolean hasRight(AccBit[] _accBits, int bitSite) {
        boolean result = false;
        for (AccBit _accBit : _accBits) {
            if (_accBit.segment != AccBit.segment(bitSite)) continue;
            result = AccBit.hasRight(_accBit, bitSite);
            break;
        }
        return result;
    }

    private static boolean hasRight(AccBit _accBit, int bitSite) {
        int site;
        int segment = (bitSite = AccBit.site(bitSite)) - 1 >> 5;
        return (_accBit.bits[segment] & 1 << (site = bitSite - 1 & 0x1F)) != 0;
    }

    public static List<Integer> toBitSites(AccBit _accBit) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i = 0; i < _accBit.bits.length; ++i) {
            for (int j = 0; j < 32; ++j) {
                if (0 == (1 << j & _accBit.bits[i])) continue;
                list.add(j + 1 + (i << 5) + (_accBit.segment << 7));
            }
        }
        return list;
    }

    public static List<Integer> toBitSites(AccBit[] _accBits) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (AccBit accBit : _accBits) {
            list.addAll(AccBit.toBitSites(accBit));
        }
        return list;
    }

    public static List<AccBit> readTable(DataTable accBitTable) {
        LinkedList<AccBit> accBitList = new LinkedList<AccBit>();
        for (DataRecord record : accBitTable) {
            accBitList.add(new AccBit(record.getIntArray("bits"), record.getInt("segment")));
        }
        return accBitList;
    }

    public static DataTable createTable(AccBit[] accBits) {
        String title = "accbittable";
        return AccBit.createTable(title, accBits);
    }

    public static DataTable createTable(String title, AccBit[] accBits) {
        DataTable accBitTable = new DataTable(title);
        accBitTable.setColumns(new String[]{"bits", "segment"});
        for (AccBit accBit : accBits) {
            accBitTable.add(new Object[]{accBit.bits, accBit.segment});
        }
        return accBitTable;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccBit) {
            AccBit tmp = (AccBit)obj;
            return this.segment == tmp.segment && Arrays.equals(this.bits, tmp.bits);
        }
        return false;
    }

    public static void mergeAccBitsList(List<AccBit> tar, List<AccBit> src) {
        ArrayList<AccBit> notFound = new ArrayList<AccBit>();
        for (AccBit srcBit : src) {
            boolean found = false;
            for (AccBit tarBit : tar) {
                if (!tarBit.unite(srcBit)) continue;
                found = true;
                break;
            }
            if (found) continue;
            notFound.add(srcBit);
        }
        tar.addAll(notFound);
    }

    public static boolean isPass(int bitSite, List<AccBit> bitList) {
        boolean isPass = false;
        for (AccBit accBit : bitList) {
            if (!accBit.hasRight(bitSite)) continue;
            isPass = true;
            break;
        }
        return isPass;
    }
}

