/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sm.util;

import com.swimap.eam.client.eamcommon.FdnDivideSymbolTool;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class EmfSecurityUtil {
    public static final int BUTTON_WIDTH = 85;
    public static final int LARGE_BUTTON_WIDTH = 200;
    public static final int BUTTON_HEIGHT = 21;
    public static final int TXT_TYPE = 0;
    public static final int HTML_TYPE = 1;
    public static final int CSV_TYPE = 2;
    private static IviewLogger logger = TraceProxy.getLogger(EmfSecurityUtil.class);

    private EmfSecurityUtil() {
    }

    public static void setEnterAndEscPress(JDialog dialog, final JButton enterButton, final JButton escButton) {
        if (null != enterButton) {
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
            dialog.getRootPane().getInputMap(2).put(enter, "ENTER");
            dialog.getRootPane().getActionMap().put("ENTER", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (enterButton.isEnabled()) {
                        enterButton.requestFocus();
                    }
                    enterButton.doClick();
                }
            });
        }
        if (null != escButton) {
            KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
            dialog.getRootPane().getInputMap(2).put(escape, "ESCAPE");
            dialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    escButton.doClick();
                }
            });
        }
    }

    public static String getFdnDivideSymbol() {
        String fdnDivideSymbol = FdnDivideSymbolTool.getFdnDivideSymbol();
        if (fdnDivideSymbol == null || fdnDivideSymbol.isEmpty()) {
            logger.error((Object)"Get fdn divide symbol is null.");
            return ",";
        }
        return fdnDivideSymbol;
    }

    public static String getFdnDivideSymbolEx() {
        String fdnDivideSymbol = EmfSecurityUtil.getFdnDivideSymbol();
        if (".".equals(fdnDivideSymbol)) {
            return "\\.";
        }
        return fdnDivideSymbol;
    }

    public static int[] toIntArray(Set<Integer> src) {
        int[] result = new int[src.size()];
        Iterator<Integer> ite = src.iterator();
        int index = 0;
        while (ite.hasNext()) {
            result[index++] = ite.next();
        }
        return result;
    }
}

