/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sm.util;

import com.swimap.external.lm.client.LicenseManager;
import com.swimap.external.lm.client.interfaces.LicItemInfoWrap;
import com.swimap.external.sm.adapter.message.LicenseInterface;
import com.swimap.external.sm.util.CommonLicenseInfo;
import com.swimap.external.sm.util.TraceProxy;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.List;

public class EmfSecurityLicenseUtil
implements LicenseInterface {
    private static IviewLogger log = TraceProxy.getLogger(EmfSecurityLicenseUtil.class);

    public List<CommonLicenseInfo> getAllLicenseInfo() {
        ArrayList<CommonLicenseInfo> allLicenseInfo = new ArrayList<CommonLicenseInfo>();
        try {
            List licInfoList = LicenseManager.getLicenseMgr().getIMAPLicenseInfo();
            for (LicItemInfoWrap item : licInfoList) {
                CommonLicenseInfo info = new CommonLicenseInfo(item.licItemInfo.item.nItemType, item.licItemInfo.name);
                info.setFeature(item.licItemInfo.item.strFeature);
                info.setItem(item.licItemInfo.item.strItem);
                info.setLicenseProductName(item.licItemInfo.productName);
                info.setLicenseUsedNum(item.licItemInfo.usedValue);
                info.setLicenseMaxNum(item.licItemInfo.maxValue);
                info.setSupportDetailInfoDisplay(item.licItemInfo.hasDetail == 1);
                allLicenseInfo.add(info);
            }
        }
        catch (Exception e) {
            log.error((Object)"get license info failure!");
            return null;
        }
        return allLicenseInfo;
    }
}

