/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.update;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UpdateLogger {
    private static UpdateLogger instance = new UpdateLogger();
    private BufferedWriter write_config_dataStream = null;
    private final SimpleDateFormat fileNameDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    private UpdateLogger() {
        String logFilePath = this.getLogFileAbsolutePath();
        this.write_config_dataStream = this.createOutputBuffer(logFilePath);
    }

    public static UpdateLogger getInstance() {
        return instance;
    }

    public void trace(String message) {
        this.outputMessage(this.write_config_dataStream, message);
    }

    public void trace(String message, Exception exception) {
        if (message != null && message.length() > 0) {
            this.trace(message);
        }
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strWriter);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        this.trace(strWriter.toString());
    }

    public void clear() {
        this.closeOutPut(this.write_config_dataStream);
    }

    private void outputMessage(BufferedWriter write_config_dataStream, String message) {
        String msg = this.getCurrentTimeString(false) + ": " + message;
        if (write_config_dataStream == null) {
            return;
        }
        try {
            write_config_dataStream.write(msg);
            write_config_dataStream.newLine();
            write_config_dataStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private BufferedWriter createOutputBuffer(String logFileName) {
        BufferedWriter write_config_dataStream = null;
        File file = new File(logFileName);
        try {
            write_config_dataStream = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file.getAbsolutePath())));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return write_config_dataStream;
    }

    private String getLogFileAbsolutePath() {
        StringBuffer logFileNameBuffer = new StringBuffer(System.getProperty("user.dir"));
        String str_currentTime = this.getCurrentTimeString(true);
        logFileNameBuffer.append("/update_resource_").append(str_currentTime).append(".log");
        System.err.println("trace will be written to : " + logFileNameBuffer.toString());
        return logFileNameBuffer.toString();
    }

    private String getCurrentTimeString(boolean isLogFileName) {
        SimpleDateFormat format = isLogFileName ? this.fileNameDateFormat : this.dateFormat;
        String dateStr = format.format(new Date());
        return dateStr;
    }

    private void closeOutPut(BufferedWriter write_config_dataStream) {
        if (write_config_dataStream != null) {
            try {
                write_config_dataStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

