/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.update;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.resource.client.update.UpdateLogger;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ResourceUpdateConfig {
    private static UpdateLogger logger = UpdateLogger.getInstance();
    private static String tarUserAbsDir = "";
    private static final String USER_RESROURCE_SRC_FILE = "conf/resource/profileinfo";
    private static final String USER_OLD_VERSION_RESROURCE_SRC_FILE = "conf/resource/commonresource";
    private static final String USER_RESROURCE_FILE = "conf/resource/commonresource_";
    private static final String filePath = "style/users/";
    private String updateFilePath = "";
    private static FileFilter pathFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public ResourceUpdateConfig() {
        String tarDir = this.makePathValid(System.getProperty("new.working.dir"));
        tarUserAbsDir = tarDir + filePath;
    }

    public void update() {
        File[] userDirectories = this.getUserdirectories();
        if (userDirectories == null || userDirectories.length == 0) {
            logger.trace("\u65e0\u7528\u6237\u76ee\u5f55");
            return;
        }
        File tarFile = null;
        File[] arr$ = userDirectories;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File path;
            tarFile = path = arr$[i$];
            this.updateResourceFile(tarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateResourceFile(File tarDir) {
        String targetDir = tarDir.getAbsolutePath();
        InputStream srcFile = null;
        try {
            this.updateFilePath = targetDir + "/" + USER_RESROURCE_SRC_FILE + ".xml";
            System.out.println("updateFilePath:" + this.updateFilePath);
            File userResourceFile = new File(this.updateFilePath);
            File userOlderResoruceFile = new File(targetDir + "/" + USER_OLD_VERSION_RESROURCE_SRC_FILE + ".xml");
            File updateFile = userOlderResoruceFile.exists() ? userOlderResoruceFile : userResourceFile;
            File usrTopoSetFile = new File(targetDir + "/" + USER_RESROURCE_FILE + ".xml");
            if (updateFile.exists()) {
                if (!usrTopoSetFile.exists()) {
                    String fileName = "commonresource";
                    fileName = "en".equals(ResourceMng.getInstance().getLocale().getLanguage()) ? fileName + "_en.xml" : fileName + "_zh.xml";
                    srcFile = ResourceUpdateConfig.class.getResourceAsStream(fileName);
                    this.copoFileToUsr(srcFile, usrTopoSetFile);
                }
                this.updateResource(updateFile.getAbsolutePath(), usrTopoSetFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.trace(e.getMessage(), e);
        }
        finally {
            if (srcFile != null) {
                try {
                    srcFile.close();
                }
                catch (Exception ex) {
                    logger.trace(ex.getMessage(), ex);
                }
            }
        }
    }

    private void updateResource(String srcPath, String targetPathh) {
        try {
            CommStyleInfo srcInfo = CommStyleManager.getInstance().getAbsCommStyleFile(srcPath);
            CommStyleInfo proInfo = this.getProfileInfo(targetPathh);
            File srcFile = new File(srcPath);
            srcFile.delete();
            File tarFile = new File(targetPathh);
            tarFile.delete();
            this.updateAlarmLevel(srcInfo, proInfo);
        }
        catch (Exception e) {
            logger.trace(e.getMessage(), e);
        }
    }

    private CommStyleInfo getProfileInfo(String targetPathh) {
        CommStyleInfo proInfo = new CommStyleInfo();
        CommStyleInfo targetInfo = CommStyleManager.getInstance().getAbsCommStyleFile(targetPathh);
        AreaDescContainer tarAreaContainer = targetInfo.getAreaDescContainer("AlarmLevel");
        proInfo.addAreaDescContainer(tarAreaContainer);
        return proInfo;
    }

    private void updateAlarmLevel(CommStyleInfo srcInfo, CommStyleInfo targetInfo) {
        AreaDescContainer srcAreaContainer = srcInfo.getAreaDescContainer("AlarmLevel");
        AreaDescContainer tarAreaContainer = targetInfo.getAreaDescContainer("AlarmLevel");
        DescContainer[] container = srcAreaContainer.getDescContainer();
        if (container != null && container.length > 0) {
            int paraCount = 0;
            String containerName = "";
            DescContainer tarContainer = null;
            String paraItemName = "";
            String paraItemValue = "";
            for (int i = 0; i < container.length; ++i) {
                paraCount = container[i].getParasItemCount();
                containerName = container[i].getDescName();
                tarContainer = tarAreaContainer.getDescContainer(containerName);
                for (int j = 0; j < paraCount; ++j) {
                    paraItemName = container[i].getParasItem(j).getName();
                    paraItemValue = container[i].getParasItem(j).getValue();
                    if (tarContainer == null) continue;
                    tarContainer.setParasItem(paraItemName, paraItemValue);
                }
            }
        }
        try {
            System.out.println("updateFilePath :" + this.updateFilePath);
            this.writeToUsr(targetInfo, this.updateFilePath);
        }
        catch (IOException e) {
            logger.trace(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToUsr(CommStyleInfo srcInfo, String filepath) throws IOException {
        File file = new File(filepath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ioexception) {
                logger.trace(ioexception.getMessage(), ioexception);
                return;
            }
        }
        BufferedWriter bufferedwriter = new BufferedWriter(new FileWriter(file));
        String s = "";
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try {
            srcInfo.marshal((OutputStream)bytearrayoutputstream);
            s = bytearrayoutputstream.toString();
        }
        catch (IOException ioexception) {
            logger.trace(ioexception.getMessage(), ioexception);
        }
        int j = s.length();
        try {
            if (j > 5000) {
                int i;
                for (i = 0; i < j / 5000; ++i) {
                    bufferedwriter.write(s, i * 5000, 5000);
                    bufferedwriter.flush();
                }
                if (j - i * 5000 > 0) {
                    bufferedwriter.write(s, i * 5000, j - i * 5000);
                    bufferedwriter.flush();
                }
            } else {
                bufferedwriter.write(s);
                bufferedwriter.flush();
            }
        }
        catch (Exception e) {
            logger.trace(e.getMessage(), e);
        }
        finally {
            try {
                if (bufferedwriter != null) {
                    bufferedwriter.close();
                }
            }
            catch (IOException e) {
                logger.trace(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copoFileToUsr(InputStream srcFile, File targetFile) {
        FileOutputStream writer = null;
        try {
            if (!targetFile.exists()) {
                targetFile = this.createFile(targetFile);
            }
            writer = new FileOutputStream(targetFile);
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = srcFile.read(buf)) != -1) {
                writer.write(buf, 0, len);
                writer.flush();
            }
        }
        catch (FileNotFoundException e) {
            logger.trace(e.getMessage(), e);
        }
        catch (IOException e) {
            logger.trace(e.getMessage(), e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.trace(e.getMessage(), e);
            }
        }
        logger.trace("copy file end.");
    }

    private File createFile(File file) {
        String filePath = file.getAbsolutePath();
        ArrayList<String> pathStack = new ArrayList<String>();
        for (File parentFile = file.getParentFile(); parentFile != null && !parentFile.exists(); parentFile = parentFile.getParentFile()) {
            pathStack.add(parentFile.getAbsolutePath());
        }
        int size = pathStack.size();
        for (int i = size - 1; i >= 0; --i) {
            if (i < 0) continue;
            new File((String)pathStack.get(i)).mkdir();
        }
        return new File(filePath);
    }

    private File[] getUserdirectories() {
        File file = new File(tarUserAbsDir);
        if (!file.exists()) {
            logger.trace(tarUserAbsDir + "\u6587\u4ef6\u4e0d\u5b58\u5728");
            return null;
        }
        File[] paths = file.listFiles(pathFilter);
        if (paths == null || paths.length == 0) {
            logger.trace("paths == null || paths.length == 0");
            return null;
        }
        return paths;
    }

    private String makePathValid(String dir) {
        if (dir == null) {
            return dir;
        }
        if (dir.endsWith("/") || dir.endsWith("\\")) {
            return dir;
        }
        return dir + "/";
    }

    public static void call() {
        ResourceUpdateConfig update = new ResourceUpdateConfig();
        update.update();
    }
}

