/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.util;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.resource.client.basicType.LinkType;
import com.swimap.external.resource.client.basicType.NEType;
import com.swimap.external.resource.client.basicType.SubnetType;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.impl.LinkTypeImpl;
import com.swimap.resource.client.impl.NETypeImpl;
import com.swimap.resource.client.impl.SubnetTypeImpl;
import com.swimap.resource.client.innerimpl.common.ResourceClientException;
import com.swimap.resource.client.innerimpl.data.SerialIconManagerImpl;
import com.swimap.resource.client.innerimpl.data.UnVisibleNeTypeManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;

public class RpcUtil {
    private static final IviewLogger logger = IviewLogger.getLogger(RpcUtil.class, (String)"EAM");

    public static void initSubType(DataTable subnetTypeTable, Map<Integer, SubnetType> subnetTypes, Map<Boolean, Integer> hideSubnetTypeMap) {
        if (subnetTypeTable != null && subnetTypeTable.size() > 0) {
            RpcUtil.parseSubnetTypes(subnetTypeTable, subnetTypes, hideSubnetTypeMap);
        } else {
            hideSubnetTypeMap.put(Boolean.FALSE, new Integer(-11111));
            logger.error((Object)"subnetTypeTable = null");
        }
    }

    public static void initNeType(Map<String, DataTable> resultMap, Map<Integer, NEType> needShowNeTypes, Map<Integer, NEType> needFilterNeTypes, List<Integer> unVisibleNeType, Map<Integer, NEType> allNeTypes) throws ResourceClientException {
        List<Integer> inVisibleTypes;
        DataTable neTypeTable = resultMap.get("allNodeType");
        DataTable needFilterNeTypeTable = resultMap.get("deleteNeTypeIDs");
        Set<Integer> needFilterNeTypeID = RpcUtil.getNeedFilterNeTypeID(needFilterNeTypeTable);
        if (neTypeTable != null && neTypeTable.size() > 0) {
            RpcUtil.parseNeTypes(neTypeTable, needFilterNeTypeID, needShowNeTypes, needFilterNeTypes, allNeTypes);
        }
        if ((inVisibleTypes = UnVisibleNeTypeManager.getAllUnVisibleNeType()) != null && inVisibleTypes.size() > 0) {
            unVisibleNeType.addAll(inVisibleTypes);
        }
    }

    public static void initLinkType(DataTable linkTypeTable, Map<Integer, LinkType> allLinkTypes) throws ResourceClientException {
        if (linkTypeTable != null && linkTypeTable.size() > 0) {
            RpcUtil.parseLinkTypes(linkTypeTable, allLinkTypes);
        }
    }

    public static void parseNeTypes(DataTable allNeTypeTable, Set<Integer> needFilterNeTypeID, Map<Integer, NEType> needShowNeTypes, Map<Integer, NEType> needFilterNeTypes, Map<Integer, NEType> allNeTypes) {
        try {
            RpcUtil.intiNeTypes(allNeTypeTable, needFilterNeTypeID, needShowNeTypes, needFilterNeTypes, allNeTypes);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
    }

    public static void parseSubnetTypes(DataTable table, Map<Integer, SubnetType> types, Map<Boolean, Integer> hideSubnetMap) {
        int typeIdIndex = table.getColumnIndex("type_id");
        int typeParentIdIndex = table.getColumnIndex("parent_typeid");
        int typeFeatureNameIndex = table.getColumnIndex("feature_name");
        int typeFeatureValueIndex = table.getColumnIndex("feature_value");
        SubnetTypeImpl subnetType = null;
        for (DataRecord record : table) {
            try {
                int typeId = record.getInt(typeIdIndex);
                String featureName = record.get(typeFeatureNameIndex);
                String featureValue = record.get(typeFeatureValueIndex);
                if (featureName == null || featureValue == null) continue;
                if (!types.containsKey(typeId)) {
                    int parentId = record.getInt(typeParentIdIndex);
                    subnetType = new SubnetTypeImpl(typeId, "", false, 1, true, true);
                    subnetType.setParentTypeID(parentId);
                    RpcUtil.initSubnetTypeFeatureValue(subnetType, featureName, featureValue);
                    types.put(typeId, subnetType);
                } else {
                    subnetType = (SubnetTypeImpl)types.get(typeId);
                    RpcUtil.initSubnetTypeFeatureValue(subnetType, featureName, featureValue);
                }
                if (hideSubnetMap == null || !"hide-enable".equals(featureName) || !"TRUE".equalsIgnoreCase(featureValue)) continue;
                if (hideSubnetMap.size() == 0) {
                    hideSubnetMap.put(Boolean.TRUE, new Integer(typeId));
                }
                logger.debug((Object)("subnetType hiden sntype:" + typeId));
            }
            catch (Exception ex) {
                logger.debug((Object)"", (Throwable)ex);
            }
        }
        logger.debug((Object)("subnetType types size:" + types == null ? 0 : (types.size() + ",hideSubnetMap size:" + hideSubnetMap == null ? 0 : hideSubnetMap.size())));
    }

    public static Set<Integer> getNeedFilterNeTypeID(DataTable needFilterNeTypeTable) {
        HashSet<Integer> delSet = new HashSet<Integer>();
        if (needFilterNeTypeTable != null && needFilterNeTypeTable.size() > 0) {
            for (DataRecord delRD : needFilterNeTypeTable) {
                int delID = delRD.getInt("type_id");
                delSet.add(delID);
            }
        }
        return delSet;
    }

    private static void initSubnetTypeFeatureValue(SubnetTypeImpl subnetType, String featureName, String featureValue) {
        if ("create-by-Client".equalsIgnoreCase(featureName)) {
            boolean submapDisplay;
            int isAllowCreateByClient = Integer.parseInt(featureValue);
            boolean isCreateByClientEnable = (isAllowCreateByClient & 1) == 1;
            subnetType.setAllowCreateByClientEnable(isCreateByClientEnable);
            subnetType.m_bSubmapDisplay = submapDisplay = (isAllowCreateByClient & 0x4000) <= 0;
        } else if ("kind".equalsIgnoreCase(featureName)) {
            int kind = Integer.parseInt(featureValue);
            subnetType.setKind(kind);
        } else if ("class".equalsIgnoreCase(featureName)) {
            subnetType.m_iClass = Integer.parseInt(featureValue);
        } else if ("hide-enable".equalsIgnoreCase(featureName)) {
            subnetType.setIsHiddenSubnetType(Boolean.valueOf(featureValue));
        } else if ("label".equalsIgnoreCase(featureName)) {
            subnetType.setDisplayLalel(featureValue);
            logger.debug((Object)("subnetType add,label:" + featureValue + ",typeID:" + subnetType.getId()));
        } else if (RpcUtil.isFeatrueNameStartWithTreeIcon(featureName)) {
            String treeIconName = featureValue;
            ImageIcon treeIcon = SerialIconManagerImpl.getInstance().getIcon(treeIconName);
            if (treeIcon != null) {
                String iconNameSuffix = featureName.substring("tree-icon".length()).trim();
                subnetType.setTreeIcon("label" + iconNameSuffix, treeIcon);
            } else {
                logger.trace((Object)("subnet The tree icon is null: " + subnetType.getId() + " treeIconName" + treeIconName));
            }
        } else if (RpcUtil.isFeatrueNameStartWithMapIcon(featureName)) {
            String mapIconName = featureValue;
            ImageIcon mapIcon = SerialIconManagerImpl.getInstance().getIcon(mapIconName);
            if (mapIcon != null) {
                String iconNameSuffix = featureName.substring("map-icon".length()).trim();
                subnetType.setMapIcon("label" + iconNameSuffix, mapIcon);
                subnetType.putMapIconFile("label" + iconNameSuffix, mapIconName);
            } else {
                logger.trace((Object)("subnet The map icon is null: " + subnetType.getId() + " mapIconName" + mapIconName));
            }
        } else {
            subnetType.addAttribute(featureName, featureValue);
        }
    }

    private static void intiNeTypes(DataTable table, Set<Integer> needFilterNeTypeID, Map<Integer, NEType> needShowNeTypes, Map<Integer, NEType> needFilterNeTypes, Map<Integer, NEType> allNeTypes) {
        int typeIdIndex = table.getColumnIndex("type_id");
        int typeParentIdIndex = table.getColumnIndex("parent_typeid");
        int typeFeatureNameIndex = table.getColumnIndex("feature_name");
        int typeFeatureValueIndex = table.getColumnIndex("feature_value");
        NETypeImpl netypeType = null;
        HashSet<Integer> unVisibleTypes = new HashSet<Integer>();
        for (DataRecord record : table) {
            try {
                int typeId = record.getInt(typeIdIndex);
                String featureName = record.get(typeFeatureNameIndex);
                String featureValue = record.get(typeFeatureValueIndex);
                if (featureName == null || featureValue == null) continue;
                netypeType = RpcUtil.getHaveCreatedNeType(needShowNeTypes, needFilterNeTypes, typeId);
                boolean isNeedFilterNeType = RpcUtil.isNeedFilterNeType(needFilterNeTypeID, typeId);
                if (netypeType != null) {
                    RpcUtil.initNETypeFeatureValue(netypeType, featureName, featureValue, unVisibleTypes);
                    continue;
                }
                int parentId = record.getInt(typeParentIdIndex);
                netypeType = new NETypeImpl(typeId);
                netypeType.setParentTypeID(parentId);
                RpcUtil.initNETypeFeatureValue(netypeType, featureName, featureValue, unVisibleTypes);
                if (isNeedFilterNeType) {
                    needFilterNeTypes.put(typeId, netypeType);
                    logger.debug((Object)("netype filterNeType id: " + typeId));
                } else {
                    needShowNeTypes.put(typeId, netypeType);
                }
                allNeTypes.put(typeId, netypeType);
            }
            catch (Exception ex) {
                logger.error((Object)("Parse record exception: " + ex + " \n The record is: " + record));
            }
        }
        RpcUtil.filterUnVisableNeType(needShowNeTypes, unVisibleTypes);
        logger.debug((Object)("neType needShowNeTypes size: " + needShowNeTypes.size() + " ,needFilterNeTypes size:" + needFilterNeTypes.size() + " ,unVisibleTypes size:" + Arrays.toString((Object[])unVisibleTypes.toArray(new Integer[0])) + " ,allNeTypes size:" + allNeTypes.size()));
    }

    private static void filterUnVisableNeType(Map<Integer, NEType> needShowNeTypes, Set<Integer> unVisibleTypes) {
        if (unVisibleTypes.size() > 0) {
            for (Integer filerType : unVisibleTypes) {
                needShowNeTypes.remove(filerType);
            }
            UnVisibleNeTypeManager.addUnVisibleNeType(unVisibleTypes);
        }
    }

    private static NETypeImpl getHaveCreatedNeType(Map<Integer, NEType> needShowNeTypes, Map<Integer, NEType> needFilterNeTypes, int neTypeID) {
        NETypeImpl netypeType = (NETypeImpl)needShowNeTypes.get(neTypeID);
        if (netypeType == null) {
            netypeType = (NETypeImpl)needFilterNeTypes.get(neTypeID);
        }
        return netypeType;
    }

    private static boolean isNeedFilterNeType(Set<Integer> needFilterNeTypeID, int neTypeID) {
        return needFilterNeTypeID.contains(neTypeID);
    }

    private static void initNETypeFeatureValue(NETypeImpl neType, String featureName, String featureValue, Set<Integer> unVisibleTypes) {
        if ("create-by-Client".equalsIgnoreCase(featureName)) {
            neType.setAllowCreateByClientEnable(Integer.parseInt(featureValue));
        } else if ("label".equalsIgnoreCase(featureName)) {
            neType.setDisplayLalel(featureValue);
            logger.debug((Object)("neType add,label:" + featureValue + ",typeID:" + neType.getId()));
        } else if (RpcUtil.isFeatrueNameStartWithTreeIcon(featureName)) {
            String treeIconName = featureValue;
            ImageIcon treeIcon = SerialIconManagerImpl.getInstance().getIcon(treeIconName);
            if (treeIcon != null) {
                String iconNameSuffix = featureName.substring("tree-icon".length()).trim();
                neType.setTreeIcon("label" + iconNameSuffix, treeIcon);
                neType.putTreeIconFile("label" + iconNameSuffix, treeIconName);
            } else {
                logger.trace((Object)("ne The tree icon is null: " + neType.getId() + " treeIconName" + treeIconName));
            }
        } else if (RpcUtil.isFeatrueNameStartWithMapIcon(featureName)) {
            String mapIconName = featureValue;
            ImageIcon mapIcon = SerialIconManagerImpl.getInstance().getIcon(mapIconName);
            if (mapIcon != null) {
                String iconNameSuffix = featureName.substring("map-icon".length()).trim();
                neType.setMapIcon("label" + iconNameSuffix, mapIcon);
                neType.putMapIconFile("label" + iconNameSuffix, mapIconName);
            } else {
                logger.trace((Object)("ne The map icon is null: " + neType.getId() + " mapIconName" + mapIconName));
            }
        } else if ("alarm-enable".equalsIgnoreCase(featureName)) {
            neType.addAttribute("alarm-enable", featureValue);
        } else if ("NESynchronize-enable".equalsIgnoreCase(featureName)) {
            neType.addAttribute("NESynchronize-enable", featureValue);
        } else if ("AlarmSynchronize-enable".equalsIgnoreCase(featureName)) {
            neType.addAttribute("AlarmSynchronize-enable", featureValue);
        } else if ("isTrueNE".equalsIgnoreCase(featureName)) {
            neType.addAttribute("isTrueNE", featureValue);
        } else if (!"isServerFilter".equalsIgnoreCase(featureName)) {
            if ("isChildNE".equalsIgnoreCase(featureName)) {
                neType.setIsClockNodeType(Boolean.valueOf(featureValue));
            } else if ("kind".equalsIgnoreCase(featureName)) {
                neType.setkindType(Integer.parseInt(featureValue));
            } else if ("isVisibleNE".equals(featureName)) {
                if ("false".equalsIgnoreCase(featureValue)) {
                    unVisibleTypes.add(neType.getId());
                }
            } else {
                neType.addAttribute(featureName, featureValue);
            }
        }
    }

    private static boolean isFeatrueNameStartWithTreeIcon(String featureName) {
        return featureName != null && !"".equals(featureName) && featureName.startsWith("tree-icon");
    }

    private static boolean isFeatrueNameStartWithMapIcon(String featureName) {
        return featureName != null && !"".equals(featureName) && featureName.startsWith("map-icon");
    }

    public static void parseLinkTypes(DataTable table, Map<Integer, LinkType> types) {
        int typeIdIndex = table.getColumnIndex("type_id");
        int typeParentIdIndex = table.getColumnIndex("parent_typeid");
        int typeFeatureNameIndex = table.getColumnIndex("feature_name");
        int typeFeatureValueIndex = table.getColumnIndex("feature_value");
        LinkTypeImpl linkType = null;
        for (DataRecord record : table) {
            try {
                int typeId = record.getInt(typeIdIndex);
                String featureName = record.get(typeFeatureNameIndex);
                String featureValue = record.get(typeFeatureValueIndex);
                if (featureName == null || featureValue == null) continue;
                if (!types.containsKey(typeId)) {
                    int parentId = record.getInt(typeParentIdIndex);
                    linkType = new LinkTypeImpl(typeId);
                    linkType.setParentTypeID(parentId);
                    RpcUtil.initLinkTypeFeatureValue(linkType, featureName, featureValue);
                    types.put(typeId, linkType);
                    continue;
                }
                linkType = (LinkTypeImpl)types.get(typeId);
                RpcUtil.initLinkTypeFeatureValue(linkType, featureName, featureValue);
            }
            catch (Exception ex) {
                logger.error((Object)("Parse record exception: " + ex + " \n The record is: " + record));
            }
        }
        logger.debug((Object)("linkType types size:" + types.size()));
    }

    private static void initLinkTypeFeatureValue(LinkTypeImpl linkType, String featureName, String featureValue) {
        if ("create-by-Client".equalsIgnoreCase(featureName)) {
            int isAllowCreateByClient = Integer.parseInt(featureValue);
            linkType.setAllowCreateByClientEnable(isAllowCreateByClient);
        } else if ("link-type-tree-name".equalsIgnoreCase(featureName)) {
            linkType.setTreePathName(featureValue);
        } else if ("label".equalsIgnoreCase(featureName)) {
            linkType.setDisplayLalel(featureValue);
            logger.debug((Object)("linkType add,label:" + featureValue + ",typeID:" + linkType.getId()));
        } else if ("alarm-enable".equalsIgnoreCase(featureName)) {
            linkType.addAttribute("alarm-enable", featureValue);
        } else if ("isContainer".equalsIgnoreCase(featureName)) {
            linkType.addAttribute("isContainer", featureValue);
        } else if (RpcUtil.isFeatrueNameStartWithTreeIcon(featureName)) {
            String treeIconName = featureValue;
            ImageIcon treeIcon = SerialIconManagerImpl.getInstance().getIcon(treeIconName, false);
            if (treeIcon != null) {
                String iconNameSuffix = featureName.substring("tree-icon".length()).trim();
                linkType.setTreeIcon("label" + iconNameSuffix, treeIcon);
            } else {
                logger.trace((Object)("link The tree icon is null: " + linkType.getId() + " treeIconName" + treeIconName));
            }
        } else if (RpcUtil.isFeatrueNameStartWithMapIcon(featureName)) {
            String mapIconName = featureValue;
            ImageIcon mapIcon = SerialIconManagerImpl.getInstance().getIcon(mapIconName, false);
            if (mapIcon != null) {
                String iconNameSuffix = featureName.substring("map-icon".length()).trim();
                linkType.setMapIcon("label" + iconNameSuffix, mapIcon);
                linkType.putMapIconFile("label" + iconNameSuffix, mapIconName);
            } else {
                logger.trace((Object)("link The map icon is null: " + linkType.getId() + " mapIconName" + mapIconName));
            }
        } else if ("procid".equalsIgnoreCase(featureName)) {
            linkType.m_iProcID = Integer.parseInt(featureValue);
        } else {
            linkType.addAttribute(featureName, featureValue);
        }
    }
}

