/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.util;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.resource.client.basicType.LinkType;
import com.swimap.external.resource.client.basicType.NEType;
import com.swimap.external.resource.client.basicType.SubnetType;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.innerimpl.data.ResourceParseManagerImpl;
import com.swimap.resource.client.innerimpl.data.SerialIconManagerImpl;
import com.swimap.resource.client.innerinterface.IInnerType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ResourceUtil {
    private static final IviewLogger logger = IviewLogger.getLogger(ResourceUtil.class, (String)"EAM");
    private static ResourceUtil instance = new ResourceUtil();
    public static final ImageIcon unknowtypeicon = new ImageIcon(ResourceParseManagerImpl.class.getResource("unknowntype.gif"));
    private static final String EXPANDED_ROOT_ICON_FILE = "image/expandedRoot.gif";
    private static final String CLOSED_ROOT_ICON_FILE = "image/closeRoot.gif";
    private static final String DEFAULT_NODE_ICON_FILE = "image/defautNode.gif";
    private static final String DEFAULT_SUBNET_ICON_FILE = "image/defaultSubnet.gif";
    private static final String DEFAULT_LINK_ICON_FILE = "image/defaultLink.gif";
    public static final ImageIcon emptyIcon = new ImageIcon("");
    private HashMap<String, ImageIcon> veryLargeSubnetMap = null;
    private HashMap<String, ImageIcon> largeSubnetMap = null;
    private HashMap<String, ImageIcon> middleSubnetMap = null;
    private HashMap<String, ImageIcon> smallSubnetMap = null;
    private HashMap<String, ImageIcon> veryLargeNeMap = null;
    private HashMap<String, ImageIcon> largeNeMap = null;
    private HashMap<String, ImageIcon> middleNeMap = null;
    private HashMap<String, ImageIcon> smallNeMap = null;
    private HashMap<String, ImageIcon> veryLargeLinkMap = null;
    private HashMap<String, ImageIcon> largeLinkMap = null;
    private HashMap<String, ImageIcon> middleLinkMap = null;
    private HashMap<String, ImageIcon> smallLinkMap = null;
    private Plugin plugin = PluginManager.getInstance().getPlugin("resource");

    private ResourceUtil() {
    }

    public static ResourceUtil getInstance() {
        return instance;
    }

    public Plugin getResouceModulePlugin() {
        return this.plugin;
    }

    public String getFeatureValue(DataRecord record, String featureName) {
        if (record.get("feature_name") != null && record.get("feature_name").equals(featureName)) {
            return record.get("feature_value").trim();
        }
        return null;
    }

    public HashMap<String, ImageIcon> getSubnetIcon(int iconType) {
        Collection<SubnetType> subnetTypes = ResourceParseManagerImpl.getInstance().getAllSubnetType();
        if (subnetTypes == null) {
            return null;
        }
        IInnerType[] types = subnetTypes.toArray(new IInnerType[0]);
        switch (iconType) {
            case 0: {
                return this.getIconMap(this.smallSubnetMap, types, iconType);
            }
            case 1: {
                return this.getIconMap(this.middleSubnetMap, types, iconType);
            }
            case 2: {
                return this.getIconMap(this.largeSubnetMap, types, iconType);
            }
            case 3: {
                return this.getIconMap(this.veryLargeSubnetMap, types, iconType);
            }
        }
        return this.getIconMap(this.middleSubnetMap, types, iconType);
    }

    public HashMap<String, ImageIcon> getNeIcon(int iconType) {
        Collection<NEType> neTypes = ResourceParseManagerImpl.getInstance().getAllNeTypesNotFilter();
        if (neTypes == null) {
            return null;
        }
        IInnerType[] types = neTypes.toArray(new IInnerType[0]);
        switch (iconType) {
            case 0: {
                return this.getIconMap(this.smallNeMap, types, iconType);
            }
            case 1: {
                return this.getIconMap(this.middleNeMap, types, iconType);
            }
            case 2: {
                return this.getIconMap(this.largeNeMap, types, iconType);
            }
            case 3: {
                return this.getIconMap(this.veryLargeNeMap, types, iconType);
            }
        }
        return this.getIconMap(this.middleNeMap, types, iconType);
    }

    public HashMap<String, ImageIcon> getLinkIcon(int iconType) {
        Collection<LinkType> linkTypes = ResourceParseManagerImpl.getInstance().getAllLinkType();
        if (linkTypes == null) {
            return null;
        }
        IInnerType[] types = linkTypes.toArray(new IInnerType[0]);
        switch (iconType) {
            case 0: {
                return this.getIconMap(this.smallLinkMap, types, iconType, false);
            }
            case 1: {
                return this.getIconMap(this.middleLinkMap, types, iconType, false);
            }
            case 2: {
                return this.getIconMap(this.largeLinkMap, types, iconType, false);
            }
            case 3: {
                return this.getIconMap(this.veryLargeLinkMap, types, iconType, false);
            }
        }
        return this.getIconMap(this.middleLinkMap, types, iconType, false);
    }

    private HashMap<String, ImageIcon> getIconMap(HashMap<String, ImageIcon> iconMap, IInnerType[] types, int iconType) {
        return this.getIconMap(iconMap, types, iconType, true);
    }

    private HashMap<String, ImageIcon> getIconMap(HashMap<String, ImageIcon> iconMap, IInnerType[] types, int iconType, boolean needUnknowIcon) {
        if (iconMap == null) {
            iconMap = new HashMap();
        }
        if (types == null) {
            return iconMap;
        }
        for (int i = 0; i < types.length; ++i) {
            String typeIdStr = String.valueOf(types[i].getId());
            if (iconMap.get(typeIdStr) != null) continue;
            HashMap<String, Icon> nodeIcon = types[i].getMapIcons();
            HashMap<String, String> fileNames = types[i].getFileNames();
            for (Map.Entry<String, Icon> entry : nodeIcon.entrySet()) {
                String mapIconname = fileNames.get(entry.getKey());
                if (null == mapIconname || mapIconname.trim().length() == 0) continue;
                String key = String.valueOf(types[i].getId()) + entry.getKey();
                ImageIcon icon = this.getIconDoubleCheck(iconType, fileNames.get(entry.getKey()), needUnknowIcon);
                iconMap.put(key, icon);
            }
        }
        return iconMap;
    }

    private ImageIcon getIconDoubleCheck(int iconStyle, String iconFileName, boolean needUnknowIcon) {
        String fileName = this.changeSiglePicSize(iconFileName, iconStyle);
        ImageIcon icon = SerialIconManagerImpl.getInstance().getIcon(fileName, needUnknowIcon);
        if (this.isNeedGetDefaultSizeIcon(iconStyle, icon)) {
            fileName = this.changeSiglePicSize(iconFileName, 1);
            icon = SerialIconManagerImpl.getInstance().getIcon(fileName, needUnknowIcon);
        }
        return icon;
    }

    public boolean isNeedGetDefaultSizeIcon(int iconSize, ImageIcon image) {
        return iconSize != 1 && this.isUnknowIcon(image);
    }

    public boolean isUnknowIcon(Icon icon) {
        return icon == null || icon.equals(unknowtypeicon) || icon.equals(emptyIcon);
    }

    public HashMap<String, ImageIcon> getAllIconMap(List<String> oldTypeID, IInnerType[] types, int iconType, boolean needUnknowIcon) {
        HashMap<String, ImageIcon> imageIcon = new HashMap<String, ImageIcon>();
        if (types == null) {
            return null;
        }
        for (int i = 0; i < types.length; ++i) {
            if (null == types[i]) {
                imageIcon.put(oldTypeID.get(i), null);
                continue;
            }
            HashMap<String, Icon> nodeIcon = null;
            if ("0".equals(oldTypeID.get(i))) {
                nodeIcon = types[i].getTreeIcons();
                imageIcon.put(oldTypeID.get(i), (ImageIcon)nodeIcon.get("label"));
                continue;
            }
            nodeIcon = types[i].getMapIcons();
            if (null == nodeIcon || nodeIcon.size() < 1) {
                imageIcon.put(oldTypeID.get(i), null);
                continue;
            }
            HashMap<String, String> fileNames = types[i].getFileNames();
            if (null == fileNames || fileNames.size() < 1) {
                imageIcon.put(oldTypeID.get(i), null);
                continue;
            }
            for (Map.Entry<String, Icon> entry : nodeIcon.entrySet()) {
                ImageIcon icon = this.getIconDoubleCheck(iconType, fileNames.get(entry.getKey()), needUnknowIcon);
                if (!(icon instanceof ImageIcon)) continue;
                imageIcon.put(oldTypeID.get(i), icon);
            }
        }
        return imageIcon;
    }

    private String changeSiglePicSize(String mapIconName, int iconType) {
        StringBuffer mapIconNameBuf = new StringBuffer();
        String filePre = "image/icon";
        if (mapIconName != null) {
            int len = filePre.length();
            if (mapIconName.lastIndexOf(filePre) >= 0) {
                mapIconName = mapIconName.substring(mapIconName.lastIndexOf(filePre) + len + 2);
            }
        }
        switch (iconType) {
            case 0: {
                mapIconNameBuf.append("image/iconS/");
                break;
            }
            case 1: {
                mapIconNameBuf.append("image/iconN/");
                break;
            }
            case 2: {
                mapIconNameBuf.append("image/iconM/");
                break;
            }
            case 3: {
                mapIconNameBuf.append("image/iconL/");
                break;
            }
            default: {
                mapIconNameBuf.append("image/iconN/");
            }
        }
        mapIconName = mapIconNameBuf.append(mapIconName).toString();
        return mapIconName;
    }

    public ImageIcon getResourceImage(String iconFileName) {
        ImageIcon result = null;
        try {
            result = (ImageIcon)this.plugin.getConfIcon(iconFileName);
            if (result == null || result.getIconWidth() <= 0) {
                result = (ImageIcon)this.plugin.getResource().getIcon(iconFileName);
            }
        }
        catch (Exception e) {
            logger.error((Object)("getResourceImage error,iconFileName is:" + iconFileName));
        }
        return result;
    }

    public ImageIcon getExpandedRootImageIcon() {
        return this.getResourceImage(EXPANDED_ROOT_ICON_FILE);
    }

    public ImageIcon getClosedRootImageIcon() {
        return this.getResourceImage(CLOSED_ROOT_ICON_FILE);
    }

    public ImageIcon getDefaultNodeImageIcon() {
        return this.getResourceImage(DEFAULT_NODE_ICON_FILE);
    }

    public ImageIcon getDefaultSubnetImageIcon() {
        return this.getResourceImage(DEFAULT_SUBNET_ICON_FILE);
    }

    public ImageIcon getDefaultLinkImageIcon() {
        return this.getResourceImage(DEFAULT_LINK_ICON_FILE);
    }
}

