/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.util;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.util.log.IviewLogger;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ResourceBundle;

public final class MessageUtil {
    private static final IviewLogger logger = IviewLogger.getLogger(MessageUtil.class, (String)"EAM");
    private static MessageUtil instance = null;
    private static ResourceBundle infoRes = null;

    private MessageUtil() {
    }

    public static MessageUtil getInstance() {
        if (instance == null) {
            instance = new MessageUtil();
        }
        return instance;
    }

    public String getInfoResMessage(String key) {
        try {
            return this.getInfoResourceBundle().getString(key);
        }
        catch (Exception e) {
            logger.error((Object)("Can't find resource for bundle of key, key = " + key), (Throwable)e);
            return key;
        }
    }

    private ResourceBundle getInfoResourceBundle() {
        if (infoRes == null) {
            Plugin plugin = PluginManager.getInstance().getPlugin("resource");
            infoRes = plugin.getResource().getResourceBundleFromPropertyFile("InfoRes");
        }
        return infoRes;
    }

    private String getError(int resultLabel, String rightName) {
        String message = null;
        switch (resultLabel) {
            case 80007: {
                message = this.getInfoResMessage("DS_AUTHORITATION_FAIL");
                break;
            }
            case 80004: {
                message = this.getInfoResMessage("DS_DATABASE_CONNECT_FAIL");
                break;
            }
            case 80005: {
                message = this.getInfoResMessage("DS_DATABASE_SEARCH_FAIL");
                break;
            }
            case 80102: {
                message = this.getInfoResMessage("DS_FAIL_PARENT");
                break;
            }
            case 80008: {
                message = this.getInfoResMessage("DS_INEXISTENT_OBJECT");
                break;
            }
            case 80101: {
                message = this.getInfoResMessage("DS_INEXISTENT_PARENT");
                break;
            }
            case 80006: {
                message = this.getInfoResMessage("DS_JOIN_AS_FAIL");
                break;
            }
            case 80002: {
                message = this.getInfoResMessage("DS_NULL_INPUTPARAMETER");
                break;
            }
            case 80003: {
                message = this.getInfoResMessage("DS_UNLAWFUL_INPUTPARAMETER");
                break;
            }
            case 80103: {
                message = this.getInfoResMessage("DS_SAME_NAME");
                break;
            }
            case 80001: {
                message = this.getInfoResMessage("DS_UNKNOW_ERROR");
                break;
            }
            case 80018: {
                message = this.getNotRight(rightName);
                break;
            }
            case 10113: {
                message = this.getInfoResMessage("RET_DN_NOT_EXIST");
                break;
            }
            case 10137: {
                message = this.getInfoResMessage("RET_MOVE_SN_TOCHILD");
                break;
            }
            case 10142: {
                message = this.getInfoResMessage("RET_LINK_ALREADY_EXIST");
                break;
            }
            default: {
                message = this.getInfoResMessage("" + resultLabel);
            }
        }
        return message;
    }

    public String processErrorCode(int resultFlag, String rightName) {
        if (resultFlag == 0) {
            return null;
        }
        int resultLabel = resultFlag;
        String message = this.getError(resultLabel, rightName);
        if (message != null) {
            logger.error((Object)(resultFlag + message));
            return message;
        }
        switch (resultLabel) {
            case 10101: {
                message = this.getInfoResMessage("RET_TYPE_NOT_EXIST");
                break;
            }
            case 10102: {
                message = this.getInfoResMessage("RET_LABEL_EMPTY");
                break;
            }
            case 10103: {
                message = this.getInfoResMessage("RET_LABEL_EXISTED");
                break;
            }
            case 10104: {
                message = this.getInfoResMessage("RET_DN_INVALID");
                break;
            }
            case 10105: {
                message = this.getInfoResMessage("RET_DN_EXISTED");
                break;
            }
            case 10106: {
                message = this.getInfoResMessage("RET_DN_TOO_LONG");
                break;
            }
            case 10107: {
                message = this.getInfoResMessage("RET_PSN_NOT_EXIST");
                break;
            }
            case 10108: {
                message = this.getInfoResMessage("RET_PNE_NOT_EXIST");
                break;
            }
            case 10109: {
                message = this.getInfoResMessage("RET_PARENT_INVALID");
                break;
            }
            case 10113: {
                message = this.getInfoResMessage("RET_DN_NOT_EXIST");
                break;
            }
            case 10127: {
                message = this.getInfoResMessage("RET_LNE_NOT_EXISTED");
                break;
            }
            case 10128: {
                message = this.getInfoResMessage("RET_RNE_NOT_EXISTED");
                break;
            }
            case 10129: {
                message = this.getInfoResMessage("RET_PLINK_NOT_EXIST");
                break;
            }
            case 10111: {
                message = this.getInfoResMessage("RET_CREATE_NE_EXTEND");
                break;
            }
            case 10112: {
                message = this.getInfoResMessage("RET_CREATE_SN_EXTEND");
                break;
            }
            case 10132: {
                message = this.getInfoResMessage("RET_CREATE_LINK_EXTEND");
                break;
            }
            case 10118: {
                message = this.getInfoResMessage("RET_EXTEND_CANNOT_DEL");
                break;
            }
            default: {
                message = this.getInfoResMessage("TSRESULT_SERVERERROR");
            }
        }
        logger.error((Object)(resultFlag + message));
        return message;
    }

    private String getNotRight(String rightName) {
        return MessageFormat.format(this.getInfoResMessage("DS_CANNOT_CREATE_SUBNET_RIGHT"), rightName);
    }

    public String processCommunicateErrorCode(int errorCode) {
        String errorMsg = null;
        switch (errorCode) {
            case 100: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_PRC_UNKNOW_ERROR");
                break;
            }
            case 101: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_PRC_INTERRUPTE_ERROR");
                break;
            }
            case 102: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_PRC_TIMEOUT_ERROR");
                break;
            }
            case 103: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_PRC_MOTH_NOT_FOUND_ERROR");
                break;
            }
            case 104: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_PRC_NOT_FOUND_ERROR");
                break;
            }
            case 105: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_PRC_SECURITY_ERROR");
                break;
            }
            case 111: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_MDP_UNKNOW_ERROR");
                break;
            }
            case 112: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_MDP_TIMEOUT_ERROR");
                break;
            }
            case 113: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_MDP_DISPATCH_ERROR");
                break;
            }
            case 114: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_MDP_TASKMGR_DISPATH_ERROR");
                break;
            }
            case 115: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_MDP_INTERRUPT_ERROR");
                break;
            }
            case 120: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_EM_UNKNOW_ERROR");
                break;
            }
            case 121: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_EM_TIMEOUT_ERROR");
                break;
            }
            case 122: {
                errorMsg = this.getInfoResMessage("COMMUNICATE_EM_INTERRUPT_ERROR");
                break;
            }
        }
        logger.error((Object)("error code = " + errorCode + "; error message = " + (errorMsg == null ? "is null." : errorMsg)));
        errorMsg = this.getInfoResMessage("COMMON_RPC_ERROR");
        return errorMsg;
    }

    public String processDSInfo(DataTable dsInfoTable, String className, String methodName, String rightName) {
        String errorMessage = null;
        if (dsInfoTable != null && dsInfoTable.size() > 0) {
            logger.error((Object)"DS sever have exception ! start");
            for (DataRecord record : dsInfoTable) {
                if ((errorMessage == null || "".equals(errorMessage)) && (record.get("TYPE") != null || record.get("TYPE").equals("ERROR"))) {
                    logger.error((Object)("ds error id = " + record.getInt("ID")));
                    errorMessage = this.processErrorCode(record.getInt("ID"), rightName);
                }
                logger.error((Object)record.get("SCENE"));
                if (record.get("STACK") == null && !"".equals(record.get("STACK"))) continue;
                logger.error((Object)record.get("STACK"));
            }
            logger.error((Object)"DS sever have exception ! end");
        }
        return errorMessage;
    }

    public String[] processFailInfo(DataTable table, String className, String methodName, String rightName) {
        String[] failMessages = null;
        if (table != null && table.size() > 0 && table.getName().trim().equals("FAILED_INFO")) {
            failMessages = new String[table.size()];
            int i = 0;
            for (DataRecord record : table) {
                if (record.get("ID") != null) {
                    failMessages[i] = MessageUtil.getInstance().processErrorCode(record.getInt("ERROR_CODE"), rightName);
                }
                StringBuffer buf = new StringBuffer();
                buf.append(record.get("ID"));
                buf.append(" | ");
                buf.append(record.get("ERROR_CODE"));
                buf.append(" | ");
                buf.append(record.get("ERROR_SOURCE"));
                buf.append(" | ");
                if (failMessages[i] == null) {
                    buf.append("");
                } else {
                    buf.append(failMessages[i]);
                }
                logger.error((Object)buf.toString());
                ++i;
            }
            return failMessages;
        }
        return failMessages;
    }

    public HashMap processFailInfoForDelete(DataTable table, String className, String methodName, String rightName) {
        HashMap<String, String> failMessages = new HashMap<String, String>();
        if (table != null && table.size() > 0 && table.getName().trim().equals("FAILED_INFO")) {
            int i = 0;
            for (DataRecord record : table) {
                String failMessage = null;
                if (record.get("ID") != null) {
                    failMessage = MessageUtil.getInstance().processErrorCode(record.getInt("ERROR_CODE"), rightName);
                    failMessages.put(record.get("ID"), failMessage);
                    StringBuffer buf = new StringBuffer();
                    buf.append(record.get("ID"));
                    buf.append(" | ");
                    buf.append(record.get("ERROR_CODE"));
                    buf.append(" | ");
                    buf.append(record.get("ERROR_SOURCE"));
                    buf.append(" | ");
                    if (failMessage == null) {
                        buf.append("");
                    } else {
                        buf.append(failMessage);
                    }
                    logger.error((Object)buf.toString());
                }
                ++i;
            }
            return failMessages;
        }
        return failMessages;
    }

    public DataTable processDsInfoForTable(String tableName, String rightName, DataTable param) {
        DataTable result = null;
        if (param != null) {
            try {
                result = new DataTable(tableName);
                result.setColumns(new String[]{"ID", "DESC"});
                int id = -1;
                for (DataRecord record : param) {
                    DataRecord element = new DataRecord(result);
                    id = record.getInt("ID");
                    element.set("ID", (Object)id);
                    element.set("DESC", (Object)this.processErrorCode(id, rightName));
                    result.add(element);
                }
            }
            catch (Exception e) {
                logger.error((Object)("parse " + tableName + "Exception "), (Throwable)e);
            }
        }
        return result;
    }

    public DataTable processErrorTable(String tableName, DataTable param) {
        DataTable result = null;
        if (param != null) {
            try {
                result = new DataTable(tableName);
                result.setColumns(new String[]{"ID", "DESC"});
                for (DataRecord record : param) {
                    DataRecord element = new DataRecord(result);
                    element.set("ID", (Object)record.get("ID"));
                    element.set("DESC", (Object)MessageUtil.getInstance().getInfoResMessage(record.get("ERROR_CODE")));
                    result.add(element);
                }
            }
            catch (Exception e) {
                logger.error((Object)("parse " + tableName + "Exception " + e.getMessage()));
            }
        }
        return result;
    }
}

