/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.rpc;

import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import com.swimap.external.resource.client.basicType.ResourceClientUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.innerimpl.ResourceBaseModule;
import com.swimap.resource.client.innerimpl.data.ResourceParseManagerImpl;
import com.swimap.resource.client.innerinterface.IResourceEventListener;
import java.util.Collection;

public final class ResourceRpcEventMgr
implements RpcServerPushHandler {
    private static final IviewLogger logger = IviewLogger.getLogger(ResourceRpcEventMgr.class, (String)"EAM");
    private static ResourceRpcEventMgr instance = new ResourceRpcEventMgr();
    private boolean hasOpen = false;
    private static final String EVENT_TYPE = "eam.ds.event";
    private static final String REFRESH_NE_TYPE = "eam.ds.update_ne";
    private static final String EVENT_TYPE_NAME = "eventtype";
    private static final String ADD_DYNAMIC_TYPE = "eam.ds.create_type";

    private ResourceRpcEventMgr() {
    }

    public static ResourceRpcEventMgr getInstance() {
        return instance;
    }

    public void open() {
        if (!this.hasOpen) {
            logger.debug((Object)"(Eam|RpcReceiverEventMgr)opened.");
            RpcServerPush.addHandler((String)EVENT_TYPE, (RpcServerPushHandler)this);
            this.hasOpen = true;
        }
    }

    public void close() {
        if (this.hasOpen) {
            logger.debug((Object)"(Eam|RpcReceiverEventMgr)closed.");
            RpcServerPush.removeHandler((RpcServerPushHandler)this);
            this.hasOpen = false;
        }
    }

    public void handleServerPush(RpcEvent event) {
        try {
            RpcMessage msg = event.getMessage();
            String eventType = msg.getString(EVENT_TYPE_NAME);
            logger.debug((Object)("event type : " + eventType));
            if (eventType.equals(ADD_DYNAMIC_TYPE)) {
                this.addDynamicType(msg);
            } else if (eventType.equals(REFRESH_NE_TYPE)) {
                ResourceParseManagerImpl.getInstance().refreshNeTypes();
            }
            if (ADD_DYNAMIC_TYPE.equals(eventType) || REFRESH_NE_TYPE.equals(eventType)) {
                this.sendTypeChangedEvent();
            }
        }
        catch (Exception e) {
            logger.error((Object)"process modify attribute error", (Throwable)e);
        }
    }

    private void addDynamicType(RpcMessage msg) {
        String type = msg.getString("objtype");
        logger.debug((Object)("type = " + type));
        DataTable table = msg.getTable("type");
        if (type.trim().equals("NE")) {
            DataTable filterTable = msg.getTable("FilterNeType");
            ResourceParseManagerImpl.getInstance().addDynamicNeType(table, filterTable);
        } else if (type.trim().equals("SUBNET")) {
            ResourceParseManagerImpl.getInstance().addDynamicSubnetType(table);
        } else if (type.trim().equals("LINK")) {
            ResourceParseManagerImpl.getInstance().addDynamicLinkType(table);
        }
    }

    private void sendTypeChangedEvent() {
        ResourceBaseModule resourceInterface = (ResourceBaseModule)ResourceClientUtil.getInstance().getResouceClientInterface();
        Collection<IResourceEventListener> listen = resourceInterface.getResourceEventListener();
        if (listen != null && !listen.isEmpty()) {
            for (IResourceEventListener resourceEventListener : listen) {
                try {
                    logger.debug((Object)("send type change event to " + resourceEventListener));
                    resourceEventListener.typeChanged();
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
    }
}

