/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.rpc;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.innerimpl.common.ClientRuntimeInfo;
import com.swimap.resource.client.innerimpl.common.ResourceClientException;
import com.swimap.resource.client.innerimpl.rpc.ResourceRpcDataIf;
import com.swimap.resource.client.innerimpl.util.MessageUtil;
import java.util.HashMap;
import java.util.Map;

public class ResourceRpcCommunicationMgr
implements ResourceRpcDataIf {
    private static final IviewLogger logger = IviewLogger.getLogger(ResourceRpcCommunicationMgr.class, (String)"EAM");

    @Override
    public DataTable getAllSubnetTypes() throws ResourceClientException {
        DataTable resultTables = null;
        try {
            String[] failMessages;
            String errorMessage;
            RpcRequest req = RpcNaming.createRequest((String)"eam.ds.getAllSubnetTypes");
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            DataTable table = msg.getTable("DS_INFO");
            if (table != null && table.size() > 0 && ((errorMessage = MessageUtil.getInstance().processDSInfo(table, "com.swimap.eam.client.control.rpccontrol.RpcCommunicationMgr", "getAllSubnetTypes", "")) != null || "".equals(errorMessage))) {
                logger.debug((Object)"Request all SubnetTypes information failed!");
                return null;
            }
            DataTable failedTable = msg.getTable("FAILED_INFO");
            if (failedTable != null && failedTable.size() > 0 && ((failMessages = MessageUtil.getInstance().processFailInfo(failedTable, "com.swimap.eam.client.control.rpccontrol.RpcCommunicationMgr", "getAllSubnetTypes", "")) == null || failMessages.length == 0)) {
                logger.debug((Object)"Get the failMessages of AllSubnetTypes is failed!");
                return null;
            }
            resultTables = msg.getTable("SubnetType");
        }
        catch (AppError e) {
            logger.error((Object)"has AppError! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo((Exception)((Object)e)), 140002L);
        }
        catch (RpcErrorSecurity e) {
            logger.error((Object)"has RpcErrorSecurity! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo((Exception)((Object)e)), e.getErrorCode());
        }
        catch (RpcError e) {
            logger.error((Object)"has RpcError! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo((Exception)((Object)e)), e.getErrorCode());
        }
        catch (Exception e) {
            logger.error((Object)"has Exception! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo(e), 140003L);
        }
        return resultTables;
    }

    @Override
    public DataTable getAllLinkTypes() throws ResourceClientException {
        DataTable resultTables = null;
        try {
            String[] failMessages;
            String errorMessage;
            RpcRequest req = RpcNaming.createRequest((String)"eam.ds.getAllLinkTypes");
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            DataTable table = msg.getTable("DS_INFO");
            if (table != null && table.size() > 0 && ((errorMessage = MessageUtil.getInstance().processDSInfo(table, "com.swimap.eam.client.control.rpccontrol.RpcCommunicationMgr", "getAllNeTypes", "")) != null || "".equals(errorMessage))) {
                logger.debug((Object)"Request all LinkTypes information failed!");
                return null;
            }
            DataTable failedTable = msg.getTable("FAILED_INFO");
            if (failedTable != null && failedTable.size() > 0 && ((failMessages = MessageUtil.getInstance().processFailInfo(failedTable, "com.swimap.eam.client.control.rpccontrol.RpcCommunicationMgr", "getAllNeTypes", "")) == null || failMessages.length == 0)) {
                logger.debug((Object)"Get the failMessages of AllLinkTypes is failed!");
                return null;
            }
            resultTables = msg.getTable("LinkType");
        }
        catch (AppError e) {
            logger.error((Object)"has AppError! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo((Exception)((Object)e)), 140004L);
        }
        catch (RpcErrorSecurity e) {
            logger.error((Object)"has RpcErrorSecurity! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo((Exception)((Object)e)), e.getErrorCode());
        }
        catch (RpcError e) {
            logger.error((Object)"has RpcError! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo((Exception)((Object)e)), e.getErrorCode());
        }
        catch (Exception e) {
            logger.error((Object)"has Exception! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo(e), 140005L);
        }
        return resultTables;
    }

    @Override
    public int[] getAllNoManager() throws ResourceClientException {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"eam.ds.prv.getNoManagedSubnetTypeIds");
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            return msg.getIntArray("MXUTYPEIDS");
        }
        catch (Exception e) {
            logger.error((Object)"Get NoManager Types From Ds has Exception! ", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, DataTable> getAllNeTypesAndDelID() throws ResourceClientException {
        HashMap<String, DataTable> resultMap = new HashMap<String, DataTable>();
        DataTable resultTables = null;
        DataTable deleteTables = null;
        try {
            String errorMessage;
            RpcRequest req = RpcNaming.createRequest((String)"eam.ds.getAllNeTypesNotFilter");
            req.addArgument("filterNeTypeID", (Object)1);
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            DataTable table = msg.getTable("DS_INFO");
            if (table != null && table.size() > 0 && ((errorMessage = MessageUtil.getInstance().processDSInfo(table, "com.swimap.eam.client.control.rpccontrol.RpcCommunicationMgr", "getAllNeTypesNotFilter", "")) != null || "".equals(errorMessage))) {
                logger.debug((Object)"Request all NeTypes information where before filter From Ds failed!");
                return null;
            }
            resultTables = msg.getTable("ALLNETYPENOTFILTER");
            deleteTables = msg.getTable("FilterNeTypeID");
            resultMap.put("allNodeType", resultTables);
            resultMap.put("deleteNeTypeIDs", deleteTables);
        }
        catch (AppError e) {
            logger.error((Object)"has AppError! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo((Exception)((Object)e)), 140000L);
        }
        catch (RpcErrorSecurity e) {
            logger.error((Object)"has RpcErrorSecurity! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo((Exception)((Object)e)), e.getErrorCode());
        }
        catch (RpcError e) {
            logger.error((Object)"has RpcError! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo((Exception)((Object)e)), e.getErrorCode());
        }
        catch (Exception e) {
            logger.error((Object)"has Exception! ", (Throwable)e);
            throw new ResourceClientException(MessageUtil.getInstance().getInfoResMessage("COMMON_RPC_ERROR"), ClientRuntimeInfo.getEamRunInfo(e), 140001L);
        }
        return resultMap;
    }
}

