/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.data;

import com.swimap.external.resource.client.basicType.AlarmLevel;
import com.swimap.external.resource.client.basicType.ContainAlarmStateType;
import com.swimap.external.resource.client.basicType.ResourceType;
import com.swimap.external.resource.client.basicType.SubnetType;
import com.swimap.external.resource.client.basicType.ValueNameIcon;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.impl.NETypeImpl;
import com.swimap.resource.client.impl.SubnetTypeImpl;
import com.swimap.resource.client.innerimpl.data.ResourceParseManagerImpl;
import com.swimap.resource.client.innerinterface.IInnerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ValueNameIconManager {
    private static final IviewLogger logger = IviewLogger.getLogger(ValueNameIconManager.class, (String)"EAM");
    private LinkedList<ValueNameIcon> allSubnetTypeLinkedList = new LinkedList();
    private LinkedList<ValueNameIcon> physicalSubnetTypeLinkedList = new LinkedList();
    private LinkedList<ValueNameIcon> logicalSubnetTypeLinkedList = new LinkedList();
    private LinkedList<ValueNameIcon> nodeTypeLinkedList = new LinkedList();
    private Map<Integer, ImageIcon> nodeTypeToIconMap = new ConcurrentHashMap<Integer, ImageIcon>();
    private LinkedList<ValueNameIcon> linkTypeLinkedList = new LinkedList();
    private Map<Integer, ImageIcon> linkTypeToIconMap = new ConcurrentHashMap<Integer, ImageIcon>();
    private LinkedList<ValueNameIcon> alarmLinkedList = new LinkedList();
    private LinkedList<ValueNameIcon> containAlarmLinkedList = new LinkedList();
    private ValueNameIcon physicalRootIcon = null;
    private ValueNameIcon physicalRootDefaultIcon = null;
    private ValueNameIcon logicalRootIcon = null;
    private ValueNameIcon logicalRootDefaultIcon = null;
    private static ValueNameIconManager instance = new ValueNameIconManager();

    private ValueNameIconManager() {
    }

    public static ValueNameIconManager getInstance() {
        return instance;
    }

    public void initTypeToValueNameIcon() {
        logger.debug((Object)"resource valueNameIcon initTypeToValueNameIcon start");
        try {
            this.initSubnetTypeToValueNameIcon();
            this.initNeTypeToValueNameIcon();
            this.initLinkTypeToValueNameIcon();
            this.initAlarmAndContainAlarmTypeToValueNameIcon();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        logger.debug((Object)"resource valueNameIcon initTypeToValueNameIcon end");
    }

    public synchronized void initNeTypeToValueNameIcon() {
        ArrayList<ValueNameIcon> nameIcons = new ArrayList<ValueNameIcon>();
        HashMap<Integer, String> oldTypeTreeName = new HashMap<Integer, String>();
        for (ValueNameIcon icon : this.nodeTypeLinkedList) {
            oldTypeTreeName.put(icon.getValue(), icon.getTypeTreeName());
        }
        this.nodeTypeLinkedList.clear();
        this.nodeTypeToIconMap.clear();
        ResourceType[] resouceTypes = ResourceParseManagerImpl.getInstance().getAllNETypes();
        this.initNodeIconByType(resouceTypes, nameIcons, oldTypeTreeName);
        this.nodeTypeLinkedList.addAll(nameIcons);
        this.initNodeToIconMap();
    }

    private void initNodeToIconMap() {
        this.initNodeToIconMap(this.nodeTypeLinkedList);
    }

    private synchronized void initNodeToIconMap(List<ValueNameIcon> nodeTypes) {
        for (ValueNameIcon icon : nodeTypes) {
            if (!"label".equals(icon.getKey())) continue;
            this.nodeTypeToIconMap.put(icon.getValue(), icon.getTreeIcon());
        }
    }

    public synchronized void refreshNETypeImage(ResourceType resourceType) {
        try {
            if (resourceType == null) {
                return;
            }
            long l = System.currentTimeMillis();
            ArrayList<ValueNameIcon> nameIcons = new ArrayList<ValueNameIcon>();
            HashMap<Integer, String> oldTypeTreeName = new HashMap<Integer, String>();
            Iterator it = this.nodeTypeLinkedList.iterator();
            while (it.hasNext()) {
                ValueNameIcon icon = (ValueNameIcon)it.next();
                if (icon.getValue() != resourceType.getId()) continue;
                oldTypeTreeName.put(icon.getValue(), icon.getTypeTreeName());
                it.remove();
            }
            this.initNodeIconByType(new ResourceType[]{resourceType}, nameIcons, oldTypeTreeName);
            this.nodeTypeLinkedList.addAll(nameIcons);
            this.initNodeToIconMap(nameIcons);
            logger.debug((Object)("refresh ValueNameIcon " + resourceType.getId() + " cost " + (System.currentTimeMillis() - l)));
        }
        catch (Exception e) {
            logger.error((Object)"refresh ValueNameIcon failed", (Throwable)e);
        }
    }

    private synchronized void initLinkToIconMap() {
        for (ValueNameIcon icon : this.linkTypeLinkedList) {
            this.linkTypeToIconMap.put(icon.getValue(), icon.getTreeIcon());
        }
    }

    public void initSubnetTypeToValueNameIcon() {
        SubnetType subnetType = ResourceParseManagerImpl.getInstance().getSubentType(0);
        if (subnetType != null) {
            this.physicalRootIcon = this.physicalRootDefaultIcon = new ValueNameIcon(subnetType.getId(), subnetType.getLabel(), subnetType.getTreeIcon(), subnetType.getMapIcon(), "", subnetType.getLabel(), "label");
        }
        if ((subnetType = ResourceParseManagerImpl.getInstance().getSubentType(1)) != null) {
            this.logicalRootIcon = this.logicalRootDefaultIcon = new ValueNameIcon(subnetType.getId(), subnetType.getLabel(), subnetType.getTreeIcon(), subnetType.getMapIcon(), "", subnetType.getLabel(), "label");
        }
        ArrayList<ValueNameIcon> nameIcons = new ArrayList<ValueNameIcon>();
        ResourceType[] resouceTypes = ResourceParseManagerImpl.getInstance().getAllSubnetTypes();
        this.allSubnetTypeLinkedList.clear();
        this.initNodeIconByType(resouceTypes, nameIcons, null);
        this.allSubnetTypeLinkedList.addAll(nameIcons);
        this.physicalSubnetTypeLinkedList.clear();
        nameIcons.clear();
        resouceTypes = ResourceParseManagerImpl.getInstance().getSubnetTypeByKind(0);
        this.initNodeIconByType(resouceTypes, nameIcons, null);
        this.physicalSubnetTypeLinkedList.addAll(nameIcons);
        this.logicalSubnetTypeLinkedList.clear();
        nameIcons.clear();
        resouceTypes = ResourceParseManagerImpl.getInstance().getSubnetTypeByKind(1);
        this.initNodeIconByType(resouceTypes, nameIcons, null);
        this.logicalSubnetTypeLinkedList.addAll(nameIcons);
    }

    public void initLinkTypeToValueNameIcon() {
        ArrayList<ValueNameIcon> nameIcons = new ArrayList<ValueNameIcon>();
        HashMap<Integer, String> oldTypeTreeName = new HashMap<Integer, String>();
        for (ValueNameIcon icon : this.linkTypeLinkedList) {
            oldTypeTreeName.put(icon.getValue(), icon.getTypeTreeName());
        }
        this.linkTypeLinkedList.clear();
        this.linkTypeToIconMap.clear();
        ResourceType[] resouceTypes = ResourceParseManagerImpl.getInstance().getAllLinkTypes();
        this.initNodeIconByType(resouceTypes, nameIcons, oldTypeTreeName);
        this.linkTypeLinkedList.addAll(nameIcons);
        this.initLinkToIconMap();
    }

    public void initAlarmAndContainAlarmTypeToValueNameIcon() {
        this.containAlarmToValueNameIcon();
        this.alarmToValueNameIcon();
    }

    private void initNodeIconByType(ResourceType[] objectTypes, List<ValueNameIcon> nameIcons, Map<Integer, String> oldTypeTreeName) {
        if (objectTypes != null && objectTypes.length > 0) {
            for (int i = 0; i < objectTypes.length; ++i) {
                IInnerType typeImpl = (IInnerType)objectTypes[i];
                HashMap<String, Icon> treeIcons = typeImpl.getTreeIcons();
                HashMap<String, Icon> mapIcons = typeImpl.getMapIcons();
                for (Map.Entry<String, Icon> entry : treeIcons.entrySet()) {
                    String key = entry.getKey();
                    String name = typeImpl.getLabel();
                    if (!"label".equals(key) && typeImpl.getProperty(key) != null && !typeImpl.getProperty(key).trim().equals("")) {
                        name = typeImpl.getProperty(key);
                    }
                    ValueNameIcon tempNameIcon = new ValueNameIcon(typeImpl.getId(), name, (ImageIcon)treeIcons.get(key), (ImageIcon)mapIcons.get(key), "", typeImpl.getLabel(), key);
                    tempNameIcon.setParentType(typeImpl.getParentTypeID());
                    tempNameIcon.setIsAllowCreateByClient(typeImpl.isAllowCreateByClient());
                    tempNameIcon.setType_name(typeImpl.getName());
                    tempNameIcon.setDefaultMapIcon(typeImpl.getMapIcon());
                    tempNameIcon.setDefaultTreeIcon(typeImpl.getTreeIcon());
                    if (typeImpl instanceof SubnetTypeImpl) {
                        tempNameIcon.setHidden(((SubnetTypeImpl)typeImpl).isHidden());
                    } else if (typeImpl instanceof NETypeImpl) {
                        tempNameIcon.setClockType(((NETypeImpl)typeImpl).isLockNode());
                    }
                    if (oldTypeTreeName != null && oldTypeTreeName.containsKey(tempNameIcon.getValue())) {
                        tempNameIcon.setTypeTreeName(oldTypeTreeName.get(tempNameIcon.getValue()));
                    } else {
                        tempNameIcon.setTypeTreeName(typeImpl.getTreePath());
                    }
                    nameIcons.add(tempNameIcon);
                }
            }
        }
    }

    private void containAlarmToValueNameIcon() {
        this.containAlarmLinkedList.clear();
        ContainAlarmStateType[] containAlarmStateTypes = ResourceParseManagerImpl.getInstance().getAllContainAlarmStateTypes();
        if (containAlarmStateTypes != null) {
            ValueNameIcon valueNameIcon = null;
            for (int i = 0; i < containAlarmStateTypes.length; ++i) {
                valueNameIcon = new ValueNameIcon(containAlarmStateTypes[i].getId(), containAlarmStateTypes[i].getLabel(), containAlarmStateTypes[i].getLabel(), "label", containAlarmStateTypes[i].getImageIcon());
                this.containAlarmLinkedList.add(valueNameIcon);
            }
        }
    }

    private void alarmToValueNameIcon() {
        this.alarmLinkedList.clear();
        AlarmLevel[] alarmLevels = ResourceParseManagerImpl.getInstance().getAlarmLevels();
        if (alarmLevels != null) {
            ValueNameIcon valueNameIcon = null;
            for (int i = 0; i < alarmLevels.length; ++i) {
                valueNameIcon = new ValueNameIcon(alarmLevels[i].getId(), alarmLevels[i].getLabel(), alarmLevels[i].getSynopsis(), alarmLevels[i].getLabel(), "label");
                this.alarmLinkedList.add(valueNameIcon);
            }
        }
    }

    public ValueNameIcon getPhysicalRootIcon() {
        return this.physicalRootIcon;
    }

    public ValueNameIcon[] getAllSubnetTypes() {
        return this.getAll(this.allSubnetTypeLinkedList);
    }

    public ValueNameIcon[] getAllPhysicalSubnetTypes() {
        return this.getAll(this.physicalSubnetTypeLinkedList);
    }

    public ValueNameIcon[] getAllLogicalSubnetTypes() {
        return this.getAll(this.logicalSubnetTypeLinkedList);
    }

    public synchronized ValueNameIcon[] getAllNodeTypes() {
        return this.getAll(this.nodeTypeLinkedList);
    }

    public ValueNameIcon[] getAllLinkTypes() {
        return this.getAll(this.linkTypeLinkedList);
    }

    public ValueNameIcon getContainAlarm(int containAlarmValue) {
        return this.get(this.containAlarmLinkedList, containAlarmValue);
    }

    public ValueNameIcon[] getAllContainAlarms() {
        return this.getAll(this.containAlarmLinkedList);
    }

    public ValueNameIcon[] getAllAlarms() {
        return this.getAll(this.alarmLinkedList);
    }

    public ValueNameIcon getLogicalRootIcon() {
        return this.logicalRootIcon;
    }

    public ValueNameIcon getPhysicalSubnetType(String typeName) {
        return this.get(this.physicalSubnetTypeLinkedList, typeName);
    }

    public ValueNameIcon getPhysicalSubnetType(int typeValue) {
        return this.get(this.physicalSubnetTypeLinkedList, typeValue);
    }

    public ValueNameIcon getLogicalSubnetType(String typeName) {
        return this.get(this.logicalSubnetTypeLinkedList, typeName);
    }

    public ValueNameIcon getLogicalSubnetType(int typeValue) {
        return this.get(this.logicalSubnetTypeLinkedList, typeValue);
    }

    public synchronized ValueNameIcon getNodeType(String typeName) {
        return this.get(this.nodeTypeLinkedList, typeName);
    }

    public synchronized ValueNameIcon getNodeType(int typeValue) {
        return this.get(this.nodeTypeLinkedList, typeValue);
    }

    public ValueNameIcon getSubnetType(int typeValue) {
        return this.get(this.allSubnetTypeLinkedList, typeValue);
    }

    public ValueNameIcon getLinkType(String typeName) {
        return this.get(this.linkTypeLinkedList, typeName);
    }

    public ValueNameIcon getLinkType(int typeValue) {
        return this.get(this.linkTypeLinkedList, typeValue);
    }

    public ValueNameIcon getAlarm(int alarmValue) {
        return this.get(this.alarmLinkedList, alarmValue);
    }

    private ValueNameIcon[] getAll(Collection collection) {
        ValueNameIcon[] valueNameIcons = new ValueNameIcon[collection.size()];
        collection.toArray(valueNameIcons);
        return valueNameIcons;
    }

    private ValueNameIcon get(LinkedList<ValueNameIcon> collection, int value) {
        for (ValueNameIcon valueNameIcon : collection) {
            if (valueNameIcon.getValue() != value) continue;
            return valueNameIcon;
        }
        return null;
    }

    public synchronized ImageIcon getNodeIconByType(int typeId) {
        return this.nodeTypeToIconMap.get(typeId);
    }

    public synchronized ImageIcon getLinkIconByType(int typeId) {
        return this.linkTypeToIconMap.get(typeId);
    }

    private ValueNameIcon get(Collection collection, String name) {
        for (ValueNameIcon valueNameIcon : collection) {
            if (!valueNameIcon.getName().equals(name)) continue;
            return valueNameIcon;
        }
        return null;
    }

    public void clear() {
        this.allSubnetTypeLinkedList.clear();
        this.physicalSubnetTypeLinkedList.clear();
        this.logicalSubnetTypeLinkedList.clear();
        this.nodeTypeLinkedList.clear();
        this.nodeTypeToIconMap.clear();
        this.linkTypeLinkedList.clear();
        this.linkTypeToIconMap.clear();
        this.alarmLinkedList.clear();
        this.containAlarmLinkedList.clear();
        this.physicalRootIcon = null;
        this.physicalRootDefaultIcon = null;
        this.logicalRootIcon = null;
        this.logicalRootDefaultIcon = null;
    }
}

