/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.data;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.innerimpl.util.ResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class SerialIconManagerImpl {
    private static final IviewLogger logger = IviewLogger.getLogger(SerialIconManagerImpl.class, (String)"EAM");
    private static final String serIconName = "serialIcon.dat";
    private static String ICON_FILE_DIR = null;
    private static String ICON_FILE_PATH = null;
    private static Map<String, ImageIcon> imageMap = new HashMap<String, ImageIcon>();
    private static boolean bImageMapModified = false;
    private static SerialIconManagerImpl serialIconImpl = null;
    private static Plugin plugin = ResourceUtil.getInstance().getResouceModulePlugin();

    public static synchronized SerialIconManagerImpl getInstance() {
        if (serialIconImpl == null) {
            serialIconImpl = new SerialIconManagerImpl();
            return serialIconImpl;
        }
        return serialIconImpl;
    }

    private SerialIconManagerImpl() {
        this.initSerialIcon();
    }

    public void initReadSerialIcon() {
        this.readIconSerFile();
    }

    private void initSerialIcon() {
        String locale = ResourceMng.getInstance().getLocale().toString();
        String szSeparator = System.getProperty("file.separator");
        ICON_FILE_DIR = new StringBuffer().append(System.getProperty("user.dir")).append(szSeparator).append("configuration").append(szSeparator).append("topoicon").append(szSeparator).append("locale").append(szSeparator).append(locale).toString();
        ICON_FILE_PATH = new StringBuffer(ICON_FILE_DIR).append(szSeparator).append(serIconName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIconSerFile() {
        block17: {
            try {
                File file = new File(ICON_FILE_PATH);
                if (!file.exists()) break block17;
                ObjectInputStream in = null;
                FileInputStream fileStream = null;
                try {
                    fileStream = new FileInputStream(file);
                    in = new ObjectInputStream(fileStream);
                    imageMap = (HashMap)in.readObject();
                    bImageMapModified = false;
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"", (Throwable)ex);
                    }
                    try {
                        if (fileStream != null) {
                            fileStream.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"", (Throwable)ex);
                    }
                }
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIconSerFile() {
        if (!bImageMapModified) {
            return;
        }
        ObjectOutput out = null;
        FileOutputStream outputStream = null;
        try {
            File filePath;
            File fileDir = new File(ICON_FILE_DIR);
            if (!fileDir.exists()) {
                fileDir.mkdirs();
            }
            if ((filePath = new File(ICON_FILE_PATH)).exists()) {
                filePath.delete();
            }
            outputStream = new FileOutputStream(ICON_FILE_PATH);
            out = new ObjectOutputStream(outputStream);
            out.writeObject(imageMap);
            bImageMapModified = false;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public ImageIcon getIcon(String iconFileName) {
        return this.getIcon(iconFileName, true);
    }

    public ImageIcon getIcon(String iconFileName, boolean needUnknowIcon) {
        if (imageMap.containsKey(iconFileName)) {
            return imageMap.get(iconFileName);
        }
        ImageIcon result = ResourceUtil.getInstance().getResourceImage(iconFileName);
        if (result == null || result.getIconWidth() <= 0) {
            result = needUnknowIcon ? ResourceUtil.unknowtypeicon : ResourceUtil.emptyIcon;
        } else {
            imageMap.put(iconFileName, result);
            bImageMapModified = true;
        }
        return result;
    }

    public static synchronized void clear() {
        SerialIconManagerImpl.writeIconSerFile();
        imageMap.clear();
        serialIconImpl = null;
    }
}

